/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image.ico.spi;

import com.ctreber.aclib.image.ImageInputStreamDecoder;
import com.ctreber.aclib.image.ico.BitmapDescriptor;
import com.ctreber.aclib.image.ico.ICOFile;
import com.ctreber.aclib.image.ico.spi.ICOImageReaderSPI;
import com.ctreber.aclib.image.ico.spi.ICOMetaData;
import java.awt.Container;
import java.awt.color.ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ICOReader
extends ImageReader {
    private static final int[] ONE = new int[1];
    protected ICOFile _icoFile;
    protected ImageInputStream _stream;

    public ICOReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public int getHeight(int n) {
        return this.getICOEntry(n).getHeight();
    }

    public IIOMetadata getImageMetadata(int n) {
        return new ICOMetaData(this.getICOEntry(n));
    }

    public Iterator getImageTypes(int n) {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        int n2 = 0;
        while (n2 < this.getNumImages(false)) {
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), ONE, 0, false, false);
            arrayList.add(imageTypeSpecifier);
            ++n2;
        }
        return arrayList.iterator();
    }

    public int getNumImages(boolean bl) {
        return this.getICOFile().getImageCount();
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public int getWidth(int n) {
        return this.getICOEntry(n).getWidth();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) {
        return this.getICOEntry(n).getBitmap().createImageRGB();
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        if (!(object instanceof ImageInputStream)) {
            throw new IllegalArgumentException("Only ImageInputStream supported as input source");
        }
        this._stream = (ImageInputStream)object;
    }

    private ICOFile getICOFile() {
        if (this._icoFile == null) {
            try {
                this._icoFile = new ICOFile("[ImageInputStream]", new ImageInputStreamDecoder(this._stream));
            }
            catch (IOException iOException) {
                System.err.println("Can't create ICOFile: " + iOException.getMessage());
            }
        }
        return this._icoFile;
    }

    private BitmapDescriptor getICOEntry(int n) {
        return (BitmapDescriptor)this.getICOFile().getDescriptors().get(n);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Please specify the icon file name");
            System.exit(1);
        }
        IIORegistry.getDefaultInstance().registerServiceProvider(new ICOImageReaderSPI());
        ICOReader.listServiceProviders();
        File file = ICOReader.getICOFile(stringArray);
        ImageReader imageReader = ICOReader.getICOReader();
        imageReader.setInput(ImageIO.createImageInputStream(file));
        String string = file.getName();
        JFrame jFrame = ICOReader.createWindow(string);
        int n = imageReader.getNumImages(true);
        int n2 = 0;
        while (n2 < n) {
            ICOReader.addImage(jFrame.getContentPane(), imageReader, n2);
            ++n2;
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static File getICOFile(String[] stringArray) {
        String string = stringArray[0];
        File file = new File(string);
        if (!file.isFile()) {
            System.err.println(String.valueOf(string) + " not found, or is no file");
            System.exit(1);
        }
        return file;
    }

    private static ImageReader getICOReader() {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("ico");
        if (iterator == null || !iterator.hasNext()) {
            System.err.println("No reader for format 'ICO' found");
            System.exit(1);
        }
        return iterator.next();
    }

    private static JFrame createWindow(String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(2);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        BoxLayout boxLayout = new BoxLayout(jFrame.getContentPane(), 1);
        jFrame.getContentPane().setLayout(boxLayout);
        return jFrame;
    }

    private static void addImage(Container container, ImageReader imageReader, int n) throws IOException {
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(imageReader.read(n)));
        jButton.setText(imageReader.getWidth(n) + "x" + imageReader.getHeight(n));
        container.add(jButton);
    }

    public static void listServiceProviders() {
        System.out.println("Registered image formats and their providers");
        String[] stringArray = ImageIO.getReaderFormatNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
            while (iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                ImageReaderSpi imageReaderSpi = imageReader.getOriginatingProvider();
                System.out.println(" o " + string + " (" + imageReaderSpi.getDescription(Locale.getDefault()) + ") by " + imageReaderSpi.getVendorName());
            }
            ++n;
        }
    }
}

