/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.collections.ReferenceMap;
import org.jivesoftware.smackx.ChatState;
import org.jivesoftware.smackx.ChatStateListener;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.ChatStateExtension;

public class ChatStateManager {
    private static final Map<Connection, WeakReference<ChatStateManager>> managers = new WeakHashMap<Connection, WeakReference<ChatStateManager>>();
    private static final PacketFilter filter = new NotFilter(new PacketExtensionFilter("http://jabber.org/protocol/chatstates"));
    private final Connection connection;
    private final OutgoingMessageInterceptor outgoingInterceptor = new OutgoingMessageInterceptor();
    private final IncomingMessageInterceptor incomingInterceptor = new IncomingMessageInterceptor();
    private final Map<Chat, ChatState> chatStates = new ReferenceMap<Chat, ChatState>(2, 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChatStateManager getInstance(Connection connection) {
        if (connection == null) {
            return null;
        }
        Map<Connection, WeakReference<ChatStateManager>> map = managers;
        synchronized (map) {
            ChatStateManager manager;
            WeakReference<ChatStateManager> ref = managers.get(connection);
            if (ref == null) {
                manager = new ChatStateManager(connection);
                manager.init();
                managers.put(connection, new WeakReference<ChatStateManager>(manager));
            } else {
                manager = (ChatStateManager)ref.get();
            }
            return manager;
        }
    }

    private ChatStateManager(Connection connection) {
        this.connection = connection;
    }

    private void init() {
        this.connection.getChatManager().addOutgoingMessageInterceptor(this.outgoingInterceptor, filter);
        this.connection.getChatManager().addChatListener(this.incomingInterceptor);
        ServiceDiscoveryManager.getInstanceFor(this.connection).addFeature("http://jabber.org/protocol/chatstates");
    }

    public void setCurrentState(ChatState newState, Chat chat) throws XMPPException {
        if (chat == null || newState == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, newState)) {
            return;
        }
        Message message = new Message();
        ChatStateExtension extension = new ChatStateExtension(newState);
        message.addExtension(extension);
        chat.sendMessage(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatStateManager that = (ChatStateManager)o;
        return this.connection.equals(that.connection);
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    private boolean updateChatState(Chat chat, ChatState newState) {
        ChatState lastChatState = this.chatStates.get(chat);
        if (lastChatState != newState) {
            this.chatStates.put(chat, newState);
            return true;
        }
        return false;
    }

    private void fireNewChatState(Chat chat, ChatState state, Message message) {
        for (MessageListener listener : chat.getListeners()) {
            if (!(listener instanceof ChatStateListener)) continue;
            ((ChatStateListener)listener).stateChanged(chat, state, message);
        }
    }

    private class IncomingMessageInterceptor
    implements ChatManagerListener,
    MessageListener {
        private IncomingMessageInterceptor() {
        }

        public void chatCreated(Chat chat, boolean createdLocally) {
            chat.addMessageListener(this);
        }

        public void processMessage(Chat chat, Message message) {
            ChatState state;
            PacketExtension extension = message.getExtension("http://jabber.org/protocol/chatstates");
            if (extension == null) {
                return;
            }
            try {
                state = ChatState.valueOf(extension.getElementName());
            }
            catch (Exception ex) {
                return;
            }
            ChatStateManager.this.fireNewChatState(chat, state, message);
        }
    }

    private class OutgoingMessageInterceptor
    implements PacketInterceptor {
        private OutgoingMessageInterceptor() {
        }

        public void interceptPacket(Packet packet) {
            Message message = (Message)packet;
            Chat chat = ChatStateManager.this.connection.getChatManager().getThreadChat(message.getThread());
            if (chat == null) {
                return;
            }
            if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                message.addExtension(new ChatStateExtension(ChatState.active));
            }
        }
    }
}

