/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.table.TableColumn;

class StripedViewportBorder
extends AbstractBorder {
    private final JViewport fViewport;
    private final JTable fTable;
    private final Color fStripeColor;

    StripedViewportBorder(JViewport viewport, JTable table, Color stripeColor) {
        this.fViewport = viewport;
        this.fTable = table;
        this.fStripeColor = stripeColor;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintStripedBackground(g);
        this.paintVerticalGridLines(g, y, height);
    }

    private void paintStripedBackground(Graphics g) {
        int currentRow;
        Rectangle clip = g.getClipBounds();
        Point viewPosition = this.fViewport.getViewPosition();
        int rowAtPoint = this.fTable.rowAtPoint(viewPosition);
        int topY = rowAtPoint < 0 ? clip.y : this.fTable.getCellRect((int)rowAtPoint, (int)0, (boolean)true).y - viewPosition.y;
        int n = currentRow = rowAtPoint < 0 ? 0 : rowAtPoint;
        while (topY < clip.y + clip.height) {
            int bottomY = topY + this.fTable.getRowHeight();
            g.setColor(this.getRowColor(currentRow));
            g.fillRect(clip.x, topY, clip.width, bottomY);
            topY = bottomY;
            ++currentRow;
        }
    }

    private Color getRowColor(int row) {
        return row % 2 == 0 ? this.fStripeColor : this.fTable.getBackground();
    }

    private void paintVerticalGridLines(Graphics g, int y, int height) {
        int x = 0 - this.fViewport.getViewPosition().x;
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            TableColumn column = this.fTable.getColumnModel().getColumn(i);
            g.setColor(this.fTable.getGridColor());
            g.drawLine((x += column.getWidth()) - 1, y, x - 1, y + height);
        }
    }
}

