/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.fileaccess;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;
import org.jitsi.impl.fileaccess.FailSafeTransactionImpl;
import org.jitsi.impl.fileaccess.TempFileManager;
import org.jitsi.service.fileaccess.FailSafeTransaction;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public class FileAccessServiceImpl
implements FileAccessService {
    private static final Logger logger = Logger.getLogger(FileAccessServiceImpl.class);
    public static final String TEMP_FILE_PREFIX = "SIPCOMM";
    public static final String TEMP_FILE_SUFFIX = "TEMP";
    private final String scHomeDirLocation = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
    private final String scHomeDirName;

    public FileAccessServiceImpl() {
        if (this.scHomeDirLocation == null) {
            throw new IllegalStateException("net.java.sip.communicator.SC_HOME_DIR_LOCATION");
        }
        this.scHomeDirName = FileAccessServiceImpl.getSystemProperty("net.java.sip.communicator.SC_HOME_DIR_NAME");
        if (this.scHomeDirName == null) {
            throw new IllegalStateException("net.java.sip.communicator.SC_HOME_DIR_NAME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getTemporaryFile() throws IOException {
        File retVal = null;
        try {
            logger.logEntry();
            retVal = TempFileManager.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        finally {
            logger.logExit();
        }
        return retVal;
    }

    public File getTemporaryDirectory() throws IOException {
        File file = this.getTemporaryFile();
        if (!file.delete()) {
            throw new IOException("Could not create temporary directory, because: could not delete temporary file.");
        }
        if (!file.mkdirs()) {
            throw new IOException("Could not create temporary directory");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPrivatePersistentFile(String fileName) throws Exception {
        File file = null;
        try {
            logger.logEntry();
            String fullPath = this.getFullPath(fileName);
            file = FileAccessServiceImpl.accessibleFile(fullPath, fileName);
            if (file == null) {
                throw new SecurityException("Insufficient rights to access this file in current user's home directory: " + new File(fullPath, fileName).getPath());
            }
        }
        finally {
            logger.logExit();
        }
        return file;
    }

    public File getPrivatePersistentDirectory(String dirName) throws Exception {
        String fullPath = this.getFullPath(dirName);
        File dir = new File(fullPath, dirName);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new RuntimeException("Could not create directory because: A file exists with this name:" + dir.getAbsolutePath());
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Could not create directory");
        }
        return dir;
    }

    public File getPrivatePersistentDirectory(String[] dirNames) throws Exception {
        StringBuilder dirName = new StringBuilder();
        for (int i = 0; i < dirNames.length; ++i) {
            if (i > 0) {
                dirName.append(File.separatorChar);
            }
            dirName.append(dirNames[i]);
        }
        return this.getPrivatePersistentDirectory(dirName.toString());
    }

    private String getFullPath(String fileName) {
        String userhome = this.getScHomeDirLocation();
        String sipSubdir = this.getScHomeDirName();
        if (!userhome.endsWith(File.separator)) {
            userhome = userhome + File.separator;
        }
        if (!sipSubdir.endsWith(File.separator)) {
            sipSubdir = sipSubdir + File.separator;
        }
        return userhome + sipSubdir;
    }

    private String getScHomeDirName() {
        String scHomeDirName = this.scHomeDirName;
        if (scHomeDirName == null) {
            scHomeDirName = ".sip-communicator";
        }
        return scHomeDirName;
    }

    private String getScHomeDirLocation() {
        String scHomeDirLocation = this.scHomeDirLocation;
        if (scHomeDirLocation == null) {
            scHomeDirLocation = FileAccessServiceImpl.getSystemProperty("user.home");
        }
        return scHomeDirLocation;
    }

    private static String getSystemProperty(String propertyName) {
        String retval = System.getProperty(propertyName);
        if (retval == null) {
            return retval;
        }
        if (retval.trim().length() == 0) {
            return null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File accessibleFile(String homedir, String fileName) throws IOException {
        File file = null;
        try {
            logger.logEntry();
            homedir = homedir.trim();
            if (!homedir.endsWith(File.separator)) {
                homedir = homedir + File.separator;
            }
            if ((file = new File(homedir + fileName)).canRead() || file.canWrite()) {
                File file2 = file;
                return file2;
            }
            File homedirFile = new File(homedir);
            if (!homedirFile.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating home directory : " + homedirFile.getAbsolutePath());
                }
                if (!homedirFile.mkdirs()) {
                    String message = "Could not create the home directory : " + homedirFile.getAbsolutePath();
                    if (logger.isDebugEnabled()) {
                        logger.debug(message);
                    }
                    throw new IOException(message);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Home directory created : " + homedirFile.getAbsolutePath());
                }
            } else if (!homedirFile.canWrite()) {
                file = null;
            }
            if (file != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                String message = "Could not create the parent directory : " + homedirFile.getAbsolutePath();
                if (logger.isDebugEnabled()) {
                    logger.debug(message);
                }
                throw new IOException(message);
            }
        }
        finally {
            logger.logExit();
        }
        return file;
    }

    public File getDefaultDownloadDirectory() throws IOException {
        File downloadDir;
        if (OSUtils.IS_WINDOWS && FileAccessServiceImpl.getMajorOSVersion() <= 5) {
            downloadDir = FileSystemView.getFileSystemView().getHomeDirectory();
        } else {
            String defaultLocation = FileAccessServiceImpl.getSystemProperty("user.home") + File.separatorChar + "Downloads";
            downloadDir = new File(defaultLocation);
        }
        return downloadDir;
    }

    private static int getMajorOSVersion() {
        int majorOSVersion;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null && osVersion.length() > 0) {
            int majorOSVersionEnd = osVersion.indexOf(46);
            String majorOSVersionString = majorOSVersionEnd > -1 ? osVersion.substring(0, majorOSVersionEnd) : osVersion;
            majorOSVersion = Integer.parseInt(majorOSVersionString);
        } else {
            majorOSVersion = 0;
        }
        return majorOSVersion;
    }

    public FailSafeTransaction createFailSafeTransaction(File file) {
        return file == null ? null : new FailSafeTransactionImpl(file);
    }
}

