/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import org.ice4j.socket.DatagramPacketFilter;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.OSUtils;

public abstract class RTPConnectorInputStream
implements PushSourceStream,
Runnable {
    private static final Object[] EMPTY_CONTROLS = new Object[0];
    private static final int PACKET_RECEIVE_BUFFER_LENGTH = 4096;
    private final byte[] buffer = new byte[4096];
    protected boolean closed;
    protected boolean ioError = false;
    protected RawPacket pkt;
    private SourceTransferHandler transferHandler;
    protected Thread receiverThread = null;
    private DatagramPacketFilter[] datagramPacketFilters;

    public RTPConnectorInputStream() {
        this.addDatagramPacketFilter(new DatagramPacketFilter(){
            private long numberOfPackets = 0L;

            public boolean accept(DatagramPacket p) {
                PacketLoggingService packetLogging;
                ++this.numberOfPackets;
                if (RTPConnectorOutputStream.logPacket(this.numberOfPackets) && (packetLogging = LibJitsi.getPacketLoggingService()) != null && packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) {
                    RTPConnectorInputStream.this.doLogPacket(p);
                }
                return true;
            }
        });
    }

    public synchronized void close() {
    }

    protected RawPacket createRawPacket(DatagramPacket datagramPacket) {
        if (this.pkt == null) {
            return new RawPacket(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
        }
        this.pkt.setBuffer(datagramPacket.getData());
        this.pkt.setLength(datagramPacket.getLength());
        this.pkt.setOffset(datagramPacket.getOffset());
        return this.pkt;
    }

    public boolean endOfStream() {
        return false;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return this.pkt.getLength();
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return EMPTY_CONTROLS;
    }

    public int getMinimumTransferSize() {
        return 2048;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.ioError) {
            return -1;
        }
        int pktLength = this.pkt.getLength();
        if (length < pktLength) {
            throw new IOException("Input buffer not big enough for " + pktLength);
        }
        System.arraycopy(this.pkt.getBuffer(), this.pkt.getOffset(), buffer, offset, pktLength);
        return pktLength;
    }

    protected abstract void doLogPacket(DatagramPacket var1);

    protected abstract void receivePacket(DatagramPacket var1) throws IOException;

    public void run() {
        DatagramPacket p = new DatagramPacket(this.buffer, 0, 4096);
        while (!this.closed) {
            boolean accept;
            try {
                if (OSUtils.IS_ANDROID) {
                    p.setLength(4096);
                }
                this.receivePacket(p);
            }
            catch (IOException e) {
                this.ioError = true;
                break;
            }
            DatagramPacketFilter[] datagramPacketFilters = this.getDatagramPacketFilters();
            if (datagramPacketFilters == null) {
                accept = true;
            } else {
                accept = true;
                for (int i = 0; i < datagramPacketFilters.length; ++i) {
                    try {
                        if (datagramPacketFilters[i].accept(p)) continue;
                        accept = false;
                        break;
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) continue;
                        throw (ThreadDeath)t;
                    }
                }
            }
            if (!accept) continue;
            this.pkt = this.createRawPacket(p);
            if (this.pkt == null || this.transferHandler == null || this.closed) continue;
            this.transferHandler.transferData((PushSourceStream)this);
        }
    }

    public void setTransferHandler(SourceTransferHandler transferHandler) {
        if (!this.closed) {
            this.transferHandler = transferHandler;
        }
    }

    public void setPriority(int priority) {
    }

    public synchronized DatagramPacketFilter[] getDatagramPacketFilters() {
        return this.datagramPacketFilters;
    }

    public synchronized void addDatagramPacketFilter(DatagramPacketFilter datagramPacketFilter) {
        if (datagramPacketFilter == null) {
            throw new NullPointerException("datagramPacketFilter");
        }
        if (this.datagramPacketFilters == null) {
            this.datagramPacketFilters = new DatagramPacketFilter[]{datagramPacketFilter};
        } else {
            int length = this.datagramPacketFilters.length;
            for (int i = 0; i < length; ++i) {
                if (!datagramPacketFilter.equals(this.datagramPacketFilters[i])) continue;
                return;
            }
            DatagramPacketFilter[] newDatagramPacketFilters = new DatagramPacketFilter[length + 1];
            System.arraycopy(this.datagramPacketFilters, 0, newDatagramPacketFilters, 0, length);
            newDatagramPacketFilters[length] = datagramPacketFilter;
            this.datagramPacketFilters = newDatagramPacketFilters;
        }
    }
}

