/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class RTPConnectorUDPInputStream
extends RTPConnectorInputStream {
    private final DatagramSocket socket;
    private boolean receivedSizeFlag = false;

    public RTPConnectorUDPInputStream(DatagramSocket socket) {
        this.socket = socket;
        if (socket != null) {
            this.closed = false;
            this.receiverThread = new Thread(this);
            this.receiverThread.start();
        }
    }

    public synchronized void close() {
        this.closed = true;
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void doLogPacket(DatagramPacket p) {
        if (this.socket.getLocalAddress() == null) {
            return;
        }
        if (this.socket instanceof MultiplexingDatagramSocket) {
            return;
        }
        PacketLoggingService packetLogging = LibJitsi.getPacketLoggingService();
        if (packetLogging != null) {
            packetLogging.logPacket(PacketLoggingService.ProtocolName.RTP, p.getAddress().getAddress(), p.getPort(), this.socket.getLocalAddress().getAddress(), this.socket.getLocalPort(), PacketLoggingService.TransportName.UDP, false, p.getData(), p.getOffset(), p.getLength());
        }
    }

    protected void receivePacket(DatagramPacket p) throws IOException {
        if (!this.receivedSizeFlag) {
            this.receivedSizeFlag = true;
            try {
                this.socket.setReceiveBufferSize(65535);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.socket.receive(p);
    }
}

