/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import org.ice4j.socket.MultiplexingDatagramSocket;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;

public class RTPConnectorUDPOutputStream
extends RTPConnectorOutputStream {
    private final DatagramSocket socket;

    public RTPConnectorUDPOutputStream(DatagramSocket socket) {
        this.socket = socket;
    }

    protected void sendToTarget(RawPacket packet, InetSocketAddress target) throws IOException {
        this.socket.send(new DatagramPacket(packet.getBuffer(), packet.getOffset(), packet.getLength(), target.getAddress(), target.getPort()));
    }

    protected void doLogPacket(RawPacket packet, InetSocketAddress target) {
        if (this.socket instanceof MultiplexingDatagramSocket) {
            return;
        }
        PacketLoggingService packetLogging = LibJitsi.getPacketLoggingService();
        if (packetLogging != null) {
            packetLogging.logPacket(PacketLoggingService.ProtocolName.RTP, this.socket.getLocalAddress().getAddress(), this.socket.getLocalPort(), target.getAddress().getAddress(), target.getPort(), PacketLoggingService.TransportName.UDP, true, packet.getBuffer(), packet.getOffset(), packet.getLength());
        }
    }

    protected boolean isSocketValid() {
        return this.socket != null;
    }
}

