/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

public class RawPacket {
    public static final int FIXED_HEADER_SIZE = 12;
    public static final int EXT_HEADER_SIZE = 4;
    private byte[] buffer;
    private int offset;
    private int length;

    public RawPacket() {
    }

    public RawPacket(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    protected void setLength(int length) {
        this.length = length;
    }

    public void setMarker(boolean marker) {
        if (marker) {
            int n = this.offset + 1;
            this.buffer[n] = (byte)(this.buffer[n] | 0xFFFFFF80);
        } else {
            int n = this.offset + 1;
            this.buffer[n] = (byte)(this.buffer[n] & 0x7F);
        }
    }

    public void setPayload(byte payload) {
        payload = (byte)(payload & 0x7F);
        this.buffer[this.offset + 1] = (byte)(this.buffer[this.offset + 1] & 0x80 | payload);
    }

    public long getTimestamp() {
        return this.readInt(this.offset + 4);
    }

    public void setTimestamp(long timestamp) {
        this.writeInt(this.offset + 4, (int)timestamp);
    }

    public int readInt(int off) {
        return this.buffer[this.offset + off + 0] << 24 | (this.buffer[this.offset + off + 1] & 0xFF) << 16 | (this.buffer[this.offset + off + 2] & 0xFF) << 8 | this.buffer[this.offset + off + 3] & 0xFF;
    }

    public void writeInt(int off, int data) {
        this.buffer[this.offset + off++] = (byte)(data >> 24);
        this.buffer[this.offset + off++] = (byte)(data >> 16);
        this.buffer[this.offset + off++] = (byte)(data >> 8);
        this.buffer[this.offset + off] = (byte)data;
    }

    public short readShort(int off) {
        return (short)(this.buffer[this.offset + off + 0] << 8 | this.buffer[this.offset + off + 1] & 0xFF);
    }

    public int readUnsignedShortAsInt(int off) {
        int b1 = 0xFF & this.buffer[this.offset + off + 0];
        int b2 = 0xFF & this.buffer[this.offset + off + 1];
        int val = b1 << 8 | b2;
        return val;
    }

    public byte readByte(int off) {
        return this.buffer[this.offset + off];
    }

    public void writeByte(int off, byte b) {
        this.buffer[this.offset + off] = b;
    }

    public long readUnsignedIntAsLong(int off) {
        int b0 = 0xFF & this.buffer[this.offset + off + 0];
        int b1 = 0xFF & this.buffer[this.offset + off + 1];
        int b2 = 0xFF & this.buffer[this.offset + off + 2];
        int b3 = 0xFF & this.buffer[this.offset + off + 3];
        return (long)(b0 << 24 | b1 << 16 | b2 << 8 | b3) & 0xFFFFFFFFL;
    }

    public byte[] readRegion(int off, int len) {
        int startOffset = this.offset + off;
        if (off < 0 || len <= 0 || startOffset + len > this.buffer.length) {
            return null;
        }
        byte[] region = new byte[len];
        System.arraycopy(this.buffer, startOffset, region, 0, len);
        return region;
    }

    public void readRegionToBuff(int off, int len, byte[] outBuff) {
        int startOffset = this.offset + off;
        if (off < 0 || len <= 0 || startOffset + len > this.buffer.length) {
            return;
        }
        if (outBuff.length < len) {
            return;
        }
        System.arraycopy(this.buffer, startOffset, outBuff, 0, len);
    }

    public void grow(int howMuch) {
        if (howMuch == 0) {
            return;
        }
        byte[] newBuffer = new byte[this.length + howMuch];
        System.arraycopy(this.buffer, this.offset, newBuffer, 0, this.length);
        this.offset = 0;
        this.buffer = newBuffer;
    }

    public void append(byte[] data, int len) {
        if (data == null || len == 0) {
            return;
        }
        if (this.length + len > this.buffer.length - this.offset) {
            byte[] newBuffer = new byte[this.length + len];
            System.arraycopy(this.buffer, this.offset, newBuffer, 0, this.length);
            this.offset = 0;
            this.buffer = newBuffer;
        }
        System.arraycopy(data, 0, this.buffer, this.length, len);
        this.length += len;
    }

    public void shrink(int len) {
        if (len <= 0) {
            return;
        }
        this.length -= len;
        if (this.length < 0) {
            this.length = 0;
        }
    }

    public int getCsrcCount() {
        return this.buffer[this.offset] & 0xF;
    }

    public void setCsrcList(long[] newCsrcList) {
        int newCsrcCount = newCsrcList.length;
        byte[] csrcBuff = new byte[newCsrcCount * 4];
        int csrcOffset = 0;
        for (long csrc : newCsrcList) {
            csrcBuff[csrcOffset] = (byte)(csrc >> 24);
            csrcBuff[csrcOffset + 1] = (byte)(csrc >> 16);
            csrcBuff[csrcOffset + 2] = (byte)(csrc >> 8);
            csrcBuff[csrcOffset + 3] = (byte)csrc;
            csrcOffset += 4;
        }
        int oldCsrcCount = this.getCsrcCount();
        byte[] oldBuffer = this.getBuffer();
        byte[] newBuffer = new byte[this.length + this.offset + csrcBuff.length - oldCsrcCount * 4];
        System.arraycopy(oldBuffer, 0, newBuffer, 0, this.offset + 12);
        System.arraycopy(csrcBuff, 0, newBuffer, this.offset + 12, csrcBuff.length);
        int payloadOffsetForOldBuff = this.offset + 12 + oldCsrcCount * 4;
        int payloadOffsetForNewBuff = this.offset + 12 + newCsrcCount * 4;
        System.arraycopy(oldBuffer, payloadOffsetForOldBuff, newBuffer, payloadOffsetForNewBuff, this.length - payloadOffsetForOldBuff);
        newBuffer[this.offset] = (byte)(newBuffer[this.offset] & 0xF0 | newCsrcCount);
        this.buffer = newBuffer;
        this.length = payloadOffsetForNewBuff + this.length - payloadOffsetForOldBuff - this.offset;
    }

    public long[] extractCsrcList() {
        int csrcCount = this.getCsrcCount();
        long[] csrcList = new long[csrcCount];
        int csrcStartIndex = this.offset + 12;
        for (int i = 0; i < csrcCount; ++i) {
            csrcList[i] = this.readInt(csrcStartIndex);
            csrcStartIndex += 4;
        }
        return csrcList;
    }

    public int getPaddingSize() {
        if ((this.buffer[this.offset] & 4) == 0) {
            return 0;
        }
        return this.buffer[this.offset + this.length - 1];
    }

    public int getHeaderLength() {
        if (this.getExtensionBit()) {
            return 12 + 4 * this.getCsrcCount() + 4 + this.getExtensionLength();
        }
        return 12 + 4 * this.getCsrcCount();
    }

    public int getPayloadLength() {
        return this.length - this.getHeaderLength();
    }

    public int getSSRC() {
        return (int)(this.readUnsignedIntAsLong(8) & 0xFFFFFFFFFFFFFFFFL);
    }

    public long getRTCPSSRC() {
        return (int)(this.readUnsignedIntAsLong(4) & 0xFFFFFFFFFFFFFFFFL);
    }

    public int getSequenceNumber() {
        return this.readUnsignedShortAsInt(2);
    }

    public int getSRTCPIndex(int authTagLen) {
        int offset = this.getLength() - (4 + authTagLen);
        return this.readInt(offset);
    }

    public boolean isPacketMarked() {
        return (this.buffer[this.offset + 1] & 0x80) != 0;
    }

    public byte getPayloadType() {
        return (byte)(this.buffer[this.offset + 1] & 0x7F);
    }

    public byte[] getPayload() {
        return this.readRegion(this.getHeaderLength(), this.getPayloadLength());
    }

    public byte[] readTimeStampIntoByteArray() {
        return this.readRegion(4, 4);
    }

    public boolean getExtensionBit() {
        return (this.buffer[this.offset] & 0x10) == 16;
    }

    private void setExtensionBit(boolean extBit) {
        if (extBit) {
            int n = this.offset;
            this.buffer[n] = (byte)(this.buffer[n] | 0x10);
        } else {
            int n = this.offset;
            this.buffer[n] = (byte)(this.buffer[n] & 0xEF);
        }
    }

    public int getExtensionLength() {
        if (!this.getExtensionBit()) {
            return 0;
        }
        int extLenIndex = this.offset + 12 + this.getCsrcCount() * 4 + 2;
        return (this.buffer[extLenIndex] << 8 | this.buffer[extLenIndex + 1]) * 4;
    }

    public void addExtension(byte[] extBuff, int newExtensionLen) {
        int newBuffLen = this.length + this.offset + newExtensionLen;
        int bufferOffset = this.offset;
        int newBufferOffset = this.offset;
        int lengthToCopy = 12 + this.getCsrcCount() * 4;
        boolean extensionBit = this.getExtensionBit();
        if (extensionBit) {
            lengthToCopy += 2;
        } else {
            newBuffLen += 4;
        }
        byte[] newBuffer = new byte[newBuffLen];
        System.arraycopy(this.buffer, bufferOffset, newBuffer, newBufferOffset, lengthToCopy);
        int n = newBufferOffset;
        newBuffer[n] = (byte)(newBuffer[n] | 0x10);
        bufferOffset += lengthToCopy;
        newBufferOffset += lengthToCopy;
        int totalExtensionLen = newExtensionLen + this.getExtensionLength();
        if (extensionBit) {
            bufferOffset += 4;
        } else {
            newBuffer[newBufferOffset++] = -66;
            newBuffer[newBufferOffset++] = -34;
        }
        int lengthInWords = (totalExtensionLen + 3) / 4;
        newBuffer[newBufferOffset++] = (byte)(lengthInWords >> 8);
        newBuffer[newBufferOffset++] = (byte)lengthInWords;
        if (extensionBit) {
            lengthToCopy = this.getExtensionLength();
            System.arraycopy(this.buffer, bufferOffset, newBuffer, newBufferOffset, lengthToCopy);
            bufferOffset += lengthToCopy;
            newBufferOffset += lengthToCopy;
        }
        System.arraycopy(extBuff, 0, newBuffer, newBufferOffset, newExtensionLen);
        System.arraycopy(this.buffer, bufferOffset, newBuffer, newBufferOffset += newExtensionLen, this.getPayloadLength());
        this.buffer = newBuffer;
        this.length = (newBufferOffset += this.getPayloadLength()) - this.offset;
    }

    public void removeExtension() {
        if (!this.getExtensionBit()) {
            return;
        }
        int payloadOffset = this.offset + this.getHeaderLength();
        int extHeaderLen = this.getExtensionLength() + 4;
        System.arraycopy(this.buffer, payloadOffset, this.buffer, payloadOffset - extHeaderLen, this.getPayloadLength());
        this.length -= extHeaderLen;
        this.setExtensionBit(false);
    }

    public long[] extractCsrcLevels(byte csrcExtID) {
        if (!this.getExtensionBit() || this.getExtensionLength() == 0 || this.getCsrcCount() == 0) {
            return null;
        }
        int csrcCount = this.getCsrcCount();
        long[] csrcLevels = new long[csrcCount * 2];
        int csrcStartIndex = this.offset + 12;
        for (int i = 0; i < csrcCount; ++i) {
            int csrcLevelsIndex = 2 * i;
            csrcLevels[csrcLevelsIndex] = this.readInt(csrcStartIndex);
            csrcLevels[csrcLevelsIndex + 1] = this.getCsrcLevel(i, csrcExtID);
            csrcStartIndex += 4;
        }
        return csrcLevels;
    }

    private int getCsrcLevel(int index, byte csrcExtID) {
        if (!this.getExtensionBit() || this.getExtensionLength() == 0) {
            return 0;
        }
        int levelsStart = this.findExtension(csrcExtID);
        if (levelsStart == -1) {
            return 0;
        }
        int levelsCount = this.getLengthForExtension(levelsStart);
        if (levelsCount < index) {
            return 0;
        }
        return this.buffer[levelsStart + index];
    }

    private int findExtension(int extensionID) {
        int currLen;
        int extOffset;
        if (!this.getExtensionBit() || this.getExtensionLength() == 0) {
            return 0;
        }
        int extensionEnd = extOffset + this.getExtensionLength();
        int extHdrLen = this.getExtensionHeaderLength();
        if (extHdrLen != 1 && extHdrLen != 2) {
            return -1;
        }
        for (extOffset = this.offset + 12 + this.getCsrcCount() * 4 + 4; extOffset < extensionEnd; extOffset += currLen) {
            int currType = -1;
            currLen = -1;
            if (extHdrLen == 1) {
                currType = this.buffer[extOffset] >> 4;
                currLen = (this.buffer[extOffset] & 0xF) + 1;
                ++extOffset;
            } else {
                currType = this.buffer[extOffset];
                currLen = this.buffer[extOffset + 1];
                extOffset += 2;
            }
            if (currType != extensionID) continue;
            return extOffset;
        }
        return -1;
    }

    private int getLengthForExtension(int contentStart) {
        int hdrLen = this.getExtensionHeaderLength();
        if (hdrLen == 1) {
            return (this.buffer[contentStart - 1] & 0xF) + 1;
        }
        return this.buffer[contentStart - 1];
    }

    private int getExtensionHeaderLength() {
        if (!this.getExtensionBit()) {
            return -1;
        }
        int extLenIndex = this.offset + 12 + this.getCsrcCount() * 4;
        if (this.buffer[extLenIndex] == -66 && this.buffer[extLenIndex + 1] == -34) {
            return 1;
        }
        if (this.buffer[extLenIndex] == 16 && this.buffer[extLenIndex + 1] >> 4 == 0) {
            return 2;
        }
        return -1;
    }

    public int getHeaderExtensionType() {
        if (!this.getExtensionBit()) {
            return 0;
        }
        return this.readUnsignedShortAsInt(this.offset + 12 + this.getCsrcCount() * 4);
    }
}

