/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCodecExt
extends AbstractCodec {
    private final Class<? extends Format> formatClass;
    private final String name;
    private final Format[] supportedOutputFormats;

    protected AbstractCodecExt(String name, Class<? extends Format> formatClass, Format[] supportedOutputFormats) {
        this.formatClass = formatClass;
        this.name = name;
        this.supportedOutputFormats = supportedOutputFormats;
        if (this instanceof Effect) {
            this.inputFormats = this.supportedOutputFormats;
        }
    }

    public void close() {
        if (!this.opened) {
            return;
        }
        this.doClose();
        this.opened = false;
        super.close();
    }

    protected void discardOutputBuffer(Buffer outputBuffer) {
        outputBuffer.setDiscard(true);
    }

    protected abstract void doClose();

    protected abstract void doOpen() throws ResourceUnavailableException;

    protected abstract int doProcess(Buffer var1, Buffer var2);

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        if (this instanceof Effect) {
            return new Format[]{inputFormat};
        }
        if (this.supportedOutputFormats != null) {
            return (Format[])this.supportedOutputFormats.clone();
        }
        return new Format[0];
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public Format[] getSupportedOutputFormats(Format inputFormat) {
        if (inputFormat == null) {
            return this.supportedOutputFormats;
        }
        if (!this.formatClass.isInstance(inputFormat) || AbstractCodecExt.matches(inputFormat, this.inputFormats) == null) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(inputFormat);
    }

    public static Format matches(Format in, Format[] outs) {
        for (Format out : outs) {
            if (!in.matches(out)) continue;
            return out;
        }
        return null;
    }

    public void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        this.doOpen();
        this.opened = true;
        super.open();
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        if (inputBuffer.isDiscard()) {
            this.discardOutputBuffer(outputBuffer);
            return 0;
        }
        return this.doProcess(inputBuffer, outputBuffer);
    }

    public Format setInputFormat(Format format) {
        if (!this.formatClass.isInstance(format) || AbstractCodecExt.matches(format, this.inputFormats) == null) {
            return null;
        }
        return super.setInputFormat(format);
    }

    public Format setOutputFormat(Format format) {
        if (!this.formatClass.isInstance(format) || AbstractCodecExt.matches(format, this.getMatchingOutputFormats(this.inputFormat)) == null) {
            return null;
        }
        return super.setOutputFormat(format);
    }

    public static YUVFormat specialize(YUVFormat yuvFormat, Class<?> dataType) {
        int offsetV;
        int offsetU;
        int offsetY;
        int strideUV;
        Dimension size = yuvFormat.getSize();
        int strideY = yuvFormat.getStrideY();
        if (strideY == -1 && size != null) {
            strideY = size.width;
        }
        if ((strideUV = yuvFormat.getStrideUV()) == -1 && strideY != -1) {
            strideUV = (strideY + 1) / 2;
        }
        if ((offsetY = yuvFormat.getOffsetY()) == -1) {
            offsetY = 0;
        }
        if ((offsetU = yuvFormat.getOffsetU()) == -1 && strideY != -1 && size != null) {
            offsetU = offsetY + strideY * size.height;
        }
        if ((offsetV = yuvFormat.getOffsetV()) == -1 && offsetU != -1 && strideUV != -1 && size != null) {
            offsetV = offsetU + strideUV * ((size.height + 1) / 2);
        }
        int maxDataLength = strideY != -1 && strideUV != -1 && size != null ? strideY * size.height + 2 * strideUV * ((size.height + 1) / 2) + 8 : -1;
        return new YUVFormat(size, maxDataLength, dataType == null ? yuvFormat.getDataType() : dataType, yuvFormat.getFrameRate(), 2, strideY, strideUV, offsetY, offsetU, offsetV);
    }

    protected void updateOutput(Buffer outputBuffer, Format format, int length, int offset) {
        outputBuffer.setFormat(format);
        outputBuffer.setLength(length);
        outputBuffer.setOffset(offset);
    }

    protected byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] newBytes;
        Object data = buffer.getData();
        if (data instanceof byte[]) {
            byte[] bytes = (byte[])data;
            if (bytes.length >= newSize) {
                return bytes;
            }
            newBytes = new byte[newSize];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        } else {
            newBytes = new byte[newSize];
            buffer.setLength(0);
            buffer.setOffset(0);
        }
        buffer.setData((Object)newBytes);
        return newBytes;
    }

    protected short[] validateShortArraySize(Buffer buffer, int newSize) {
        short[] newShorts;
        Object data = buffer.getData();
        if (data instanceof short[]) {
            short[] shorts = (short[])data;
            if (shorts.length >= newSize) {
                return shorts;
            }
            newShorts = new short[newSize];
            System.arraycopy(shorts, 0, newShorts, 0, shorts.length);
        } else {
            newShorts = new short[newSize];
            buffer.setLength(0);
            buffer.setOffset(0);
        }
        buffer.setData((Object)newShorts);
        return newShorts;
    }
}

