/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.opus;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.audio.opus.Opus;
import org.jitsi.service.neomedia.control.FECDecoderControl;

public class JNIDecoder
extends AbstractCodecExt
implements FECDecoderControl {
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("opus/rtp")};
    private static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", 48000.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    private long decoder = 0L;
    private int channels = 1;
    private int outputSamplingRate = 48000;
    private long lastPacketSeq;
    private boolean firstPacketProcessed = false;
    private int nbDecodedFec = 0;

    public JNIDecoder() {
        super("Opus JNI Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.addControl(this);
    }

    protected void doClose() {
        if (this.decoder != 0L) {
            Opus.decoder_destroy(this.decoder);
        }
    }

    protected void doOpen() throws ResourceUnavailableException {
        this.decoder = Opus.decoder_create(this.outputSamplingRate, this.channels);
        if (this.decoder == 0L) {
            throw new ResourceUnavailableException("opus_decoder_create");
        }
    }

    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int outputLength;
        byte[] outputData;
        int inputLength;
        int inputOffset;
        byte[] inputData;
        int samplesCount;
        Format inputFormat = inputBuffer.getFormat();
        if (inputFormat != null && inputFormat != this.inputFormat && !inputFormat.equals((Object)this.inputFormat) && null == this.setInputFormat(inputFormat)) {
            return 1;
        }
        boolean decodeFec = false;
        long inputSequenceNumber = inputBuffer.getSequenceNumber();
        if (this.firstPacketProcessed && inputSequenceNumber != this.lastPacketSeq + 1L && (inputSequenceNumber != 0L || this.lastPacketSeq != 65535L)) {
            decodeFec = true;
        }
        if ((samplesCount = Opus.decode(this.decoder, inputData = (byte[])inputBuffer.getData(), inputOffset = inputBuffer.getOffset(), inputLength = inputBuffer.getLength(), outputData = this.validateByteArraySize(outputBuffer, outputLength = Opus.decoder_get_nb_samples(this.decoder, inputData, inputOffset, inputLength) * 2), outputLength, decodeFec ? 1 : 0)) > 0) {
            outputBuffer.setDuration((long)(samplesCount * 1000 * 1000 / this.outputSamplingRate));
            outputBuffer.setFormat(this.getOutputFormat());
            outputBuffer.setLength(2 * samplesCount);
            outputBuffer.setOffset(0);
            if (decodeFec) {
                ++this.nbDecodedFec;
            }
        } else {
            outputBuffer.setLength(0);
            this.discardOutputBuffer(outputBuffer);
        }
        this.firstPacketProcessed = true;
        if (decodeFec) {
            this.lastPacketSeq = inputSequenceNumber - 1L;
            return 2;
        }
        this.lastPacketSeq = inputSequenceNumber;
        return 0;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        return new Format[]{new AudioFormat("LINEAR", inputAudioFormat.getSampleRate(), 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
    }

    public Format setInputFormat(Format format) {
        Format inputFormat = super.setInputFormat(format);
        if (inputFormat != null) {
            int outputChannels;
            double outputSampleRate;
            if (this.outputFormat == null) {
                outputSampleRate = -1.0;
                outputChannels = -1;
            } else {
                AudioFormat outputAudioFormat = (AudioFormat)this.outputFormat;
                outputSampleRate = outputAudioFormat.getSampleRate();
                outputChannels = outputAudioFormat.getChannels();
            }
            AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
            double inputSampleRate = inputAudioFormat.getSampleRate();
            int inputChannels = inputAudioFormat.getChannels();
            if (outputSampleRate != inputSampleRate || outputChannels != inputChannels) {
                this.setOutputFormat((Format)new AudioFormat("LINEAR", inputSampleRate, 16, inputChannels, 0, 1, -1, -1.0, Format.byteArray));
            }
        }
        return inputFormat;
    }

    public int fecPacketsDecoded() {
        return this.nbDecodedFec;
    }

    public Component getControlComponent() {
        return null;
    }

    static {
        Opus.assertOpusIsFunctional();
    }
}

