/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.opus;

import java.awt.Component;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;
import org.jitsi.impl.neomedia.codec.audio.opus.Opus;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.control.FormatParametersAwareCodec;
import org.jitsi.service.neomedia.control.PacketLossAwareEncoder;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNIEncoder
extends AbstractCodecExt
implements PacketLossAwareEncoder,
FormatParametersAwareCodec {
    private static final Format[] SUPPORTED_INPUT_FORMATS;
    static final double[] SUPPORTED_INPUT_SAMPLE_RATES;
    private static final Format[] SUPPORTED_OUTPUT_FORMATS;
    private int bandwidthConfig;
    private int bitrateConfig;
    private int channels = 1;
    private int complexityConfig;
    private long encoder = 0L;
    private double frameSize = 20.0;
    private final Logger logger = Logger.getLogger(JNIEncoder.class);
    private int minPacketLoss = 0;
    private byte[] previousInput = null;
    private int previousInputLength = 0;
    private boolean useDtxConfig;
    private boolean useFecConfig;

    public JNIEncoder() {
        super("Opus JNI Encoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.addControl(this);
    }

    @Override
    protected void doClose() {
        if (this.encoder != 0L) {
            Opus.encoder_destroy(this.encoder);
        }
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        AudioFormat inputFormat = (AudioFormat)this.getInputFormat();
        int sampleRate = (int)inputFormat.getSampleRate();
        this.channels = inputFormat.getChannels();
        this.encoder = Opus.encoder_create(sampleRate, this.channels);
        if (this.encoder == 0L) {
            throw new ResourceUnavailableException("opus_encoder_create()");
        }
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        String str = cfg.getString("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.AUDIO_BANDWIDTH", "auto");
        this.bandwidthConfig = -1000;
        if ("fb".equals(str)) {
            this.bandwidthConfig = 1105;
        } else if ("swb".equals(str)) {
            this.bandwidthConfig = 1104;
        } else if ("wb".equals(str)) {
            this.bandwidthConfig = 1103;
        } else if ("mb".equals(str)) {
            this.bandwidthConfig = 1102;
        } else if ("nb".equals(str)) {
            this.bandwidthConfig = 1101;
        }
        Opus.encoder_set_bandwidth(this.encoder, this.bandwidthConfig);
        this.bitrateConfig = 1000 * cfg.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.BITRATE", 32);
        if (this.bitrateConfig < 500) {
            this.bitrateConfig = 500;
        }
        if (this.bitrateConfig > 512000) {
            this.bitrateConfig = 512000;
        }
        Opus.encoder_set_bitrate(this.encoder, this.bitrateConfig);
        this.complexityConfig = cfg.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.COMPLEXITY", 10);
        Opus.encoder_set_complexity(this.encoder, this.complexityConfig);
        this.useFecConfig = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.FEC", true);
        Opus.encoder_set_inband_fec(this.encoder, this.useFecConfig ? 1 : 0);
        this.minPacketLoss = cfg.getInt("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.MIN_EXPECTED_PACKET_LOSS", 1);
        Opus.encoder_set_packet_loss_perc(this.encoder, this.minPacketLoss);
        this.useDtxConfig = cfg.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.opus.encoder.DTX", true);
        Opus.encoder_set_dtx(this.encoder, this.useDtxConfig ? 1 : 0);
        if (this.logger.isDebugEnabled()) {
            int b = Opus.encoder_get_bandwidth(this.encoder);
            this.logger.debug("Encoder settings: audio bandwidth " + (b == 1105 ? "fb" : (b == 1104 ? "swb" : (b == 1103 ? "wb" : (b == 1102 ? "mb" : "nb")))) + ", bitrate " + Opus.encoder_get_bitrate(this.encoder) + ", DTX " + Opus.encoder_get_dtx(this.encoder) + ", FEC " + this.useFecConfig);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int inputBytesNeeded;
        int inputOffset;
        int inputLength;
        byte[] input;
        block14: {
            Format inputFormat = inputBuffer.getFormat();
            if (inputFormat != null && inputFormat != this.inputFormat && !inputFormat.equals((Object)this.inputFormat) && null == this.setInputFormat(inputFormat)) {
                return 1;
            }
            input = (byte[])inputBuffer.getData();
            inputLength = inputBuffer.getLength();
            inputOffset = inputBuffer.getOffset();
            inputBytesNeeded = this.inputFrameSize();
            if (this.previousInput != null && this.previousInputLength > 0) {
                if (this.previousInputLength < inputBytesNeeded) {
                    int bytesToCopyFromInputToPreviousInput;
                    if (this.previousInput.length < inputBytesNeeded) {
                        byte[] newPreviousInput = new byte[inputBytesNeeded];
                        System.arraycopy(this.previousInput, 0, newPreviousInput, 0, this.previousInput.length);
                        this.previousInput = newPreviousInput;
                    }
                    if ((bytesToCopyFromInputToPreviousInput = Math.min(inputBytesNeeded - this.previousInputLength, inputLength)) > 0) {
                        System.arraycopy(input, inputOffset, this.previousInput, this.previousInputLength, bytesToCopyFromInputToPreviousInput);
                        this.previousInputLength += bytesToCopyFromInputToPreviousInput;
                        inputBuffer.setLength(inputLength -= bytesToCopyFromInputToPreviousInput);
                        inputBuffer.setOffset(inputOffset + bytesToCopyFromInputToPreviousInput);
                    }
                }
                if (this.previousInputLength == inputBytesNeeded) {
                    input = this.previousInput;
                    inputOffset = 0;
                    this.previousInputLength = 0;
                    break block14;
                } else {
                    outputBuffer.setLength(0);
                    this.discardOutputBuffer(outputBuffer);
                    if (inputLength < 1) {
                        return 0;
                    }
                    return 2;
                }
            }
            if (inputLength < 1) {
                outputBuffer.setLength(0);
                this.discardOutputBuffer(outputBuffer);
                return 0;
            }
            if (inputLength < inputBytesNeeded) {
                if (this.previousInput == null || this.previousInput.length < inputLength) {
                    this.previousInput = new byte[inputBytesNeeded];
                }
                System.arraycopy(input, inputOffset, this.previousInput, 0, inputLength);
                this.previousInputLength = inputLength;
                outputBuffer.setLength(0);
                this.discardOutputBuffer(outputBuffer);
                return 0;
            }
            inputBuffer.setLength(inputLength -= inputBytesNeeded);
            inputBuffer.setOffset(inputOffset + inputBytesNeeded);
        }
        byte[] output = this.validateByteArraySize(outputBuffer, 1276);
        int outputLength = Opus.encode(this.encoder, input, inputOffset, inputBytesNeeded / 2, output, 1276);
        if (outputLength < 0) {
            return 1;
        }
        if (outputLength > 0) {
            outputBuffer.setDuration((long)this.frameSize * 1000L * 1000L);
            outputBuffer.setFormat(this.getOutputFormat());
            outputBuffer.setLength(outputLength);
            outputBuffer.setOffset(0);
        }
        if (inputLength < 1) {
            return 0;
        }
        return 2;
    }

    public Component getControlComponent() {
        return null;
    }

    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            outputFormat = this.setOutputFormat((Format)new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                public long computeDuration(long length) {
                    return (long)JNIEncoder.this.frameSize * 1000L * 1000L;
                }
            });
        }
        return outputFormat;
    }

    private int inputFrameSize() {
        int fs = (int)((double)(2 * this.channels) * ((AudioFormat)this.getInputFormat()).getSampleRate() * this.frameSize) / 1000;
        return fs;
    }

    @Override
    public void setExpectedPacketLoss(int percentage) {
        if (this.opened) {
            Opus.encoder_set_packet_loss_perc(this.encoder, percentage > this.minPacketLoss ? percentage : this.minPacketLoss);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Updating expected packet loss: " + percentage + " (minimum " + this.minPacketLoss + ")");
        }
    }

    @Override
    public void setFormatParameters(Map<String, String> fmtps) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Setting format parameters: " + fmtps);
        }
        String str = fmtps.get("maxaveragebitrate");
        int maxBitrate = 40000;
        try {
            maxBitrate = Integer.parseInt(str);
        }
        catch (Exception e) {
            // empty catch block
        }
        Opus.encoder_set_bitrate(this.encoder, maxBitrate < this.bitrateConfig ? maxBitrate : this.bitrateConfig);
        boolean useDtx = "1".equals(fmtps.get("usedtx"));
        Opus.encoder_set_dtx(this.encoder, useDtx && this.useDtxConfig ? 1 : 0);
        str = fmtps.get("useinbandfec");
        boolean useFec = str == null || str.equals("1");
        Opus.encoder_set_inband_fec(this.encoder, useFec && this.useFecConfig ? 1 : 0);
    }

    static {
        int i;
        SUPPORTED_INPUT_SAMPLE_RATES = new double[]{48000.0};
        SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("opus/rtp", 48000.0, -1, 1, -1, -1, -1, -1.0, Format.byteArray)};
        Opus.assertOpusIsFunctional();
        int supportedInputCount = SUPPORTED_INPUT_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[supportedInputCount * 2];
        for (i = 0; i < supportedInputCount; ++i) {
            JNIEncoder.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("LINEAR", SUPPORTED_INPUT_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.byteArray);
        }
        for (i = 0; i < supportedInputCount; ++i) {
            JNIEncoder.SUPPORTED_INPUT_FORMATS[i + supportedInputCount] = new AudioFormat("LINEAR", SUPPORTED_INPUT_SAMPLE_RATES[i], 16, 2, 0, 1, -1, -1.0, Format.byteArray);
        }
    }
}

