/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.speex;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.neomedia.codec.audio.speex.Speex;
import org.jitsi.impl.neomedia.codec.AbstractCodecExt;

public class JNIEncoder
extends AbstractCodecExt {
    private static final Format[] SUPPORTED_INPUT_FORMATS;
    static final double[] SUPPORTED_INPUT_SAMPLE_RATES;
    private static final Format[] SUPPORTED_OUTPUT_FORMATS;
    private long bits = 0L;
    private long duration = 0L;
    private int frameSize = 0;
    private byte[] previousInput;
    private int previousInputLength = 0;
    private int sampleRate = 0;
    private long state = 0L;

    public JNIEncoder() {
        super("Speex JNI Encoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
    }

    protected void doClose() {
        if (this.state != 0L) {
            Speex.speex_encoder_destroy(this.state);
            this.state = 0L;
            this.sampleRate = 0;
            this.frameSize = 0;
            this.duration = 0L;
        }
        Speex.speex_bits_destroy(this.bits);
        this.bits = 0L;
        this.previousInput = null;
    }

    protected void doOpen() throws ResourceUnavailableException {
        this.bits = Speex.speex_bits_init();
        if (this.bits == 0L) {
            throw new ResourceUnavailableException("speex_bits_init");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int inputOffset;
        int inputLength;
        byte[] input;
        block24: {
            block26: {
                Format inputFormat = inputBuffer.getFormat();
                if (inputFormat != null && inputFormat != this.inputFormat && !inputFormat.equals((Object)this.inputFormat) && null == this.setInputFormat(inputFormat)) {
                    return 1;
                }
                inputFormat = this.inputFormat;
                AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
                int inputSampleRate = (int)inputAudioFormat.getSampleRate();
                if (this.state != 0L && this.sampleRate != inputSampleRate) {
                    Speex.speex_encoder_destroy(this.state);
                    this.state = 0L;
                    this.sampleRate = 0;
                    this.frameSize = 0;
                }
                if (this.state == 0L) {
                    long mode = Speex.speex_lib_get_mode(inputSampleRate == 16000 ? 1 : (inputSampleRate == 32000 ? 2 : 0));
                    if (mode == 0L) {
                        return 1;
                    }
                    this.state = Speex.speex_encoder_init(mode);
                    if (this.state == 0L) {
                        return 1;
                    }
                    if (Speex.speex_encoder_ctl(this.state, 4, 4) != 0) {
                        return 1;
                    }
                    if (Speex.speex_encoder_ctl(this.state, 24, inputSampleRate) != 0) {
                        return 1;
                    }
                    int frameSize = Speex.speex_encoder_ctl(this.state, 3);
                    if (frameSize < 0) {
                        return 1;
                    }
                    this.sampleRate = inputSampleRate;
                    this.frameSize = frameSize * 2;
                    this.duration = (long)frameSize * 1000L * 1000000L / (long)this.sampleRate;
                }
                input = (byte[])inputBuffer.getData();
                inputLength = inputBuffer.getLength();
                inputOffset = inputBuffer.getOffset();
                if (this.previousInput == null || this.previousInputLength <= 0) break block26;
                if (this.previousInputLength < this.frameSize) {
                    int bytesToCopyFromInputToPreviousInput;
                    if (this.previousInput.length < this.frameSize) {
                        byte[] newPreviousInput = new byte[this.frameSize];
                        System.arraycopy(this.previousInput, 0, newPreviousInput, 0, this.previousInput.length);
                        this.previousInput = newPreviousInput;
                    }
                    if ((bytesToCopyFromInputToPreviousInput = Math.min(this.frameSize - this.previousInputLength, inputLength)) > 0) {
                        System.arraycopy(input, inputOffset, this.previousInput, this.previousInputLength, bytesToCopyFromInputToPreviousInput);
                        this.previousInputLength += bytesToCopyFromInputToPreviousInput;
                        inputBuffer.setLength(inputLength -= bytesToCopyFromInputToPreviousInput);
                        inputBuffer.setOffset(inputOffset + bytesToCopyFromInputToPreviousInput);
                    }
                }
                if (this.previousInputLength == this.frameSize) {
                    input = this.previousInput;
                    inputOffset = 0;
                    this.previousInputLength = 0;
                    break block24;
                } else if (this.previousInputLength > this.frameSize) {
                    input = new byte[this.frameSize];
                    System.arraycopy(this.previousInput, 0, input, 0, input.length);
                    inputOffset = 0;
                    this.previousInputLength -= input.length;
                    System.arraycopy(this.previousInput, input.length, this.previousInput, 0, this.previousInputLength);
                    break block24;
                } else {
                    outputBuffer.setLength(0);
                    this.discardOutputBuffer(outputBuffer);
                    if (inputLength < 1) {
                        return 0;
                    }
                    return 2;
                }
            }
            if (inputLength < 1) {
                outputBuffer.setLength(0);
                this.discardOutputBuffer(outputBuffer);
                return 0;
            }
            if (inputLength < this.frameSize) {
                if (this.previousInput == null || this.previousInput.length < inputLength) {
                    this.previousInput = new byte[this.frameSize];
                }
                System.arraycopy(input, inputOffset, this.previousInput, 0, inputLength);
                this.previousInputLength = inputLength;
                outputBuffer.setLength(0);
                this.discardOutputBuffer(outputBuffer);
                return 0;
            }
            inputBuffer.setLength(inputLength -= this.frameSize);
            inputBuffer.setOffset(inputOffset + this.frameSize);
        }
        Speex.speex_bits_reset(this.bits);
        Speex.speex_encode_int(this.state, input, inputOffset, this.bits);
        int outputLength = Speex.speex_bits_nbytes(this.bits);
        if (outputLength > 0) {
            byte[] output = this.validateByteArraySize(outputBuffer, outputLength);
            if ((outputLength = Speex.speex_bits_write(this.bits, output, 0, output.length)) > 0) {
                outputBuffer.setDuration(this.duration);
                outputBuffer.setFormat(this.getOutputFormat());
                outputBuffer.setLength(outputLength);
                outputBuffer.setOffset(0);
            } else {
                outputBuffer.setLength(0);
                this.discardOutputBuffer(outputBuffer);
            }
        } else {
            outputBuffer.setLength(0);
            this.discardOutputBuffer(outputBuffer);
        }
        if (inputLength < 1) {
            return 0;
        }
        return 2;
    }

    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
        return new Format[]{new AudioFormat("speex/rtp", inputAudioFormat.getSampleRate(), -1, 1, 0, 1, -1, -1.0, Format.byteArray)};
    }

    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            outputFormat = this.setOutputFormat((Format)new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                public long computeDuration(long length) {
                    return JNIEncoder.this.duration;
                }
            });
        }
        return outputFormat;
    }

    public Format setInputFormat(Format format) {
        Format inputFormat = super.setInputFormat(format);
        if (inputFormat != null) {
            int outputChannels;
            double outputSampleRate;
            if (this.outputFormat == null) {
                outputSampleRate = -1.0;
                outputChannels = -1;
            } else {
                AudioFormat outputAudioFormat = (AudioFormat)this.outputFormat;
                outputSampleRate = outputAudioFormat.getSampleRate();
                outputChannels = outputAudioFormat.getChannels();
            }
            AudioFormat inputAudioFormat = (AudioFormat)inputFormat;
            double inputSampleRate = inputAudioFormat.getSampleRate();
            int inputChannels = inputAudioFormat.getChannels();
            if (outputSampleRate != inputSampleRate || outputChannels != inputChannels) {
                this.setOutputFormat((Format)new AudioFormat("speex/rtp", inputSampleRate, -1, inputChannels, 0, 1, -1, -1.0, Format.byteArray));
            }
        }
        return inputFormat;
    }

    static {
        SUPPORTED_INPUT_SAMPLE_RATES = new double[]{8000.0, 16000.0, 32000.0};
        SUPPORTED_OUTPUT_FORMATS = new Format[]{new AudioFormat("speex/rtp")};
        Speex.assertSpeexIsFunctional();
        int supportedInputCount = SUPPORTED_INPUT_SAMPLE_RATES.length;
        SUPPORTED_INPUT_FORMATS = new Format[supportedInputCount];
        for (int i = 0; i < supportedInputCount; ++i) {
            JNIEncoder.SUPPORTED_INPUT_FORMATS[i] = new AudioFormat("LINEAR", SUPPORTED_INPUT_SAMPLE_RATES[i], 16, 1, 0, 1, -1, -1.0, Format.byteArray);
        }
    }
}

