/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.video.AVFrame;

public class AVFrameFormat
extends VideoFormat {
    public static final String AVFRAME = "AVFrame";
    private static final long serialVersionUID = 0L;
    private int deviceSystemPixFmt;
    private int pixFmt;

    public AVFrameFormat() {
        this(-1, -1);
    }

    public AVFrameFormat(Dimension size, float frameRate, int pixFmt) {
        this(size, frameRate, pixFmt, -1);
    }

    public AVFrameFormat(Dimension size, float frameRate, int pixFmt, int deviceSystemPixFmt) {
        super(AVFRAME, size, -1, AVFrame.class, frameRate);
        this.pixFmt = pixFmt;
        this.deviceSystemPixFmt = deviceSystemPixFmt;
    }

    public AVFrameFormat(int pixFmt) {
        this(pixFmt, -1);
    }

    public AVFrameFormat(int pixFmt, int deviceSystemPixFmt) {
        this(null, -1.0f, pixFmt, deviceSystemPixFmt);
    }

    public Object clone() {
        AVFrameFormat f = new AVFrameFormat(this.getSize(), this.getFrameRate(), this.pixFmt, this.deviceSystemPixFmt);
        f.copy((Format)this);
        return f;
    }

    protected void copy(Format f) {
        super.copy(f);
        if (f instanceof AVFrameFormat) {
            AVFrameFormat avFrameFormat = (AVFrameFormat)f;
            this.pixFmt = avFrameFormat.pixFmt;
            this.deviceSystemPixFmt = avFrameFormat.deviceSystemPixFmt;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AVFrameFormat && super.equals(obj)) {
            AVFrameFormat avFrameFormat = (AVFrameFormat)((Object)obj);
            return this.pixFmt == avFrameFormat.pixFmt;
        }
        return false;
    }

    public int getDeviceSystemPixFmt() {
        return this.deviceSystemPixFmt;
    }

    public int getPixFmt() {
        return this.pixFmt;
    }

    public int hashCode() {
        return super.hashCode() + this.pixFmt;
    }

    public Format intersects(Format format) {
        Format intersection = super.intersects(format);
        if (intersection != null) {
            AVFrameFormat avFrameFormatIntersection = (AVFrameFormat)intersection;
            avFrameFormatIntersection.pixFmt = this.pixFmt == -1 && format instanceof AVFrameFormat ? ((AVFrameFormat)format).pixFmt : this.pixFmt;
        }
        return intersection;
    }

    public boolean matches(Format format) {
        boolean matches;
        if (super.matches(format)) {
            if (format instanceof AVFrameFormat) {
                AVFrameFormat avFrameFormat = (AVFrameFormat)format;
                matches = this.pixFmt == -1 || avFrameFormat.pixFmt == -1 || this.pixFmt == avFrameFormat.pixFmt;
            } else {
                matches = true;
            }
        } else {
            matches = false;
        }
        return matches;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", pixFmt= " + this.pixFmt;
    }
}

