/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import javax.media.Format;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.util.Logger;

class InputDataSourceDesc {
    private static final Logger logger = Logger.getLogger(InputDataSourceDesc.class);
    private static final SourceStream[] EMPTY_STREAMS = new SourceStream[0];
    private boolean connected;
    private Thread connectThread;
    public final DataSource inputDataSource;
    public final AudioMixingPushBufferDataSource outputDataSource;
    private DataSource transcodingDataSource;

    public InputDataSourceDesc(DataSource inputDataSource, AudioMixingPushBufferDataSource outputDataSource) {
        this.inputDataSource = inputDataSource;
        this.outputDataSource = outputDataSource;
    }

    synchronized void connect(final AudioMixer audioMixer) throws IOException {
        DataSource effectiveInputDataSource;
        DataSource dataSource = effectiveInputDataSource = this.transcodingDataSource == null ? this.inputDataSource : this.transcodingDataSource;
        if (effectiveInputDataSource instanceof TranscodingDataSource) {
            if (this.connectThread == null) {
                this.connectThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        InputDataSourceDesc inputDataSourceDesc;
                        try {
                            try {
                                audioMixer.connect(effectiveInputDataSource, InputDataSourceDesc.this.inputDataSource);
                                InputDataSourceDesc inputDataSourceDesc2 = InputDataSourceDesc.this;
                                synchronized (inputDataSourceDesc2) {
                                    InputDataSourceDesc.this.connected = true;
                                }
                                audioMixer.connected(InputDataSourceDesc.this);
                            }
                            catch (IOException ioex) {
                                logger.error("Failed to connect to inputDataSource " + MediaStreamImpl.toString(InputDataSourceDesc.this.inputDataSource), ioex);
                                Object var4_4 = null;
                                InputDataSourceDesc inputDataSourceDesc2 = InputDataSourceDesc.this;
                                synchronized (inputDataSourceDesc2) {
                                    if (InputDataSourceDesc.this.connectThread != Thread.currentThread()) return;
                                    InputDataSourceDesc.this.connectThread = null;
                                    return;
                                }
                            }
                            Object var4_3 = null;
                            inputDataSourceDesc = InputDataSourceDesc.this;
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            InputDataSourceDesc inputDataSourceDesc4 = InputDataSourceDesc.this;
                            synchronized (inputDataSourceDesc4) {
                                if (InputDataSourceDesc.this.connectThread != Thread.currentThread()) throw throwable;
                                InputDataSourceDesc.this.connectThread = null;
                                throw throwable;
                            }
                        }
                        synchronized (inputDataSourceDesc) {
                            if (InputDataSourceDesc.this.connectThread != Thread.currentThread()) return;
                            InputDataSourceDesc.this.connectThread = null;
                            return;
                        }
                    }
                };
                this.connectThread.setDaemon(true);
                this.connectThread.start();
            }
        } else {
            audioMixer.connect(effectiveInputDataSource, this.inputDataSource);
            this.connected = true;
        }
    }

    synchronized boolean createTranscodingDataSource(Format outputFormat) {
        if (this.transcodingDataSource == null) {
            this.setTranscodingDataSource(new TranscodingDataSource(this.inputDataSource, outputFormat));
            return true;
        }
        return false;
    }

    synchronized void disconnect() {
        if (this.connected) {
            this.getEffectiveInputDataSource().disconnect();
            this.connected = false;
        }
    }

    public synchronized Object getControl(String controlType) {
        DataSource effectiveInputDataSource = this.getEffectiveInputDataSource();
        return effectiveInputDataSource == null ? null : effectiveInputDataSource.getControl(controlType);
    }

    public synchronized DataSource getEffectiveInputDataSource() {
        return this.transcodingDataSource == null ? this.inputDataSource : (this.connected ? this.transcodingDataSource : null);
    }

    public synchronized SourceStream[] getStreams() {
        if (!this.connected) {
            return EMPTY_STREAMS;
        }
        DataSource inputDataSource = this.getEffectiveInputDataSource();
        if (inputDataSource instanceof PushBufferDataSource) {
            return ((PushBufferDataSource)inputDataSource).getStreams();
        }
        if (inputDataSource instanceof PullBufferDataSource) {
            return ((PullBufferDataSource)inputDataSource).getStreams();
        }
        if (inputDataSource instanceof TranscodingDataSource) {
            return ((TranscodingDataSource)inputDataSource).getStreams();
        }
        return null;
    }

    private synchronized void setTranscodingDataSource(DataSource transcodingDataSource) {
        this.transcodingDataSource = transcodingDataSource;
        this.connected = false;
    }

    synchronized void start() throws IOException {
        if (this.connected) {
            this.getEffectiveInputDataSource().start();
        }
    }

    synchronized void stop() throws IOException {
        if (this.connected) {
            this.getEffectiveInputDataSource().stop();
        }
    }

    public DataSource getInputDataSource() {
        return this.inputDataSource;
    }

    public TranscodingDataSource getTranscodingDataSource() {
        return this.transcodingDataSource == null ? null : (TranscodingDataSource)this.transcodingDataSource;
    }
}

