/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.jitsi.impl.neomedia.device.CaptureDevices;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.impl.neomedia.device.Devices;
import org.jitsi.impl.neomedia.device.ExtendedCaptureDeviceInfo;
import org.jitsi.impl.neomedia.device.NotifyDevices;
import org.jitsi.impl.neomedia.device.PlaybackDevices;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AudioSystem
extends DeviceSystem {
    public static final int FEATURE_DENOISE = 2;
    public static final int FEATURE_ECHO_CANCELLATION = 4;
    public static final int FEATURE_NOTIFY_AND_PLAYBACK_DEVICES = 8;
    public static final String LOCATOR_PROTOCOL_AUDIORECORD = "audiorecord";
    public static final String LOCATOR_PROTOCOL_JAVASOUND = "javasound";
    public static final String LOCATOR_PROTOCOL_OPENSLES = "opensles";
    public static final String LOCATOR_PROTOCOL_PORTAUDIO = "portaudio";
    public static final String LOCATOR_PROTOCOL_PULSEAUDIO = "pulseaudio";
    private static Logger logger = Logger.getLogger(AudioSystem.class);
    public static final int CAPTURE_INDEX = 0;
    public static final int NOTIFY_INDEX = 1;
    public static final int PLAYBACK_INDEX = 2;
    private Devices[] devices;

    public static AudioSystem getAudioSystem(String locatorProtocol) {
        AudioSystem[] audioSystems = AudioSystem.getAudioSystems();
        AudioSystem audioSystemWithLocatorProtocol = null;
        if (audioSystems != null) {
            for (AudioSystem audioSystem : audioSystems) {
                if (!audioSystem.getLocatorProtocol().equalsIgnoreCase(locatorProtocol)) continue;
                audioSystemWithLocatorProtocol = audioSystem;
                break;
            }
        }
        return audioSystemWithLocatorProtocol;
    }

    public static AudioSystem[] getAudioSystems() {
        ArrayList<AudioSystem> audioSystems;
        DeviceSystem[] deviceSystems = DeviceSystem.getDeviceSystems(MediaType.AUDIO);
        if (deviceSystems == null) {
            audioSystems = null;
        } else {
            audioSystems = new ArrayList<AudioSystem>(deviceSystems.length);
            for (DeviceSystem deviceSystem : deviceSystems) {
                if (!(deviceSystem instanceof AudioSystem)) continue;
                audioSystems.add((AudioSystem)deviceSystem);
            }
        }
        return audioSystems == null ? null : audioSystems.toArray(new AudioSystem[audioSystems.size()]);
    }

    protected AudioSystem(String locatorProtocol) throws Exception {
        this(locatorProtocol, 0);
    }

    protected AudioSystem(String locatorProtocol, int features) throws Exception {
        super(MediaType.AUDIO, locatorProtocol, features);
    }

    public List<ExtendedCaptureDeviceInfo> getDevices(int index) {
        return this.devices[index].getDevices();
    }

    public ExtendedCaptureDeviceInfo getDevice(int index) {
        return this.devices[index].getDevice(this.getLocatorProtocol(), this.getDevices(index));
    }

    protected void setCaptureDevices(List<ExtendedCaptureDeviceInfo> activeCaptureDevices) {
        this.devices[0].setActiveDevices(activeCaptureDevices);
    }

    public void setDevice(int index, ExtendedCaptureDeviceInfo device, boolean save) {
        this.devices[index].setDevice(this.getLocatorProtocol(), device, save);
    }

    protected void setPlaybackDevices(List<ExtendedCaptureDeviceInfo> activePlaybackDevices) {
        this.devices[2].setActiveDevices(activePlaybackDevices);
        this.devices[1].setActiveDevices(activePlaybackDevices);
    }

    @Override
    protected void preInitialize() {
        super.preInitialize();
        if (this.devices == null) {
            this.devices = new Devices[3];
            this.devices[0] = new CaptureDevices(this);
            this.devices[1] = new NotifyDevices(this);
            this.devices[2] = new PlaybackDevices(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void postInitialize() {
        try {
            try {
                this.postInitializeSpecificDevices(0);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if ((8 & this.getFeatures()) == 0) throw throwable;
                try {
                    this.postInitializeSpecificDevices(1);
                    Object var4_5 = null;
                    this.postInitializeSpecificDevices(2);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var4_6 = null;
                    this.postInitializeSpecificDevices(2);
                    throw throwable2;
                }
            }
            if ((8 & this.getFeatures()) != 0) {
                try {
                    this.postInitializeSpecificDevices(1);
                    Object var4_3 = null;
                    this.postInitializeSpecificDevices(2);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.postInitializeSpecificDevices(2);
                    throw throwable;
                }
            }
            Object var6_10 = null;
            super.postInitialize();
            return;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            super.postInitialize();
            throw throwable;
        }
    }

    protected void postInitializeSpecificDevices(int index) {
        List<ExtendedCaptureDeviceInfo> activeDevices = this.getDevices(index);
        Devices devices = this.devices[index];
        String locatorProtocol = this.getLocatorProtocol();
        ExtendedCaptureDeviceInfo selectedActiveDevice = devices.getDevice(locatorProtocol, activeDevices);
        devices.setDevice(locatorProtocol, selectedActiveDevice, false);
    }

    public void propertyChange(String property, Object oldValue, Object newValue) {
        this.firePropertyChange(property, oldValue, newValue);
    }

    public InputStream getAudioInputStream(String uri) throws IOException {
        AudioInputStream audioStream = null;
        ResourceManagementService resources = LibJitsi.getResourceManagementService();
        URL url = resources == null ? null : resources.getSoundURLForPath(uri);
        try {
            if (url == null) {
                url = new URL(uri);
            }
            audioStream = javax.sound.sampled.AudioSystem.getAudioInputStream(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (UnsupportedAudioFileException uafex) {
            logger.error("Unsupported format of audio stream " + url, uafex);
        }
        return audioStream;
    }

    public Format getFormat(InputStream audioInputStream) {
        if (!(audioInputStream instanceof AudioInputStream)) {
            return null;
        }
        javax.sound.sampled.AudioFormat audioStreamFormat = ((AudioInputStream)audioInputStream).getFormat();
        return new AudioFormat("LINEAR", (double)audioStreamFormat.getSampleRate(), audioStreamFormat.getSampleSizeInBits(), audioStreamFormat.getChannels());
    }
}

