/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.Devices;
import org.jitsi.impl.neomedia.device.ExtendedCaptureDeviceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptureDevices
extends Devices {
    public static final String PROP_DEVICE = "captureDevice";
    private List<ExtendedCaptureDeviceInfo> activeCaptureDevices;

    public CaptureDevices(AudioSystem audioSystem) {
        super(audioSystem);
    }

    @Override
    public List<ExtendedCaptureDeviceInfo> getDevices() {
        List<ExtendedCaptureDeviceInfo> devices;
        if (this.activeCaptureDevices == null) {
            devices = Collections.emptyList();
        } else {
            devices = new ArrayList<ExtendedCaptureDeviceInfo>(this.activeCaptureDevices.size());
            AudioFormat format = new AudioFormat("LINEAR", -1.0, 16, -1);
            block0: for (ExtendedCaptureDeviceInfo device : this.activeCaptureDevices) {
                for (Format deviceFormat : device.getFormats()) {
                    if (!deviceFormat.matches((Format)format)) continue;
                    devices.add(device);
                    continue block0;
                }
            }
        }
        return devices;
    }

    @Override
    protected String getPropDevice() {
        return PROP_DEVICE;
    }

    @Override
    public void setActiveDevices(List<ExtendedCaptureDeviceInfo> activeDevices) {
        if (activeDevices == null) {
            this.activeCaptureDevices = null;
        } else {
            boolean commit = false;
            for (ExtendedCaptureDeviceInfo activeDevice : activeDevices) {
                CaptureDeviceManager.addDevice((CaptureDeviceInfo)activeDevice);
                commit = true;
            }
            if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
                try {
                    CaptureDeviceManager.commit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.activeCaptureDevices = new ArrayList<ExtendedCaptureDeviceInfo>(activeDevices);
        }
    }
}

