/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import net.java.sip.communicator.impl.neomedia.directshow.DSCaptureDevice;
import net.java.sip.communicator.impl.neomedia.directshow.DSFormat;
import net.java.sip.communicator.impl.neomedia.directshow.DSManager;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.device.DeviceSystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DataSource;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;

public class DirectShowSystem
extends DeviceSystem {
    private static final Logger logger = Logger.getLogger(DirectShowSystem.class);
    private static final String LOCATOR_PROTOCOL = "directshow";

    public DirectShowSystem() throws Exception {
        super(MediaType.VIDEO, LOCATOR_PROTOCOL);
    }

    protected void doInitialize() throws Exception {
        int count;
        DSCaptureDevice[] devices = DSManager.getInstance().getCaptureDevices();
        boolean captureDeviceInfoIsAdded = false;
        int n = count = devices == null ? 0 : devices.length;
        for (int i = 0; i < count; ++i) {
            long pixelFormat = devices[i].getFormat().getPixelFormat();
            int ffmpegPixFmt = (int)DataSource.getFFmpegPixFmt(pixelFormat);
            AVFrameFormat format = null;
            if (ffmpegPixFmt == -1) {
                logger.warn("No support for this webcam: " + devices[i].getName() + "(format " + pixelFormat + " not supported)");
                continue;
            }
            format = new AVFrameFormat(ffmpegPixFmt, (int)pixelFormat);
            if (logger.isInfoEnabled()) {
                for (DSFormat f : devices[i].getSupportedFormats()) {
                    if (f.getWidth() == 0 || f.getHeight() == 0) continue;
                    logger.info("Webcam available resolution for " + devices[i].getName() + ":" + f.getWidth() + "x" + f.getHeight());
                }
            }
            CaptureDeviceInfo device = new CaptureDeviceInfo(devices[i].getName(), new MediaLocator("directshow:" + devices[i].getName()), new Format[]{format});
            if (logger.isInfoEnabled()) {
                logger.info("Found[" + i + "]: " + device.getName());
            }
            CaptureDeviceManager.addDevice((CaptureDeviceInfo)device);
            captureDeviceInfoIsAdded = true;
        }
        if (captureDeviceInfoIsAdded && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
            CaptureDeviceManager.commit();
        }
        DSManager.dispose();
    }
}

