/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.protocol.PullBufferDataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;

public abstract class AbstractVideoPullBufferStream
extends AbstractPullBufferStream {
    private float frameRate;
    private FrameRateControl frameRateControl;
    private long minimumVideoFrameInterval;

    protected AbstractVideoPullBufferStream(PullBufferDataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
    }

    protected abstract void doRead(Buffer var1) throws IOException;

    public void read(Buffer buffer) throws IOException {
        float frameRate;
        FrameRateControl frameRateControl = this.frameRateControl;
        if (frameRateControl != null && (frameRate = frameRateControl.getFrameRate()) > 0.0f) {
            if (this.frameRate != frameRate) {
                this.minimumVideoFrameInterval = (long)(1000.0f / frameRate);
                this.frameRate = frameRate;
            }
            if (this.minimumVideoFrameInterval > 0L) {
                long startTime = System.currentTimeMillis();
                this.doRead(buffer);
                if (!buffer.isDiscard()) {
                    long sleep;
                    boolean interrupted = false;
                    while ((sleep = this.minimumVideoFrameInterval - (System.currentTimeMillis() - startTime)) > 0L) {
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                    Thread.yield();
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }
        this.doRead(buffer);
    }

    public void start() throws IOException {
        super.start();
        this.frameRateControl = (FrameRateControl)this.dataSource.getControl(FrameRateControl.class.getName());
    }

    public void stop() throws IOException {
        super.stop();
        this.frameRateControl = null;
    }
}

