/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.video4linux2;

import java.awt.Dimension;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ByteBufferPool;
import org.jitsi.impl.neomedia.jmfext.media.protocol.video4linux2.DataSource;
import org.jitsi.impl.neomedia.jmfext.media.protocol.video4linux2.Video4Linux2;

public class Video4Linux2Stream
extends AbstractVideoPullBufferStream {
    private long avctx = 0L;
    private long avframe = 0L;
    private final ByteBufferPool byteBufferPool = new ByteBufferPool();
    private int capabilities = 0;
    private int fd = -1;
    private Format format;
    private int[] mmapLengths;
    private long[] mmaps;
    private int nativePixelFormat = 0;
    private int requestbuffersCount = 0;
    private int requestbuffersMemory = 0;
    private boolean startInRead = false;
    private long v4l2_buffer = Video4Linux2.v4l2_buffer_alloc(1);

    public Video4Linux2Stream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
        if (0L == this.v4l2_buffer) {
            throw new OutOfMemoryError("v4l2_buffer_alloc");
        }
        Video4Linux2.v4l2_buffer_setMemory(this.v4l2_buffer, 1);
    }

    public void close() {
        super.close();
        if (this.v4l2_buffer != 0L) {
            Video4Linux2.free(this.v4l2_buffer);
            this.v4l2_buffer = 0L;
        }
        this.byteBufferPool.drain();
    }

    protected Format doGetFormat() {
        Format format;
        if (this.format == null) {
            format = this.getFdFormat();
            if (format == null) {
                format = super.doGetFormat();
            } else {
                VideoFormat videoFormat = (VideoFormat)format;
                if (videoFormat.getSize() != null) {
                    this.format = format;
                }
            }
        } else {
            format = this.format;
        }
        return format;
    }

    protected void doRead(Buffer buffer) throws IOException {
        Format format = buffer.getFormat();
        if (!(format instanceof AVFrameFormat)) {
            format = null;
        }
        if (format == null && (format = this.getFormat()) != null) {
            buffer.setFormat(format);
        }
        if (this.startInRead) {
            this.startInRead = false;
            long v4l2_buf_type = Video4Linux2.v4l2_buf_type_alloc(1);
            if (0L == v4l2_buf_type) {
                throw new OutOfMemoryError("v4l2_buf_type_alloc");
            }
            try {
                if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_STREAMON, v4l2_buf_type) == -1) {
                    throw new IOException("ioctl: request= VIDIOC_STREAMON");
                }
            }
            finally {
                Video4Linux2.free(v4l2_buf_type);
            }
        }
        if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_DQBUF, this.v4l2_buffer) == -1) {
            throw new IOException("ioctl: request= VIDIOC_DQBUF");
        }
        long timeStamp = System.nanoTime();
        try {
            int index = Video4Linux2.v4l2_buffer_getIndex(this.v4l2_buffer);
            long mmap = this.mmaps[index];
            int bytesused = Video4Linux2.v4l2_buffer_getBytesused(this.v4l2_buffer);
            if (this.nativePixelFormat == Video4Linux2.V4L2_PIX_FMT_JPEG || this.nativePixelFormat == Video4Linux2.V4L2_PIX_FMT_MJPEG) {
                Object out;
                if (this.avctx == 0L) {
                    long avcodec = FFmpeg.avcodec_find_decoder(8);
                    this.avctx = FFmpeg.avcodec_alloc_context3(avcodec);
                    FFmpeg.avcodeccontext_set_workaround_bugs(this.avctx, 1);
                    if (FFmpeg.avcodec_open2(this.avctx, avcodec, new String[0]) < 0) {
                        throw new RuntimeException("Could not open codec CODEC_ID_MJPEG");
                    }
                    this.avframe = FFmpeg.avcodec_alloc_frame();
                }
                if (!(FFmpeg.avcodec_decode_video(this.avctx, this.avframe, mmap, bytesused) == -1 || (out = buffer.getData()) instanceof AVFrame && ((AVFrame)out).getPtr() == this.avframe)) {
                    buffer.setData((Object)new AVFrame(this.avframe));
                }
            } else {
                ByteBuffer data = this.byteBufferPool.getBuffer(bytesused);
                if (data != null) {
                    Video4Linux2.memcpy(data.getPtr(), mmap, bytesused);
                    data.setLength(bytesused);
                    if (AVFrame.read(buffer, format, data) < 0) {
                        data.free();
                    }
                }
            }
        }
        finally {
            if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_QBUF, this.v4l2_buffer) == -1) {
                throw new IOException("ioctl: request= VIDIOC_QBUF");
            }
        }
        buffer.setFlags(32896);
        buffer.setTimeStamp(timeStamp);
    }

    private Format getFdFormat() {
        AVFrameFormat format = null;
        if (-1 != this.fd) {
            long v4l2_format = Video4Linux2.v4l2_format_alloc(1);
            if (v4l2_format == 0L) {
                throw new OutOfMemoryError("v4l2_format_alloc");
            }
            try {
                long fmtPix;
                int pixelformat;
                int ffmpegPixFmt;
                if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_G_FMT, v4l2_format) != -1 && -1 != (ffmpegPixFmt = DataSource.getFFmpegPixFmt(pixelformat = Video4Linux2.v4l2_pix_format_getPixelformat(fmtPix = Video4Linux2.v4l2_format_getFmtPix(v4l2_format))))) {
                    int width = Video4Linux2.v4l2_pix_format_getWidth(fmtPix);
                    int height = Video4Linux2.v4l2_pix_format_getHeight(fmtPix);
                    format = new AVFrameFormat(new Dimension(width, height), -1.0f, ffmpegPixFmt, pixelformat);
                }
            }
            finally {
                Video4Linux2.free(v4l2_format);
            }
        }
        return format;
    }

    private void munmap() {
        try {
            if (this.mmaps != null) {
                int i = 0;
                while (i < this.mmaps.length) {
                    long mmap = this.mmaps[i];
                    if (mmap != 0L) {
                        Video4Linux2.munmap(mmap, this.mmapLengths[i]);
                        this.mmaps[i] = 0L;
                        this.mmapLengths[i] = 0;
                    }
                    ++i;
                }
            }
        }
        finally {
            this.mmaps = null;
            this.mmapLengths = null;
        }
    }

    private void negotiateFdInputMethod() throws IOException {
        long v4l2_capability = Video4Linux2.v4l2_capability_alloc();
        if (0L == v4l2_capability) {
            throw new OutOfMemoryError("v4l2_capability_alloc");
        }
        try {
            if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_QUERYCAP, v4l2_capability) == -1) {
                throw new IOException("ioctl: request= VIDIOC_QUERYCAP");
            }
            this.capabilities = Video4Linux2.v4l2_capability_getCapabilities(v4l2_capability);
        }
        finally {
            Video4Linux2.free(v4l2_capability);
        }
        if ((this.capabilities & 0x4000000) != 0x4000000) {
            throw new IOException("Non-streaming V4L2 device not supported.");
        }
        long v4l2_requestbuffers = Video4Linux2.v4l2_requestbuffers_alloc(1);
        if (0L == v4l2_requestbuffers) {
            throw new OutOfMemoryError("v4l2_requestbuffers_alloc");
        }
        try {
            this.requestbuffersMemory = 1;
            Video4Linux2.v4l2_requestbuffers_setMemory(v4l2_requestbuffers, this.requestbuffersMemory);
            Video4Linux2.v4l2_requestbuffers_setCount(v4l2_requestbuffers, 2);
            if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_REQBUFS, v4l2_requestbuffers) == -1) {
                throw new IOException("ioctl: request= VIDIOC_REQBUFS, memory= " + this.requestbuffersMemory);
            }
            this.requestbuffersCount = Video4Linux2.v4l2_requestbuffers_getCount(v4l2_requestbuffers);
        }
        finally {
            Video4Linux2.free(v4l2_requestbuffers);
        }
        if (this.requestbuffersCount < 1) {
            throw new IOException("Insufficient V4L2 device memory.");
        }
        long v4l2_buffer = Video4Linux2.v4l2_buffer_alloc(1);
        if (0L == v4l2_buffer) {
            throw new OutOfMemoryError("v4l2_buffer_alloc");
        }
        try {
            Video4Linux2.v4l2_buffer_setMemory(v4l2_buffer, 1);
            this.mmaps = new long[this.requestbuffersCount];
            this.mmapLengths = new int[this.requestbuffersCount];
            boolean munmap = true;
            try {
                int i = 0;
                while (i < this.requestbuffersCount) {
                    long offset;
                    Video4Linux2.v4l2_buffer_setIndex(v4l2_buffer, i);
                    if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_QUERYBUF, v4l2_buffer) == -1) {
                        throw new IOException("ioctl: request= VIDIOC_QUERYBUF");
                    }
                    int length = Video4Linux2.v4l2_buffer_getLength(v4l2_buffer);
                    long mmap = Video4Linux2.mmap(0L, length, 3, 1, this.fd, offset = Video4Linux2.v4l2_buffer_getMOffset(v4l2_buffer));
                    if (-1L == mmap) {
                        throw new IOException("mmap");
                    }
                    this.mmaps[i] = mmap;
                    this.mmapLengths[i] = length;
                    ++i;
                }
                munmap = false;
            }
            finally {
                if (munmap) {
                    this.munmap();
                }
            }
        }
        finally {
            Video4Linux2.free(v4l2_buffer);
        }
    }

    void setFd(int fd) throws IOException {
        if (this.fd != fd) {
            if (this.fd != -1) {
                try {
                    this.stop();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.munmap();
            }
            this.fd = -1;
            this.capabilities = 0;
            this.requestbuffersMemory = 0;
            this.requestbuffersCount = 0;
            if (fd != -1) {
                Format format = this.getFormat();
                this.fd = fd;
                if (format != null) {
                    this.setFdFormat(format);
                }
                this.setFdCropToDefault();
                this.negotiateFdInputMethod();
            }
        }
    }

    private void setFdCropToDefault() {
    }

    private void setFdFormat(Format format) throws IOException {
        int pixelformat = 0;
        if (format instanceof AVFrameFormat) {
            this.nativePixelFormat = pixelformat = ((AVFrameFormat)format).getDeviceSystemPixFmt();
        }
        if (pixelformat == 0) {
            throw new IOException("Unsupported format " + format);
        }
        long v4l2_format = Video4Linux2.v4l2_format_alloc(1);
        if (v4l2_format == 0L) {
            throw new OutOfMemoryError("v4l2_format_alloc");
        }
        try {
            if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_G_FMT, v4l2_format) == -1) {
                throw new IOException("ioctl: request= VIDIO_G_FMT");
            }
            VideoFormat videoFormat = (VideoFormat)format;
            Dimension size = videoFormat.getSize();
            long fmtPix = Video4Linux2.v4l2_format_getFmtPix(v4l2_format);
            int width = Video4Linux2.v4l2_pix_format_getWidth(fmtPix);
            int height = Video4Linux2.v4l2_pix_format_getHeight(fmtPix);
            boolean setFdFormat = false;
            if (size == null) {
                size = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoSize();
            }
            if (size != null && (size.width != width || size.height != height)) {
                Video4Linux2.v4l2_pix_format_setWidthAndHeight(fmtPix, size.width, size.height);
                setFdFormat = true;
            }
            if (Video4Linux2.v4l2_pix_format_getPixelformat(v4l2_format) != pixelformat) {
                Video4Linux2.v4l2_pix_format_setPixelformat(fmtPix, pixelformat);
                setFdFormat = true;
            }
            if (setFdFormat) {
                this.setFdFormat(v4l2_format, fmtPix, size, pixelformat);
            }
        }
        finally {
            Video4Linux2.free(v4l2_format);
        }
    }

    private void setFdFormat(long v4l2_format, long fmtPix, Dimension size, int pixelformat) throws IOException {
        Video4Linux2.v4l2_pix_format_setField(fmtPix, 1);
        Video4Linux2.v4l2_pix_format_setBytesperline(fmtPix, 0);
        if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_S_FMT, v4l2_format) == -1) {
            throw new IOException("ioctl: request= VIDIOC_S_FMT" + (size == null ? "" : ", width= " + size.width + ", height= " + size.height) + ", pixelformat= " + pixelformat);
        }
        if (Video4Linux2.v4l2_pix_format_getPixelformat(fmtPix) != pixelformat) {
            throw new IOException("Failed to change the format of the V4L2 device to " + pixelformat);
        }
    }

    public void start() throws IOException {
        super.start();
        long v4l2_buffer = Video4Linux2.v4l2_buffer_alloc(1);
        if (0L == v4l2_buffer) {
            throw new OutOfMemoryError("v4l2_buffer_alloc");
        }
        try {
            Video4Linux2.v4l2_buffer_setMemory(v4l2_buffer, 1);
            int i = 0;
            while (i < this.requestbuffersCount) {
                Video4Linux2.v4l2_buffer_setIndex(v4l2_buffer, i);
                if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_QBUF, v4l2_buffer) == -1) {
                    throw new IOException("ioctl: request= VIDIOC_QBUF, index= " + i);
                }
                ++i;
            }
        }
        finally {
            Video4Linux2.free(v4l2_buffer);
        }
        this.startInRead = true;
    }

    public void stop() throws IOException {
        try {
            long v4l2_buf_type = Video4Linux2.v4l2_buf_type_alloc(1);
            if (0L == v4l2_buf_type) {
                throw new OutOfMemoryError("v4l2_buf_type_alloc");
            }
            try {
                if (Video4Linux2.ioctl(this.fd, Video4Linux2.VIDIOC_STREAMOFF, v4l2_buf_type) == -1) {
                    throw new IOException("ioctl: request= VIDIOC_STREAMOFF");
                }
            }
            finally {
                Video4Linux2.free(v4l2_buf_type);
            }
        }
        finally {
            super.stop();
            if (this.avctx != 0L) {
                FFmpeg.avcodec_close(this.avctx);
                FFmpeg.av_free(this.avctx);
                this.avctx = 0L;
            }
            if (this.avframe != 0L) {
                FFmpeg.avcodec_free_frame(this.avframe);
                this.avframe = 0L;
            }
            this.byteBufferPool.drain();
        }
    }
}

