/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Recorder;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VolumeControl;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.device.ScreenDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.format.MediaFormatFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface MediaService {
    public static final String DEFAULT_DEVICE = "defaultDevice";

    public MediaDevice getDefaultDevice(MediaType var1, MediaUseCase var2);

    public List<MediaDevice> getDevices(MediaType var1, MediaUseCase var2);

    public MediaStream createMediaStream(MediaDevice var1);

    public MediaStream createMediaStream(MediaType var1);

    public MediaStream createMediaStream(StreamConnector var1, MediaDevice var2);

    public MediaStream createMediaStream(StreamConnector var1, MediaDevice var2, SrtpControl var3);

    public MediaDevice createMixer(MediaDevice var1);

    public MediaFormatFactory getFormatFactory();

    public ZrtpControl createZrtpControl();

    public SDesControl createSDesControl();

    public VolumeControl getOutputVolumeControl();

    public VolumeControl getInputVolumeControl();

    public List<ScreenDevice> getAvailableScreenDevices();

    public ScreenDevice getDefaultScreenDevice();

    public Recorder createRecorder(MediaDevice var1);

    public Map<MediaFormat, Byte> getDynamicPayloadTypePreferences();

    public Object getVideoPreviewComponent(MediaDevice var1, int var2, int var3);

    public MediaDevice getMediaDeviceForPartialDesktopStreaming(int var1, int var2, int var3, int var4);

    public boolean isPartialStreaming(MediaDevice var1);

    public Point getOriginForDesktopStreamingDevice(MediaDevice var1);

    public void addRecorderListener(Recorder.Listener var1);

    public void removeRecorderListener(Recorder.Listener var1);

    public Iterator<Recorder.Listener> getRecorderListeners();

    public RTPTranslator createRTPTranslator();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public EncodingConfiguration createEmptyEncodingConfiguration();

    public EncodingConfiguration getCurrentEncodingConfiguration();
}

