/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.event;

import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;

public class VideoNotifierSupport {
    private static final long THREAD_TIMEOUT = 5000L;
    private final List<VideoEvent> events;
    private final List<VideoListener> listeners = new ArrayList<VideoListener>();
    private final Object source;
    private final boolean synchronous;
    private Thread thread;

    public VideoNotifierSupport(Object source) {
        this(source, true);
    }

    public VideoNotifierSupport(Object source, boolean synchronous) {
        this.source = source;
        this.synchronous = synchronous;
        this.events = this.synchronous ? null : new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoListener(VideoListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<VideoListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFireVideoEvent(VideoEvent event) {
        VideoListener[] listeners;
        List<VideoListener> list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray(new VideoListener[this.listeners.size()]);
        }
        block7: for (VideoListener listener : listeners) {
            switch (event.getType()) {
                case 1: {
                    listener.videoAdded(event);
                    continue block7;
                }
                case 2: {
                    listener.videoRemoved(event);
                    continue block7;
                }
                default: {
                    listener.videoUpdate(event);
                }
            }
        }
    }

    public boolean fireVideoEvent(int type, Component visualComponent, int origin, boolean wait) {
        VideoEvent event = new VideoEvent(this.source, type, visualComponent, origin);
        this.fireVideoEvent(event, wait);
        return event.isConsumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVideoEvent(VideoEvent event, boolean wait) {
        if (this.synchronous) {
            this.doFireVideoEvent(event);
        } else {
            List<VideoEvent> list = this.events;
            synchronized (list) {
                this.events.add(event);
                if (this.thread == null) {
                    this.startThread();
                } else {
                    this.events.notify();
                }
                if (wait) {
                    boolean interrupted = false;
                    while (this.events.contains(event) && this.thread != null) {
                        try {
                            this.events.wait();
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVideoListener(VideoListener listener) {
        List<VideoListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        while (true) {
            List<VideoEvent> list;
            block16: {
                VideoEvent event = null;
                list = this.events;
                synchronized (list) {
                    long emptyTime = -1L;
                    boolean interrupted = false;
                    while (this.events.isEmpty()) {
                        if (emptyTime == -1L) {
                            emptyTime = System.currentTimeMillis();
                        } else {
                            long newEmptyTime = System.currentTimeMillis();
                            if (newEmptyTime - emptyTime >= 5000L) {
                                this.events.notify();
                                return;
                            }
                        }
                        try {
                            this.events.wait(5000L);
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    event = this.events.remove(0);
                }
                if (event == null) continue;
                try {
                    this.doFireVideoEvent(event);
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block16;
                    throw (ThreadDeath)t;
                }
            }
            list = this.events;
            synchronized (list) {
                this.events.notify();
            }
        }
    }

    private void startThread() {
        this.thread = new Thread("VideoNotifierSupportThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    VideoNotifierSupport.this.runInThread();
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    List list = VideoNotifierSupport.this.events;
                    synchronized (list) {
                        if (Thread.currentThread().equals(VideoNotifierSupport.this.thread)) {
                            VideoNotifierSupport.this.thread = null;
                            if (VideoNotifierSupport.this.events.isEmpty()) {
                                VideoNotifierSupport.this.events.notify();
                            } else {
                                VideoNotifierSupport.this.startThread();
                            }
                        }
                    }
                    throw throwable;
                }
                List list = VideoNotifierSupport.this.events;
                synchronized (list) {
                    if (Thread.currentThread().equals(VideoNotifierSupport.this.thread)) {
                        VideoNotifierSupport.this.thread = null;
                        if (VideoNotifierSupport.this.events.isEmpty()) {
                            VideoNotifierSupport.this.events.notify();
                        } else {
                            VideoNotifierSupport.this.startThread();
                        }
                    }
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }
}

