/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;
import org.jitsi.util.swing.VideoContainer;

public class FitLayout
implements LayoutManager {
    public void addLayoutComponent(String name, Component comp) {
    }

    protected Component getComponent(Container parent) {
        Component[] components = parent.getComponents();
        return components.length > 0 ? components[0] : null;
    }

    protected void layoutComponent(Component component, Rectangle bounds, float alignmentX, float alignmentY) {
        Dimension componentSize;
        if (component instanceof JPanel && !component.isOpaque() && ((Container)component).getComponentCount() > 1 || component instanceof VideoContainer) {
            componentSize = bounds.getSize();
        } else {
            double heightRatio;
            double widthRatio;
            componentSize = component.getPreferredSize();
            boolean scale = false;
            if (componentSize.width != bounds.width && componentSize.width > 0) {
                scale = true;
                widthRatio = (double)bounds.width / (double)componentSize.width;
            } else {
                widthRatio = 1.0;
            }
            if (componentSize.height != bounds.height && componentSize.height > 0) {
                scale = true;
                heightRatio = (double)bounds.height / (double)componentSize.height;
            } else {
                heightRatio = 1.0;
            }
            if (scale) {
                double ratio = Math.min(widthRatio, heightRatio);
                componentSize.width = (int)((double)componentSize.width * ratio);
                componentSize.height = (int)((double)componentSize.height * ratio);
            }
        }
        if (component.isMaximumSizeSet()) {
            Dimension maximumSize = component.getMaximumSize();
            if (componentSize.width > maximumSize.width) {
                componentSize.width = maximumSize.width;
            }
            if (componentSize.height > maximumSize.height) {
                componentSize.height = maximumSize.height;
            }
        }
        if (componentSize.height < 1) {
            componentSize.height = 1;
        }
        if (componentSize.width < 1) {
            componentSize.width = 1;
        }
        component.setBounds(bounds.x + Math.round((float)(bounds.width - componentSize.width) * alignmentX), bounds.y + Math.round((float)(bounds.height - componentSize.height) * alignmentY), componentSize.width, componentSize.height);
    }

    public void layoutContainer(Container parent) {
        this.layoutContainer(parent, 0.5f);
    }

    protected void layoutContainer(Container parent, float componentAlignmentX) {
        Component component = this.getComponent(parent);
        if (component != null) {
            this.layoutComponent(component, new Rectangle(parent.getSize()), componentAlignmentX, 0.5f);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Component component = this.getComponent(parent);
        return component != null ? component.getMinimumSize() : new Dimension(0, 0);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Component component = this.getComponent(parent);
        return component != null ? component.getPreferredSize() : new Dimension(0, 0);
    }

    public void removeLayoutComponent(Component comp) {
    }
}

