/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.engines.ThreefishCipher;
import org.bouncycastle.util.ByteLong;

public class Skein
implements ExtendedDigest {
    public static final int NORMAL = 0;
    public static final int ZEROED_STATE = 1;
    public static final int CHAINED_STATE = 2;
    public static final int CHAINED_CONFIG = 3;
    private final byte[] schema = new byte[]{83, 72, 65, 51};
    private ThreefishCipher cipher;
    private int cipherStateBits;
    private int cipherStateBytes;
    private int cipherStateWords;
    private int outputBytes;
    private byte[] inputBuffer;
    private int bytesFilled;
    private long[] cipherInput;
    private long[] state;
    private int hashSize;
    SkeinConfig configuration;
    public UbiTweak ubiParameters;

    public int getStateSize() {
        return this.cipherStateBits;
    }

    public Skein(int n, int n2) throws IllegalArgumentException {
        this.setup(n, n2);
        this.configuration = new SkeinConfig(this);
        this.configuration.setSchema(this.schema);
        this.configuration.setVersion(1);
        this.configuration.generateConfiguration();
        this.initialize();
    }

    public Skein(int n, int n2, long l, byte[] byArray) throws IllegalArgumentException {
        this.setup(n, n2);
        if (byArray.length > 0) {
            this.outputBytes = this.cipherStateBytes;
            this.ubiParameters.startNewBlockType(0L);
            this.update(byArray, 0, byArray.length);
            byte[] byArray2 = this.finalPad();
            for (int i = 0; i < this.cipherStateWords; ++i) {
                this.state[i] = ByteLong.GetUInt64(byArray2, i * 8);
            }
        }
        this.outputBytes = (n2 + 7) / 8;
        this.configuration = new SkeinConfig(this);
        this.configuration.setSchema(this.schema);
        this.configuration.setVersion(1);
        this.initialize(3);
    }

    private void setup(int n, int n2) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Skein: Output bit size must be greater than zero.");
        }
        this.cipherStateBits = n;
        this.cipherStateBytes = n / 8;
        this.cipherStateWords = n / 64;
        this.hashSize = n2;
        this.outputBytes = (n2 + 7) / 8;
        this.cipher = ThreefishCipher.createCipher(n);
        if (this.cipher == null) {
            throw new IllegalArgumentException("Skein: Unsupported state size.");
        }
        this.inputBuffer = new byte[this.cipherStateBytes];
        this.cipherInput = new long[this.cipherStateWords];
        this.state = new long[this.cipherStateWords];
        this.ubiParameters = new UbiTweak();
    }

    void ProcessBlock(int n) {
        this.cipher.setKey(this.state);
        this.ubiParameters.addBytesProcessed(n);
        this.cipher.setTweak(this.ubiParameters.getTweak());
        this.cipher.encrypt(this.cipherInput, this.state);
        for (int i = 0; i < this.cipherInput.length; ++i) {
            int n2 = i;
            this.state[n2] = this.state[n2] ^ this.cipherInput[i];
        }
    }

    public void updateBits(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.ubiParameters.isBitPad()) {
            throw new IllegalStateException("Skein: partial byte only on last data block");
        }
        if ((n2 & 7) == 0) {
            this.update(byArray, n, n2 >>> 3);
            return;
        }
        this.update(byArray, n, (n2 >>> 3) + 1);
        byte by = (byte)(1 << 7 - (n2 & 7));
        this.inputBuffer[this.bytesFilled - 1] = (byte)(this.inputBuffer[this.bytesFilled - 1] & 0 - by | by);
        this.ubiParameters.setBitPad(true);
    }

    public void update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (this.bytesFilled == this.cipherStateBytes) {
                this.InputBufferToCipherInput();
                this.ProcessBlock(this.cipherStateBytes);
                this.ubiParameters.setFirstBlock(false);
                this.bytesFilled = 0;
            }
            this.inputBuffer[this.bytesFilled++] = byArray[n++];
        }
    }

    public byte[] doFinal() {
        int n;
        int n2;
        for (n2 = this.bytesFilled; n2 < this.inputBuffer.length; ++n2) {
            this.inputBuffer[n2] = 0;
        }
        this.InputBufferToCipherInput();
        this.ubiParameters.setFinalBlock(true);
        this.ProcessBlock(this.bytesFilled);
        for (n2 = 0; n2 < this.cipherInput.length; ++n2) {
            this.cipherInput[n2] = 0L;
        }
        byte[] byArray = new byte[this.outputBytes];
        long[] lArray = new long[this.cipherStateWords];
        for (n = 0; n < this.state.length; ++n) {
            lArray[n] = this.state[n];
        }
        for (n2 = 0; n2 < this.outputBytes; n2 += this.cipherStateBytes) {
            this.ubiParameters.startNewBlockType(63L);
            this.ubiParameters.setFinalBlock(true);
            this.ProcessBlock(8);
            int n3 = this.outputBytes - n2;
            if (n3 > this.cipherStateBytes) {
                n3 = this.cipherStateBytes;
            }
            ByteLong.PutBytes(this.state, byArray, n2, n3);
            for (n = 0; n < this.state.length; ++n) {
                this.state[n] = lArray[n];
            }
            this.cipherInput[0] = this.cipherInput[0] + 1L;
        }
        this.reset();
        return byArray;
    }

    private byte[] finalPad() {
        int n;
        for (n = this.bytesFilled; n < this.inputBuffer.length; ++n) {
            this.inputBuffer[n] = 0;
        }
        this.InputBufferToCipherInput();
        this.ubiParameters.setFinalBlock(true);
        this.ProcessBlock(this.bytesFilled);
        byte[] byArray = new byte[this.outputBytes];
        for (n = 0; n < this.outputBytes; n += this.cipherStateBytes) {
            int n2 = this.outputBytes - n;
            if (n2 > this.cipherStateBytes) {
                n2 = this.cipherStateBytes;
            }
            ByteLong.PutBytes(this.state, byArray, n, n2);
        }
        return byArray;
    }

    private void initialize(int n) {
        switch (n) {
            case 0: {
                this.initialize();
                return;
            }
            case 1: {
                for (int i = 0; i < this.state.length; ++i) {
                    this.state[i] = 0L;
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.configuration.generateConfiguration(this.state);
                this.initialize();
                return;
            }
        }
        this.bytesFilled = 0;
    }

    private final void initialize() {
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = this.configuration.ConfigValue[i];
        }
        this.ubiParameters.startNewBlockType(48L);
        this.bytesFilled = 0;
    }

    public final void initialize(long[] lArray) {
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = lArray[i];
        }
        this.ubiParameters.startNewBlockType(48L);
        this.bytesFilled = 0;
    }

    void InputBufferToCipherInput() {
        for (int i = 0; i < this.cipherStateWords; ++i) {
            this.cipherInput[i] = ByteLong.GetUInt64(this.inputBuffer, i * 8);
        }
    }

    public int getcipherStateBits() {
        return this.cipherStateBits;
    }

    public int getHashSize() {
        return this.hashSize;
    }

    public String getAlgorithmName() {
        return "Skein" + this.cipherStateBits;
    }

    public int getDigestSize() {
        return this.outputBytes;
    }

    public void update(byte by) {
        byte[] byArray = new byte[1];
        this.update(byArray, 0, 1);
    }

    public int doFinal(byte[] byArray, int n) {
        byte[] byArray2 = this.doFinal();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public void reset() {
        this.initialize();
    }

    public int getByteLength() {
        return this.cipherStateBytes;
    }

    public long[] getState() {
        long[] lArray = new long[this.state.length];
        for (int i = 0; i < this.state.length; ++i) {
            lArray[i] = this.state[i];
        }
        return lArray;
    }

    class UbiTweak {
        static final long Key = 0L;
        static final long Config = 4L;
        static final long Personalization = 8L;
        static final long PublicKey = 12L;
        static final long KeyIdentifier = 16L;
        static final long Nonce = 20L;
        static final long Message = 48L;
        static final long Out = 63L;
        private static final long T1FlagFinal = Long.MIN_VALUE;
        private static final long T1FlagFirst = 0x4000000000000000L;
        private static final long T1FlagBitPad = 0x80000000000000L;
        private long[] tweak = new long[2];

        UbiTweak() {
        }

        boolean isFirstBlock() {
            return (this.tweak[1] & 0x4000000000000000L) != 0L;
        }

        void setFirstBlock(boolean bl) {
            this.tweak[1] = bl ? this.tweak[1] | 0x4000000000000000L : this.tweak[1] & 0xBFFFFFFFFFFFFFFFL;
        }

        boolean isFinalBlock() {
            return (this.tweak[1] & Long.MIN_VALUE) != 0L;
        }

        void setFinalBlock(boolean bl) {
            this.tweak[1] = bl ? this.tweak[1] | Long.MIN_VALUE : this.tweak[1] & Long.MAX_VALUE;
        }

        boolean isBitPad() {
            return (this.tweak[1] & 0x80000000000000L) != 0L;
        }

        void setBitPad(boolean bl) {
            this.tweak[1] = bl ? this.tweak[1] | 0x80000000000000L : this.tweak[1] & 0xFF7FFFFFFFFFFFFFL;
        }

        byte getTreeLevel() {
            return (byte)(this.tweak[1] >> 48 & 0x7FL);
        }

        void setTreeLevel(int n) throws Exception {
            if (n > 63) {
                throw new Exception("Tree level must be between 0 and 63, inclusive.");
            }
            this.tweak[1] = this.tweak[1] & 0xFF80FFFFFFFFFFFFL;
            this.tweak[1] = this.tweak[1] | (long)n << 48;
        }

        long[] getBitsProcessed() {
            long[] lArray = new long[]{this.tweak[0], this.tweak[1] & 0xFFFFFFFFL};
            return lArray;
        }

        void setBitsProcessed(long l) {
            this.tweak[0] = l;
            this.tweak[1] = this.tweak[1] & 0xFFFFFFFF00000000L;
        }

        void addBytesProcessed(int n) {
            long l = n;
            long[] lArray = new long[]{this.tweak[0] & 0xFFFFFFFFL, this.tweak[0] >>> 32 & 0xFFFFFFFFL, this.tweak[1] & 0xFFFFFFFFL};
            for (int i = 0; i < 3; ++i) {
                lArray[i] = l += lArray[i];
                l >>= 32;
            }
            this.tweak[0] = lArray[0] & 0xFFFFFFFFL;
            this.tweak[0] = this.tweak[0] | (lArray[1] & 0xFFFFFFFFL) << 32;
            this.tweak[1] = this.tweak[1] | lArray[2] & 0xFFFFFFFFL;
        }

        long getBlockType() {
            return this.tweak[1] >> 56 & 0x3FL;
        }

        void setBlockType(long l) {
            this.tweak[1] = l << 56;
        }

        void startNewBlockType(long l) {
            this.setBitsProcessed(0L);
            this.setBlockType(l);
            this.setFirstBlock(true);
        }

        long[] getTweak() {
            return this.tweak;
        }

        void setTweak(long[] lArray) {
            this.tweak = lArray;
        }
    }

    class SkeinConfig {
        private final int stateSize;
        long[] ConfigValue;
        long[] ConfigString;

        SkeinConfig(Skein skein2) {
            this.stateSize = skein2.getcipherStateBits();
            this.ConfigValue = new long[this.stateSize / 64];
            this.ConfigString = new long[this.ConfigValue.length];
            this.ConfigString[1] = skein2.getHashSize();
        }

        void generateConfiguration() {
            ThreefishCipher threefishCipher = ThreefishCipher.createCipher(this.stateSize);
            UbiTweak ubiTweak = new UbiTweak();
            ubiTweak.startNewBlockType(4L);
            ubiTweak.setFinalBlock(true);
            ubiTweak.setBitsProcessed(32L);
            threefishCipher.setTweak(ubiTweak.getTweak());
            threefishCipher.encrypt(this.ConfigString, this.ConfigValue);
            this.ConfigValue[0] = this.ConfigValue[0] ^ this.ConfigString[0];
            this.ConfigValue[1] = this.ConfigValue[1] ^ this.ConfigString[1];
            this.ConfigValue[2] = this.ConfigValue[2] ^ this.ConfigString[2];
        }

        void generateConfiguration(long[] lArray) {
            ThreefishCipher threefishCipher = ThreefishCipher.createCipher(this.stateSize);
            UbiTweak ubiTweak = new UbiTweak();
            ubiTweak.startNewBlockType(4L);
            ubiTweak.setFinalBlock(true);
            ubiTweak.setBitsProcessed(32L);
            threefishCipher.setKey(lArray);
            threefishCipher.setTweak(ubiTweak.getTweak());
            threefishCipher.encrypt(this.ConfigString, this.ConfigValue);
            this.ConfigValue[0] = this.ConfigValue[0] ^ this.ConfigString[0];
            this.ConfigValue[1] = this.ConfigValue[1] ^ this.ConfigString[1];
            this.ConfigValue[2] = this.ConfigValue[2] ^ this.ConfigString[2];
        }

        void setSchema(byte[] byArray) throws IllegalArgumentException {
            if (byArray.length != 4) {
                throw new IllegalArgumentException("Skein configuration: Schema must be 4 bytes.");
            }
            long l = this.ConfigString[0];
            l &= 0xFFFFFFFF00000000L;
            l |= (long)byArray[3] << 24;
            l |= (long)byArray[2] << 16;
            l |= (long)byArray[1] << 8;
            this.ConfigString[0] = l |= (long)byArray[0];
        }

        void setVersion(int n) throws IllegalArgumentException {
            if (n < 0 || n > 3) {
                throw new IllegalArgumentException("Skein configuration: Version must be between 0 and 3, inclusive.");
            }
            this.ConfigString[0] = this.ConfigString[0] & 0xFFFFFFFCFFFFFFFFL;
            this.ConfigString[0] = this.ConfigString[0] | (long)n << 32;
        }

        void setTreeLeafSize(byte by) {
            this.ConfigString[2] = this.ConfigString[2] & 0xFFFFFFFFFFFFFF00L;
            this.ConfigString[2] = this.ConfigString[2] | (long)by;
        }

        void setTreeFanOutSize(byte by) {
            this.ConfigString[2] = this.ConfigString[2] & 0xFFFFFFFFFFFF00FFL;
            this.ConfigString[2] = this.ConfigString[2] | (long)by << 8;
        }

        void setMaxTreeHeight(byte by) throws IllegalArgumentException {
            if (by == 1) {
                throw new IllegalArgumentException("Skein configuration: Tree height must be zero or greater than 1.");
            }
            this.ConfigString[2] = this.ConfigString[2] & 0xFFFFFFFFFF00FFFFL;
            this.ConfigString[2] = this.ConfigString[2] | (long)by << 16;
        }
    }
}

