/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersForThreefish;
import org.bouncycastle.util.ByteLong;

public class ThreefishCipher
implements BlockCipher {
    static final long KEY_SCHEDULE_CONST = 2004413935125273122L;
    static final int EXPANDED_TWEAK_SIZE = 3;
    private ThreefishCipher cipher;
    private boolean forEncryption;
    private int stateSize;
    long[] expanedKey;
    long[] expanedTweak = new long[3];
    private long[] cipherIn;
    private long[] cipherOut;

    public void setTweak(long[] lArray) {
        this.expanedTweak[0] = lArray[0];
        this.expanedTweak[1] = lArray[1];
        this.expanedTweak[2] = lArray[0] ^ lArray[1];
    }

    public void setKey(long[] lArray) {
        long l = 2004413935125273122L;
        for (int i = 0; i < this.expanedKey.length - 1; ++i) {
            this.expanedKey[i] = lArray[i];
            l ^= lArray[i];
        }
        this.expanedKey[i] = l;
    }

    public static ThreefishCipher createCipher(int n) {
        switch (n) {
            case 256: {
                return new ThreefishCipher().new Threefish256();
            }
            case 512: {
                return new ThreefishCipher().new Threefish512();
            }
            case 1024: {
                return new ThreefishCipher().new Threefish1024();
            }
        }
        return null;
    }

    private void setCipher(int n) {
        this.cipher = null;
        switch (n) {
            case 256: {
                this.cipher = new Threefish256();
                break;
            }
            case 512: {
                this.cipher = new Threefish512();
                break;
            }
            case 1024: {
                this.cipher = new Threefish1024();
            }
        }
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersForThreefish) {
            ParametersForThreefish parametersForThreefish = (ParametersForThreefish)cipherParameters;
            this.stateSize = parametersForThreefish.getStateSize();
            this.setCipher(this.stateSize);
            if (this.cipher == null) {
                throw new IllegalArgumentException("Threefish: unsupported state size: " + this.stateSize);
            }
            byte[] byArray = ((KeyParameter)parametersForThreefish.getParameters()).getKey();
            if (byArray.length != this.stateSize / 8) {
                throw new IllegalArgumentException("Threefish: key length does not match state size: " + byArray.length);
            }
            long[] lArray = parametersForThreefish.getTweak();
            if (lArray == null) {
                throw new IllegalArgumentException("Threefish: tweak data not set");
            }
            this.cipher.setTweak(lArray);
            long[] lArray2 = new long[this.stateSize / 64];
            for (int i = 0; i < lArray2.length; ++i) {
                lArray2[i] = ByteLong.GetUInt64(byArray, i * 8);
            }
            this.cipher.setKey(lArray2);
            this.forEncryption = bl;
            this.cipherIn = new long[this.stateSize / 64];
            this.cipherOut = new long[this.stateSize / 64];
            return;
        }
        throw new IllegalArgumentException("Threfish: invalid parameter passed to init - " + cipherParameters.getClass().getName());
    }

    public String getAlgorithmName() {
        return "Threefish";
    }

    public int getBlockSize() {
        return this.stateSize / 8;
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        int n3 = this.stateSize / 8;
        int n4 = this.stateSize / 64;
        if (this.cipher.expanedKey == null) {
            throw new IllegalStateException("Threefish: engine not initialised");
        }
        if (n + n3 > byArray.length) {
            throw new DataLengthException("Threefish: input buffer too short");
        }
        if (n2 + n3 > byArray2.length) {
            throw new DataLengthException("Threefish: output buffer too short");
        }
        for (int i = 0; i < n4; ++i) {
            this.cipherIn[i] = ByteLong.GetUInt64(byArray, n + i * 8);
        }
        if (this.forEncryption) {
            this.cipher.encrypt(this.cipherIn, this.cipherOut);
        } else {
            this.cipher.decrypt(this.cipherIn, this.cipherOut);
        }
        ByteLong.PutBytes(this.cipherOut, byArray2, n2, n3);
        return this.stateSize / 8;
    }

    public void reset() {
    }

    public void encrypt(long[] lArray, long[] lArray2) {
    }

    public void decrypt(long[] lArray, long[] lArray2) {
    }

    public class Threefish1024
    extends ThreefishCipher {
        private final int CIPHER_SIZE = 1024;
        private final int CIPHER_QWORDS = 16;
        private final int EXPANDED_KEY_SIZE = 17;

        public Threefish1024() {
            this.expanedKey = new long[17];
            this.expanedKey[16] = 2004413935125273122L;
        }

        public void encrypt(long[] lArray, long[] lArray2) {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            long l5 = lArray[4];
            long l6 = lArray[5];
            long l7 = lArray[6];
            long l8 = lArray[7];
            long l9 = lArray[8];
            long l10 = lArray[9];
            long l11 = lArray[10];
            long l12 = lArray[11];
            long l13 = lArray[12];
            long l14 = lArray[13];
            long l15 = lArray[14];
            long l16 = lArray[15];
            long l17 = this.expanedKey[0];
            long l18 = this.expanedKey[1];
            long l19 = this.expanedKey[2];
            long l20 = this.expanedKey[3];
            long l21 = this.expanedKey[4];
            long l22 = this.expanedKey[5];
            long l23 = this.expanedKey[6];
            long l24 = this.expanedKey[7];
            long l25 = this.expanedKey[8];
            long l26 = this.expanedKey[9];
            long l27 = this.expanedKey[10];
            long l28 = this.expanedKey[11];
            long l29 = this.expanedKey[12];
            long l30 = this.expanedKey[13];
            long l31 = this.expanedKey[14];
            long l32 = this.expanedKey[15];
            long l33 = this.expanedKey[16];
            long l34 = this.expanedTweak[0];
            long l35 = this.expanedTweak[1];
            long l36 = this.expanedTweak[2];
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l18) + l17);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l20) + l19);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l22) + l21);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l24) + l23);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l26) + l25);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l28) + l27);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l30 + l34) + l29);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l32) + l31 + l35);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l19) + l18);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l21) + l20);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l23) + l22);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l25) + l24);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l27) + l26);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l29) + l28);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l31 + l35) + l30);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l33 + 1L) + l32 + l36);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l20) + l19);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l22) + l21);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l24) + l23);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l26) + l25);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l28) + l27);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l30) + l29);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l32 + l36) + l31);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l17 + 2L) + l33 + l34);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l21) + l20);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l23) + l22);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l25) + l24);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l27) + l26);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l29) + l28);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l31) + l30);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l33 + l34) + l32);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l18 + 3L) + l17 + l35);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l22) + l21);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l24) + l23);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l26) + l25);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l28) + l27);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l30) + l29);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l32) + l31);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l17 + l35) + l33);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l19 + 4L) + l18 + l36);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l23) + l22);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l25) + l24);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l27) + l26);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l29) + l28);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l31) + l30);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l33) + l32);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l18 + l36) + l17);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l20 + 5L) + l19 + l34);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l24) + l23);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l26) + l25);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l28) + l27);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l30) + l29);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l32) + l31);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l17) + l33);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l19 + l34) + l18);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l21 + 6L) + l20 + l35);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l25) + l24);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l27) + l26);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l29) + l28);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l31) + l30);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l33) + l32);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l18) + l17);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l20 + l35) + l19);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l22 + 7L) + l21 + l36);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l26) + l25);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l28) + l27);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l30) + l29);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l32) + l31);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l17) + l33);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l19) + l18);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l21 + l36) + l20);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l23 + 8L) + l22 + l34);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l27) + l26);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l29) + l28);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l31) + l30);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l33) + l32);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l18) + l17);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l20) + l19);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l22 + l34) + l21);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l24 + 9L) + l23 + l35);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l28) + l27);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l30) + l29);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l32) + l31);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l17) + l33);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l19) + l18);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l21) + l20);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l23 + l35) + l22);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l25 + 10L) + l24 + l36);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l29) + l28);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l31) + l30);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l33) + l32);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l18) + l17);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l20) + l19);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l22) + l21);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l24 + l36) + l23);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l26 + 11L) + l25 + l34);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l30) + l29);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l32) + l31);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l17) + l33);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l19) + l18);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l21) + l20);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l23) + l22);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l25 + l34) + l24);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l27 + 12L) + l26 + l35);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l31) + l30);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l33) + l32);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l18) + l17);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l20) + l19);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l22) + l21);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l24) + l23);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l26 + l35) + l25);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l28 + 13L) + l27 + l36);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l32) + l31);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l17) + l33);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l19) + l18);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l21) + l20);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l23) + l22);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l25) + l24);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l27 + l36) + l26);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l29 + 14L) + l28 + l34);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l33) + l32);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l18) + l17);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l20) + l19);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l22) + l21);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l24) + l23);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l26) + l25);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l28 + l34) + l27);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l30 + 15L) + l29 + l35);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l17) + l33);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l19) + l18);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l21) + l20);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l23) + l22);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l25) + l24);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l27) + l26);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l29 + l35) + l28);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l31 + 16L) + l30 + l36);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l18) + l17);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l20) + l19);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l22) + l21);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l24) + l23);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l26) + l25);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l28) + l27);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l30 + l36) + l29);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l32 + 17L) + l31 + l34);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            l2 = (l2 << 24 | l2 >>> 40) ^ (l += (l2 += l19) + l18);
            l4 = (l4 << 13 | l4 >>> 51) ^ (l3 += (l4 += l21) + l20);
            l6 = (l6 << 8 | l6 >>> 56) ^ (l5 += (l6 += l23) + l22);
            l8 = (l8 << 47 | l8 >>> 17) ^ (l7 += (l8 += l25) + l24);
            l10 = (l10 << 8 | l10 >>> 56) ^ (l9 += (l10 += l27) + l26);
            l12 = (l12 << 17 | l12 >>> 47) ^ (l11 += (l12 += l29) + l28);
            l14 = (l14 << 22 | l14 >>> 42) ^ (l13 += (l14 += l31 + l34) + l30);
            l16 = (l16 << 37 | l16 >>> 27) ^ (l15 += (l16 += l33 + 18L) + l32 + l35);
            l += l10;
            l10 = (l10 << 38 | l10 >>> 26) ^ l;
            l3 += l14;
            l14 = (l14 << 19 | l14 >>> 45) ^ l3;
            l7 += l12;
            l12 = (l12 << 10 | l12 >>> 54) ^ l7;
            l5 += l16;
            l16 = (l16 << 55 | l16 >>> 9) ^ l5;
            l11 += l8;
            l8 = (l8 << 49 | l8 >>> 15) ^ l11;
            l13 += l4;
            l4 = (l4 << 18 | l4 >>> 46) ^ l13;
            l15 += l6;
            l6 = (l6 << 23 | l6 >>> 41) ^ l15;
            l9 += l2;
            l2 = (l2 << 52 | l2 >>> 12) ^ l9;
            l += l8;
            l8 = (l8 << 33 | l8 >>> 31) ^ l;
            l3 += l6;
            l6 = (l6 << 4 | l6 >>> 60) ^ l3;
            l5 += l4;
            l4 = (l4 << 51 | l4 >>> 13) ^ l5;
            l7 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l7;
            l13 += l16;
            l16 = (l16 << 34 | l16 >>> 30) ^ l13;
            l15 += l14;
            l14 = (l14 << 41 | l14 >>> 23) ^ l15;
            l9 += l12;
            l12 = (l12 << 59 | l12 >>> 5) ^ l9;
            l11 += l10;
            l10 = (l10 << 17 | l10 >>> 47) ^ l11;
            l += l16;
            l16 = (l16 << 5 | l16 >>> 59) ^ l;
            l3 += l12;
            l12 = (l12 << 20 | l12 >>> 44) ^ l3;
            l7 += l14;
            l14 = (l14 << 48 | l14 >>> 16) ^ l7;
            l5 += l10;
            l10 = (l10 << 41 | l10 >>> 23) ^ l5;
            l15 += l2;
            l2 = (l2 << 47 | l2 >>> 17) ^ l15;
            l9 += l6;
            l6 = (l6 << 28 | l6 >>> 36) ^ l9;
            l11 += l4;
            l4 = (l4 << 16 | l4 >>> 48) ^ l11;
            l13 += l8;
            l8 = (l8 << 25 | l8 >>> 39) ^ l13;
            l2 = (l2 << 41 | l2 >>> 23) ^ (l += (l2 += l20) + l19);
            l4 = (l4 << 9 | l4 >>> 55) ^ (l3 += (l4 += l22) + l21);
            l6 = (l6 << 37 | l6 >>> 27) ^ (l5 += (l6 += l24) + l23);
            l8 = (l8 << 31 | l8 >>> 33) ^ (l7 += (l8 += l26) + l25);
            l10 = (l10 << 12 | l10 >>> 52) ^ (l9 += (l10 += l28) + l27);
            l12 = (l12 << 47 | l12 >>> 17) ^ (l11 += (l12 += l30) + l29);
            l14 = (l14 << 44 | l14 >>> 20) ^ (l13 += (l14 += l32 + l35) + l31);
            l16 = (l16 << 30 | l16 >>> 34) ^ (l15 += (l16 += l17 + 19L) + l33 + l36);
            l += l10;
            l10 = (l10 << 16 | l10 >>> 48) ^ l;
            l3 += l14;
            l14 = (l14 << 34 | l14 >>> 30) ^ l3;
            l7 += l12;
            l12 = (l12 << 56 | l12 >>> 8) ^ l7;
            l5 += l16;
            l16 = (l16 << 51 | l16 >>> 13) ^ l5;
            l11 += l8;
            l8 = (l8 << 4 | l8 >>> 60) ^ l11;
            l13 += l4;
            l4 = (l4 << 53 | l4 >>> 11) ^ l13;
            l15 += l6;
            l6 = (l6 << 42 | l6 >>> 22) ^ l15;
            l9 += l2;
            l2 = (l2 << 41 | l2 >>> 23) ^ l9;
            l += l8;
            l8 = (l8 << 31 | l8 >>> 33) ^ l;
            l3 += l6;
            l6 = (l6 << 44 | l6 >>> 20) ^ l3;
            l5 += l4;
            l4 = (l4 << 47 | l4 >>> 17) ^ l5;
            l7 += l2;
            l2 = (l2 << 46 | l2 >>> 18) ^ l7;
            l13 += l16;
            l16 = (l16 << 19 | l16 >>> 45) ^ l13;
            l15 += l14;
            l14 = (l14 << 42 | l14 >>> 22) ^ l15;
            l9 += l12;
            l12 = (l12 << 44 | l12 >>> 20) ^ l9;
            l11 += l10;
            l10 = (l10 << 25 | l10 >>> 39) ^ l11;
            l += l16;
            l16 = (l16 << 9 | l16 >>> 55) ^ l;
            l3 += l12;
            l12 = (l12 << 48 | l12 >>> 16) ^ l3;
            l7 += l14;
            l14 = (l14 << 35 | l14 >>> 29) ^ l7;
            l5 += l10;
            l10 = (l10 << 52 | l10 >>> 12) ^ l5;
            l15 += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l15;
            l9 += l6;
            l6 = (l6 << 31 | l6 >>> 33) ^ l9;
            l11 += l4;
            l4 = (l4 << 37 | l4 >>> 27) ^ l11;
            l13 += l8;
            l8 = (l8 << 20 | l8 >>> 44) ^ l13;
            lArray2[0] = l + l20;
            lArray2[1] = l2 + l21;
            lArray2[2] = l3 + l22;
            lArray2[3] = l4 + l23;
            lArray2[4] = l5 + l24;
            lArray2[5] = l6 + l25;
            lArray2[6] = l7 + l26;
            lArray2[7] = l8 + l27;
            lArray2[8] = l9 + l28;
            lArray2[9] = l10 + l29;
            lArray2[10] = l11 + l30;
            lArray2[11] = l12 + l31;
            lArray2[12] = l13 + l32;
            lArray2[13] = l14 + l33 + l36;
            lArray2[14] = l15 + l17 + l34;
            lArray2[15] = l16 + l18 + 20L;
        }

        public void decrypt(long[] lArray, long[] lArray2) {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            long l5 = lArray[4];
            long l6 = lArray[5];
            long l7 = lArray[6];
            long l8 = lArray[7];
            long l9 = lArray[8];
            long l10 = lArray[9];
            long l11 = lArray[10];
            long l12 = lArray[11];
            long l13 = lArray[12];
            long l14 = lArray[13];
            long l15 = lArray[14];
            long l16 = lArray[15];
            long l17 = this.expanedKey[0];
            long l18 = this.expanedKey[1];
            long l19 = this.expanedKey[2];
            long l20 = this.expanedKey[3];
            long l21 = this.expanedKey[4];
            long l22 = this.expanedKey[5];
            long l23 = this.expanedKey[6];
            long l24 = this.expanedKey[7];
            long l25 = this.expanedKey[8];
            long l26 = this.expanedKey[9];
            long l27 = this.expanedKey[10];
            long l28 = this.expanedKey[11];
            long l29 = this.expanedKey[12];
            long l30 = this.expanedKey[13];
            long l31 = this.expanedKey[14];
            long l32 = this.expanedKey[15];
            long l33 = this.expanedKey[16];
            long l34 = this.expanedTweak[0];
            long l35 = this.expanedTweak[1];
            long l36 = this.expanedTweak[2];
            l -= l20;
            l2 -= l21;
            l3 -= l22;
            l4 -= l23;
            l5 -= l24;
            l6 -= l25;
            l7 -= l26;
            l8 -= l27;
            l9 -= l28;
            l10 -= l29;
            l11 -= l30;
            l12 -= l31;
            l14 -= l33 + l36;
            l15 -= l17 + l34;
            l16 -= l18 + 20L;
            long l37 = l8 ^ (l13 -= l32);
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l33 + l36;
            l16 -= l17 + 19L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l31;
            l14 -= l32 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l29;
            l12 -= l30;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l27;
            l10 -= l28;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l25;
            l8 -= l26;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l23;
            l6 -= l24;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l21;
            l4 -= l22;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l19;
            l2 -= l20;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l32 + l35;
            l16 -= l33 + 18L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l30;
            l14 -= l31 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l28;
            l12 -= l29;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l26;
            l10 -= l27;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l24;
            l8 -= l25;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l22;
            l6 -= l23;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l20;
            l4 -= l21;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l18;
            l2 -= l19;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l31 + l34;
            l16 -= l32 + 17L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l29;
            l14 -= l30 + l36;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l27;
            l12 -= l28;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l25;
            l10 -= l26;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l23;
            l8 -= l24;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l21;
            l6 -= l22;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l19;
            l4 -= l20;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l17;
            l2 -= l18;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l30 + l36;
            l16 -= l31 + 16L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l28;
            l14 -= l29 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l26;
            l12 -= l27;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l24;
            l10 -= l25;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l22;
            l8 -= l23;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l20;
            l6 -= l21;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l18;
            l4 -= l19;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l33;
            l2 -= l17;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l29 + l35;
            l16 -= l30 + 15L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l27;
            l14 -= l28 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l25;
            l12 -= l26;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l23;
            l10 -= l24;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l21;
            l8 -= l22;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l19;
            l6 -= l20;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l17;
            l4 -= l18;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l32;
            l2 -= l33;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l28 + l34;
            l16 -= l29 + 14L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l26;
            l14 -= l27 + l36;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l24;
            l12 -= l25;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l22;
            l10 -= l23;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l20;
            l8 -= l21;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l18;
            l6 -= l19;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l33;
            l4 -= l17;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l31;
            l2 -= l32;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l27 + l36;
            l16 -= l28 + 13L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l25;
            l14 -= l26 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l23;
            l12 -= l24;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l21;
            l10 -= l22;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l19;
            l8 -= l20;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l17;
            l6 -= l18;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l32;
            l4 -= l33;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l30;
            l2 -= l31;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l26 + l35;
            l16 -= l27 + 12L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l24;
            l14 -= l25 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l22;
            l12 -= l23;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l20;
            l10 -= l21;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l18;
            l8 -= l19;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l33;
            l6 -= l17;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l31;
            l4 -= l32;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l29;
            l2 -= l30;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l25 + l34;
            l16 -= l26 + 11L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l23;
            l14 -= l24 + l36;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l21;
            l12 -= l22;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l19;
            l10 -= l20;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l17;
            l8 -= l18;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l32;
            l6 -= l33;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l30;
            l4 -= l31;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l28;
            l2 -= l29;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l24 + l36;
            l16 -= l25 + 10L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l22;
            l14 -= l23 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l20;
            l12 -= l21;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l18;
            l10 -= l19;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l33;
            l8 -= l17;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l31;
            l6 -= l32;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l29;
            l4 -= l30;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l27;
            l2 -= l28;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l23 + l35;
            l16 -= l24 + 9L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l21;
            l14 -= l22 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l19;
            l12 -= l20;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l17;
            l10 -= l18;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l32;
            l8 -= l33;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l30;
            l6 -= l31;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l28;
            l4 -= l29;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l26;
            l2 -= l27;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l22 + l34;
            l16 -= l23 + 8L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l20;
            l14 -= l21 + l36;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l18;
            l12 -= l19;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l33;
            l10 -= l17;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l31;
            l8 -= l32;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l29;
            l6 -= l30;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l27;
            l4 -= l28;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l25;
            l2 -= l26;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l21 + l36;
            l16 -= l22 + 7L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l19;
            l14 -= l20 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l17;
            l12 -= l18;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l32;
            l10 -= l33;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l30;
            l8 -= l31;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l28;
            l6 -= l29;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l26;
            l4 -= l27;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l24;
            l2 -= l25;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l20 + l35;
            l16 -= l21 + 6L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l18;
            l14 -= l19 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l33;
            l12 -= l17;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l31;
            l10 -= l32;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l29;
            l8 -= l30;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l27;
            l6 -= l28;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l25;
            l4 -= l26;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l23;
            l2 -= l24;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l19 + l34;
            l16 -= l20 + 5L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l17;
            l14 -= l18 + l36;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l32;
            l12 -= l33;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l30;
            l10 -= l31;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l28;
            l8 -= l29;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l26;
            l6 -= l27;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l24;
            l4 -= l25;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l22;
            l2 -= l23;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l18 + l36;
            l16 -= l19 + 4L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l33;
            l14 -= l17 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l31;
            l12 -= l32;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l29;
            l10 -= l30;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l27;
            l8 -= l28;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l25;
            l6 -= l26;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l23;
            l4 -= l24;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l21;
            l2 -= l22;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l17 + l35;
            l16 -= l18 + 3L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l32;
            l14 -= l33 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l30;
            l12 -= l31;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l28;
            l10 -= l29;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l26;
            l8 -= l27;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l24;
            l6 -= l25;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l22;
            l4 -= l23;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l20;
            l2 -= l21;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l33 + l34;
            l16 -= l17 + 2L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l31;
            l14 -= l32 + l36;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l29;
            l12 -= l30;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l27;
            l10 -= l28;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l25;
            l8 -= l26;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l23;
            l6 -= l24;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l21;
            l4 -= l22;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l19;
            l2 -= l20;
            l37 = l8 ^ l13;
            l8 = l37 >>> 20 | l37 << 44;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 37 | l37 << 27;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 31 | l37 << 33;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 23 | l37 << 41;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 52 | l37 << 12;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 35 | l37 << 29;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 48 | l37 << 16;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 9 | l37 << 55;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 25 | l37 << 39;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 44 | l37 << 20;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 42 | l37 << 22;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 19 | l37 << 45;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 46 | l37 << 18;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 47 | l37 << 17;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 44 | l37 << 20;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 31 | l37 << 33;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 41 | l37 << 23;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 42 | l37 << 22;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 53 | l37 << 11;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 4 | l37 << 60;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 51 | l37 << 13;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 56 | l37 << 8;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 34 | l37 << 30;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 16 | l37 << 48;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 30 | l37 << 34;
            l15 -= l16 + l32 + l36;
            l16 -= l33 + 1L;
            l37 = l14 ^ l13;
            l14 = l37 >>> 44 | l37 << 20;
            l13 -= l14 + l30;
            l14 -= l31 + l35;
            l37 = l12 ^ l11;
            l12 = l37 >>> 47 | l37 << 17;
            l11 -= l12 + l28;
            l12 -= l29;
            l37 = l10 ^ l9;
            l10 = l37 >>> 12 | l37 << 52;
            l9 -= l10 + l26;
            l10 -= l27;
            l37 = l8 ^ l7;
            l8 = l37 >>> 31 | l37 << 33;
            l7 -= l8 + l24;
            l8 -= l25;
            l37 = l6 ^ l5;
            l6 = l37 >>> 37 | l37 << 27;
            l5 -= l6 + l22;
            l6 -= l23;
            l37 = l4 ^ l3;
            l4 = l37 >>> 9 | l37 << 55;
            l3 -= l4 + l20;
            l4 -= l21;
            l37 = l2 ^ l;
            l2 = l37 >>> 41 | l37 << 23;
            l -= l2 + l18;
            l2 -= l19;
            l37 = l8 ^ l13;
            l8 = l37 >>> 25 | l37 << 39;
            l13 -= l8;
            l37 = l4 ^ l11;
            l4 = l37 >>> 16 | l37 << 48;
            l11 -= l4;
            l37 = l6 ^ l9;
            l6 = l37 >>> 28 | l37 << 36;
            l9 -= l6;
            l37 = l2 ^ l15;
            l2 = l37 >>> 47 | l37 << 17;
            l15 -= l2;
            l37 = l10 ^ l5;
            l10 = l37 >>> 41 | l37 << 23;
            l5 -= l10;
            l37 = l14 ^ l7;
            l14 = l37 >>> 48 | l37 << 16;
            l7 -= l14;
            l37 = l12 ^ l3;
            l12 = l37 >>> 20 | l37 << 44;
            l3 -= l12;
            l37 = l16 ^ l;
            l16 = l37 >>> 5 | l37 << 59;
            l -= l16;
            l37 = l10 ^ l11;
            l10 = l37 >>> 17 | l37 << 47;
            l11 -= l10;
            l37 = l12 ^ l9;
            l12 = l37 >>> 59 | l37 << 5;
            l9 -= l12;
            l37 = l14 ^ l15;
            l14 = l37 >>> 41 | l37 << 23;
            l15 -= l14;
            l37 = l16 ^ l13;
            l16 = l37 >>> 34 | l37 << 30;
            l13 -= l16;
            l37 = l2 ^ l7;
            l2 = l37 >>> 13 | l37 << 51;
            l7 -= l2;
            l37 = l4 ^ l5;
            l4 = l37 >>> 51 | l37 << 13;
            l5 -= l4;
            l37 = l6 ^ l3;
            l6 = l37 >>> 4 | l37 << 60;
            l3 -= l6;
            l37 = l8 ^ l;
            l8 = l37 >>> 33 | l37 << 31;
            l -= l8;
            l37 = l2 ^ l9;
            l2 = l37 >>> 52 | l37 << 12;
            l9 -= l2;
            l37 = l6 ^ l15;
            l6 = l37 >>> 23 | l37 << 41;
            l15 -= l6;
            l37 = l4 ^ l13;
            l4 = l37 >>> 18 | l37 << 46;
            l13 -= l4;
            l37 = l8 ^ l11;
            l8 = l37 >>> 49 | l37 << 15;
            l11 -= l8;
            l37 = l16 ^ l5;
            l16 = l37 >>> 55 | l37 << 9;
            l5 -= l16;
            l37 = l12 ^ l7;
            l12 = l37 >>> 10 | l37 << 54;
            l7 -= l12;
            l37 = l14 ^ l3;
            l14 = l37 >>> 19 | l37 << 45;
            l3 -= l14;
            l37 = l10 ^ l;
            l10 = l37 >>> 38 | l37 << 26;
            l -= l10;
            l37 = l16 ^ l15;
            l16 = l37 >>> 37 | l37 << 27;
            l15 -= l16 + l31 + l35;
            l16 -= l32;
            l37 = l14 ^ l13;
            l14 = l37 >>> 22 | l37 << 42;
            l13 -= l14 + l29;
            l14 -= l30 + l34;
            l37 = l12 ^ l11;
            l12 = l37 >>> 17 | l37 << 47;
            l11 -= l12 + l27;
            l12 -= l28;
            l37 = l10 ^ l9;
            l10 = l37 >>> 8 | l37 << 56;
            l9 -= l10 + l25;
            l10 -= l26;
            l37 = l8 ^ l7;
            l8 = l37 >>> 47 | l37 << 17;
            l7 -= l8 + l23;
            l8 -= l24;
            l37 = l6 ^ l5;
            l6 = l37 >>> 8 | l37 << 56;
            l5 -= l6 + l21;
            l6 -= l22;
            l37 = l4 ^ l3;
            l4 = l37 >>> 13 | l37 << 51;
            l3 -= l4 + l19;
            l4 -= l20;
            l37 = l2 ^ l;
            l2 = l37 >>> 24 | l37 << 40;
            l -= l2 + l17;
            l2 -= l18;
            lArray2[15] = l16;
            lArray2[14] = l15;
            lArray2[13] = l14;
            lArray2[12] = l13;
            lArray2[11] = l12;
            lArray2[10] = l11;
            lArray2[9] = l10;
            lArray2[8] = l9;
            lArray2[7] = l8;
            lArray2[6] = l7;
            lArray2[5] = l6;
            lArray2[4] = l5;
            lArray2[3] = l4;
            lArray2[2] = l3;
            lArray2[1] = l2;
            lArray2[0] = l;
        }
    }

    public class Threefish512
    extends ThreefishCipher {
        private final int CIPHER_SIZE = 512;
        private final int CIPHER_QWORDS = 8;
        private final int EXPANDED_KEY_SIZE = 9;

        public Threefish512() {
            this.expanedKey = new long[9];
            this.expanedKey[8] = 2004413935125273122L;
        }

        public void encrypt(long[] lArray, long[] lArray2) {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            long l5 = lArray[4];
            long l6 = lArray[5];
            long l7 = lArray[6];
            long l8 = lArray[7];
            long l9 = this.expanedKey[0];
            long l10 = this.expanedKey[1];
            long l11 = this.expanedKey[2];
            long l12 = this.expanedKey[3];
            long l13 = this.expanedKey[4];
            long l14 = this.expanedKey[5];
            long l15 = this.expanedKey[6];
            long l16 = this.expanedKey[7];
            long l17 = this.expanedKey[8];
            long l18 = this.expanedTweak[0];
            long l19 = this.expanedTweak[1];
            long l20 = this.expanedTweak[2];
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l10) + l9);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l12) + l11);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l14 + l18) + l13);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l16) + l15 + l19);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l11) + l10);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l13) + l12);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l15 + l19) + l14);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l17 + 1L) + l16 + l20);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l12) + l11);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l14) + l13);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l16 + l20) + l15);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l9 + 2L) + l17 + l18);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l13) + l12);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l15) + l14);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l17 + l18) + l16);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l10 + 3L) + l9 + l19);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l14) + l13);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l16) + l15);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l9 + l19) + l17);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l11 + 4L) + l10 + l20);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l15) + l14);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l17) + l16);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l10 + l20) + l9);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l12 + 5L) + l11 + l18);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l16) + l15);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l9) + l17);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l11 + l18) + l10);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l13 + 6L) + l12 + l19);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l17) + l16);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l10) + l9);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l12 + l19) + l11);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l14 + 7L) + l13 + l20);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l9) + l17);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l11) + l10);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l13 + l20) + l12);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l15 + 8L) + l14 + l18);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l10) + l9);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l12) + l11);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l14 + l18) + l13);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l16 + 9L) + l15 + l19);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l11) + l10);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l13) + l12);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l15 + l19) + l14);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l17 + 10L) + l16 + l20);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l12) + l11);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l14) + l13);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l16 + l20) + l15);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l9 + 11L) + l17 + l18);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l13) + l12);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l15) + l14);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l17 + l18) + l16);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l10 + 12L) + l9 + l19);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l14) + l13);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l16) + l15);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l9 + l19) + l17);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l11 + 13L) + l10 + l20);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l15) + l14);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l17) + l16);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l10 + l20) + l9);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l12 + 14L) + l11 + l18);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l16) + l15);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l9) + l17);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l11 + l18) + l10);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l13 + 15L) + l12 + l19);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            l2 = (l2 << 46 | l2 >>> 18) ^ (l += (l2 += l17) + l16);
            l4 = (l4 << 36 | l4 >>> 28) ^ (l3 += (l4 += l10) + l9);
            l6 = (l6 << 19 | l6 >>> 45) ^ (l5 += (l6 += l12 + l19) + l11);
            l8 = (l8 << 37 | l8 >>> 27) ^ (l7 += (l8 += l14 + 16L) + l13 + l20);
            l3 += l2;
            l2 = (l2 << 33 | l2 >>> 31) ^ l3;
            l5 += l8;
            l8 = (l8 << 27 | l8 >>> 37) ^ l5;
            l7 += l6;
            l6 = (l6 << 14 | l6 >>> 50) ^ l7;
            l += l4;
            l4 = (l4 << 42 | l4 >>> 22) ^ l;
            l5 += l2;
            l2 = (l2 << 17 | l2 >>> 47) ^ l5;
            l7 += l4;
            l4 = (l4 << 49 | l4 >>> 15) ^ l7;
            l += l6;
            l6 = (l6 << 36 | l6 >>> 28) ^ l;
            l3 += l8;
            l8 = (l8 << 39 | l8 >>> 25) ^ l3;
            l7 += l2;
            l2 = (l2 << 44 | l2 >>> 20) ^ l7;
            l += l8;
            l8 = (l8 << 9 | l8 >>> 55) ^ l;
            l3 += l6;
            l6 = (l6 << 54 | l6 >>> 10) ^ l3;
            l5 += l4;
            l4 = (l4 << 56 | l4 >>> 8) ^ l5;
            l2 = (l2 << 39 | l2 >>> 25) ^ (l += (l2 += l9) + l17);
            l4 = (l4 << 30 | l4 >>> 34) ^ (l3 += (l4 += l11) + l10);
            l6 = (l6 << 34 | l6 >>> 30) ^ (l5 += (l6 += l13 + l20) + l12);
            l8 = (l8 << 24 | l8 >>> 40) ^ (l7 += (l8 += l15 + 17L) + l14 + l18);
            l3 += l2;
            l2 = (l2 << 13 | l2 >>> 51) ^ l3;
            l5 += l8;
            l8 = (l8 << 50 | l8 >>> 14) ^ l5;
            l7 += l6;
            l6 = (l6 << 10 | l6 >>> 54) ^ l7;
            l += l4;
            l4 = (l4 << 17 | l4 >>> 47) ^ l;
            l5 += l2;
            l2 = (l2 << 25 | l2 >>> 39) ^ l5;
            l7 += l4;
            l4 = (l4 << 29 | l4 >>> 35) ^ l7;
            l += l6;
            l6 = (l6 << 39 | l6 >>> 25) ^ l;
            l3 += l8;
            l8 = (l8 << 43 | l8 >>> 21) ^ l3;
            l7 += l2;
            l2 = (l2 << 8 | l2 >>> 56) ^ l7;
            l += l8;
            l8 = (l8 << 35 | l8 >>> 29) ^ l;
            l3 += l6;
            l6 = (l6 << 56 | l6 >>> 8) ^ l3;
            l5 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l5;
            lArray2[0] = l + l9;
            lArray2[1] = l2 + l10;
            lArray2[2] = l3 + l11;
            lArray2[3] = l4 + l12;
            lArray2[4] = l5 + l13;
            lArray2[5] = l6 + l14 + l18;
            lArray2[6] = l7 + l15 + l19;
            lArray2[7] = l8 + l16 + 18L;
        }

        public void decrypt(long[] lArray, long[] lArray2) {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            long l5 = lArray[4];
            long l6 = lArray[5];
            long l7 = lArray[6];
            long l8 = lArray[7];
            long l9 = this.expanedKey[0];
            long l10 = this.expanedKey[1];
            long l11 = this.expanedKey[2];
            long l12 = this.expanedKey[3];
            long l13 = this.expanedKey[4];
            long l14 = this.expanedKey[5];
            long l15 = this.expanedKey[6];
            long l16 = this.expanedKey[7];
            long l17 = this.expanedKey[8];
            long l18 = this.expanedTweak[0];
            long l19 = this.expanedTweak[1];
            long l20 = this.expanedTweak[2];
            l -= l9;
            l2 -= l10;
            l3 -= l11;
            l6 -= l14 + l18;
            l7 -= l15 + l19;
            l8 -= l16 + 18L;
            long l21 = (l4 -= l12) ^ (l5 -= l13);
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l14 + l18;
            l8 -= l15 + 17L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l12;
            l6 -= l13 + l20;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l10;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l17;
            l2 -= l9;
            l21 = (l4 -= l11) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l13 + l20;
            l8 -= l14 + 16L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l11;
            l6 -= l12 + l19;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l9;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l16;
            l2 -= l17;
            l21 = (l4 -= l10) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l12 + l19;
            l8 -= l13 + 15L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l10;
            l6 -= l11 + l18;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l17;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l15;
            l2 -= l16;
            l21 = (l4 -= l9) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l11 + l18;
            l8 -= l12 + 14L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l9;
            l6 -= l10 + l20;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l16;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l14;
            l2 -= l15;
            l21 = (l4 -= l17) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l10 + l20;
            l8 -= l11 + 13L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l17;
            l6 -= l9 + l19;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l15;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l13;
            l2 -= l14;
            l21 = (l4 -= l16) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l9 + l19;
            l8 -= l10 + 12L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l16;
            l6 -= l17 + l18;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l14;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l12;
            l2 -= l13;
            l21 = (l4 -= l15) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l17 + l18;
            l8 -= l9 + 11L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l15;
            l6 -= l16 + l20;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l13;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l11;
            l2 -= l12;
            l21 = (l4 -= l14) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l16 + l20;
            l8 -= l17 + 10L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l14;
            l6 -= l15 + l19;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l12;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l10;
            l2 -= l11;
            l21 = (l4 -= l13) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l15 + l19;
            l8 -= l16 + 9L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l13;
            l6 -= l14 + l18;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l11;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l9;
            l2 -= l10;
            l21 = (l4 -= l12) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l14 + l18;
            l8 -= l15 + 8L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l12;
            l6 -= l13 + l20;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l10;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l17;
            l2 -= l9;
            l21 = (l4 -= l11) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l13 + l20;
            l8 -= l14 + 7L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l11;
            l6 -= l12 + l19;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l9;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l16;
            l2 -= l17;
            l21 = (l4 -= l10) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l12 + l19;
            l8 -= l13 + 6L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l10;
            l6 -= l11 + l18;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l17;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l15;
            l2 -= l16;
            l21 = (l4 -= l9) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l11 + l18;
            l8 -= l12 + 5L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l9;
            l6 -= l10 + l20;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l16;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l14;
            l2 -= l15;
            l21 = (l4 -= l17) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l10 + l20;
            l8 -= l11 + 4L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l17;
            l6 -= l9 + l19;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l15;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l13;
            l2 -= l14;
            l21 = (l4 -= l16) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l9 + l19;
            l8 -= l10 + 3L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l16;
            l6 -= l17 + l18;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l14;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l12;
            l2 -= l13;
            l21 = (l4 -= l15) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l17 + l18;
            l8 -= l9 + 2L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l15;
            l6 -= l16 + l20;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l13;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l11;
            l2 -= l12;
            l21 = (l4 -= l14) ^ l5;
            l4 = l21 >>> 22 | l21 << 42;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 56 | l21 << 8;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 35 | l21 << 29;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 8 | l21 << 56;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 43 | l21 << 21;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 39 | l21 << 25;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 29 | l21 << 35;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 25 | l21 << 39;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 17 | l21 << 47;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 10 | l21 << 54;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 50 | l21 << 14;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 13 | l21 << 51;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 24 | l21 << 40;
            l7 -= l8 + l16 + l20;
            l8 -= l17 + 1L;
            l21 = l6 ^ l5;
            l6 = l21 >>> 34 | l21 << 30;
            l5 -= l6 + l14;
            l6 -= l15 + l19;
            l21 = l4 ^ l3;
            l4 = l21 >>> 30 | l21 << 34;
            l3 -= l4 + l12;
            l21 = l2 ^ l;
            l2 = l21 >>> 39 | l21 << 25;
            l -= l2 + l10;
            l2 -= l11;
            l21 = (l4 -= l13) ^ l5;
            l4 = l21 >>> 56 | l21 << 8;
            l5 -= l4;
            l21 = l6 ^ l3;
            l6 = l21 >>> 54 | l21 << 10;
            l3 -= l6;
            l21 = l8 ^ l;
            l8 = l21 >>> 9 | l21 << 55;
            l -= l8;
            l21 = l2 ^ l7;
            l2 = l21 >>> 44 | l21 << 20;
            l7 -= l2;
            l21 = l8 ^ l3;
            l8 = l21 >>> 39 | l21 << 25;
            l3 -= l8;
            l21 = l6 ^ l;
            l6 = l21 >>> 36 | l21 << 28;
            l -= l6;
            l21 = l4 ^ l7;
            l4 = l21 >>> 49 | l21 << 15;
            l7 -= l4;
            l21 = l2 ^ l5;
            l2 = l21 >>> 17 | l21 << 47;
            l5 -= l2;
            l21 = l4 ^ l;
            l4 = l21 >>> 42 | l21 << 22;
            l -= l4;
            l21 = l6 ^ l7;
            l6 = l21 >>> 14 | l21 << 50;
            l7 -= l6;
            l21 = l8 ^ l5;
            l8 = l21 >>> 27 | l21 << 37;
            l5 -= l8;
            l21 = l2 ^ l3;
            l2 = l21 >>> 33 | l21 << 31;
            l3 -= l2;
            l21 = l8 ^ l7;
            l8 = l21 >>> 37 | l21 << 27;
            l7 -= l8 + l15 + l19;
            l8 -= l16;
            l21 = l6 ^ l5;
            l6 = l21 >>> 19 | l21 << 45;
            l5 -= l6 + l13;
            l6 -= l14 + l18;
            l21 = l4 ^ l3;
            l4 = l21 >>> 36 | l21 << 28;
            l3 -= l4 + l11;
            l4 -= l12;
            l21 = l2 ^ l;
            l2 = l21 >>> 46 | l21 << 18;
            l -= l2 + l9;
            l2 -= l10;
            lArray2[7] = l8;
            lArray2[6] = l7;
            lArray2[5] = l6;
            lArray2[4] = l5;
            lArray2[3] = l4;
            lArray2[2] = l3;
            lArray2[1] = l2;
            lArray2[0] = l;
        }
    }

    public class Threefish256
    extends ThreefishCipher {
        final int CIPHER_SIZE = 256;
        final int CIPHER_QWORDS = 4;
        final int EXPANDED_KEY_SIZE = 5;

        public Threefish256() {
            this.expanedKey = new long[5];
            this.expanedKey[4] = 2004413935125273122L;
        }

        public void encrypt(long[] lArray, long[] lArray2) {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            long l5 = this.expanedKey[0];
            long l6 = this.expanedKey[1];
            long l7 = this.expanedKey[2];
            long l8 = this.expanedKey[3];
            long l9 = this.expanedKey[4];
            long l10 = this.expanedTweak[0];
            long l11 = this.expanedTweak[1];
            long l12 = this.expanedTweak[2];
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l6 + l10) + l5);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l8) + l7 + l11);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l7 + l11) + l6);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l9 + 1L) + l8 + l12);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l8 + l12) + l7);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l5 + 2L) + l9 + l10);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l9 + l10) + l8);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l6 + 3L) + l5 + l11);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l5 + l11) + l9);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l7 + 4L) + l6 + l12);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l6 + l12) + l5);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l8 + 5L) + l7 + l10);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l7 + l10) + l6);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l9 + 6L) + l8 + l11);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l8 + l11) + l7);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l5 + 7L) + l9 + l12);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l9 + l12) + l8);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l6 + 8L) + l5 + l10);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l5 + l10) + l9);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l7 + 9L) + l6 + l11);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l6 + l11) + l5);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l8 + 10L) + l7 + l12);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l7 + l12) + l6);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l9 + 11L) + l8 + l10);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l8 + l10) + l7);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l5 + 12L) + l9 + l11);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l9 + l11) + l8);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l6 + 13L) + l5 + l12);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l5 + l12) + l9);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l7 + 14L) + l6 + l10);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l6 + l10) + l5);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l8 + 15L) + l7 + l11);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            l2 = (l2 << 14 | l2 >>> 50) ^ (l += (l2 += l7 + l11) + l6);
            l4 = (l4 << 16 | l4 >>> 48) ^ (l3 += (l4 += l9 + 16L) + l8 + l12);
            l += l4;
            l4 = (l4 << 52 | l4 >>> 12) ^ l;
            l3 += l2;
            l2 = (l2 << 57 | l2 >>> 7) ^ l3;
            l += l2;
            l2 = (l2 << 23 | l2 >>> 41) ^ l;
            l3 += l4;
            l4 = (l4 << 40 | l4 >>> 24) ^ l3;
            l += l4;
            l4 = (l4 << 5 | l4 >>> 59) ^ l;
            l3 += l2;
            l2 = (l2 << 37 | l2 >>> 27) ^ l3;
            l2 = (l2 << 25 | l2 >>> 39) ^ (l += (l2 += l8 + l12) + l7);
            l4 = (l4 << 33 | l4 >>> 31) ^ (l3 += (l4 += l5 + 17L) + l9 + l10);
            l += l4;
            l4 = (l4 << 46 | l4 >>> 18) ^ l;
            l3 += l2;
            l2 = (l2 << 12 | l2 >>> 52) ^ l3;
            l += l2;
            l2 = (l2 << 58 | l2 >>> 6) ^ l;
            l3 += l4;
            l4 = (l4 << 22 | l4 >>> 42) ^ l3;
            l += l4;
            l4 = (l4 << 32 | l4 >>> 32) ^ l;
            l3 += l2;
            l2 = (l2 << 32 | l2 >>> 32) ^ l3;
            lArray2[0] = l + l8;
            lArray2[1] = l2 + l9 + l10;
            lArray2[2] = l3 + l5 + l11;
            lArray2[3] = l4 + l6 + 18L;
        }

        public void decrypt(long[] lArray, long[] lArray2) {
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            long l5 = this.expanedKey[0];
            long l6 = this.expanedKey[1];
            long l7 = this.expanedKey[2];
            long l8 = this.expanedKey[3];
            long l9 = this.expanedKey[4];
            long l10 = this.expanedTweak[0];
            long l11 = this.expanedTweak[1];
            long l12 = this.expanedTweak[2];
            long l13 = (l4 -= l6 + 18L) ^ (l -= l8);
            l4 = l13 >>> 32 | l13 << 32;
            l13 = (l2 -= l9 + l10) ^ (l3 -= l5 + l11);
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l7;
            l2 -= l8 + l12;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l9 + l10;
            l13 = (l4 -= l5 + 17L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l6;
            l2 -= l7 + l11;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l8 + l12;
            l13 = (l4 -= l9 + 16L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l5;
            l2 -= l6 + l10;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l7 + l11;
            l13 = (l4 -= l8 + 15L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l9;
            l2 -= l5 + l12;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l6 + l10;
            l13 = (l4 -= l7 + 14L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l8;
            l2 -= l9 + l11;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l5 + l12;
            l13 = (l4 -= l6 + 13L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l7;
            l2 -= l8 + l10;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l9 + l11;
            l13 = (l4 -= l5 + 12L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l6;
            l2 -= l7 + l12;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l8 + l10;
            l13 = (l4 -= l9 + 11L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l5;
            l2 -= l6 + l11;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l7 + l12;
            l13 = (l4 -= l8 + 10L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l9;
            l2 -= l5 + l10;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l6 + l11;
            l13 = (l4 -= l7 + 9L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l8;
            l2 -= l9 + l12;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l5 + l10;
            l13 = (l4 -= l6 + 8L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l7;
            l2 -= l8 + l11;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l9 + l12;
            l13 = (l4 -= l5 + 7L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l6;
            l2 -= l7 + l10;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l8 + l11;
            l13 = (l4 -= l9 + 6L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l5;
            l2 -= l6 + l12;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l7 + l10;
            l13 = (l4 -= l8 + 5L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l9;
            l2 -= l5 + l11;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l6 + l12;
            l13 = (l4 -= l7 + 4L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l8;
            l2 -= l9 + l10;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l5 + l11;
            l13 = (l4 -= l6 + 3L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l7;
            l2 -= l8 + l12;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l9 + l10;
            l13 = (l4 -= l5 + 2L) ^ l;
            l4 = l13 >>> 32 | l13 << 32;
            l13 = l2 ^ l3;
            l2 = l13 >>> 32 | l13 << 32;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 58 | l13 << 6;
            l13 = l4 ^ l3;
            l4 = l13 >>> 22 | l13 << 42;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 46 | l13 << 18;
            l13 = l2 ^ l3;
            l2 = l13 >>> 12 | l13 << 52;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 25 | l13 << 39;
            l -= l2 + l6;
            l2 -= l7 + l11;
            l13 = l4 ^ l3;
            l4 = l13 >>> 33 | l13 << 31;
            l3 -= l4 + l8 + l12;
            l13 = (l4 -= l9 + 1L) ^ l;
            l4 = l13 >>> 5 | l13 << 59;
            l13 = l2 ^ l3;
            l2 = l13 >>> 37 | l13 << 27;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 23 | l13 << 41;
            l13 = l4 ^ l3;
            l4 = l13 >>> 40 | l13 << 24;
            l3 -= l4;
            l13 = l4 ^ (l -= l2);
            l4 = l13 >>> 52 | l13 << 12;
            l13 = l2 ^ l3;
            l2 = l13 >>> 57 | l13 << 7;
            l3 -= l2;
            l13 = l2 ^ (l -= l4);
            l2 = l13 >>> 14 | l13 << 50;
            l -= l2 + l5;
            l13 = l4 ^ l3;
            l4 = l13 >>> 16 | l13 << 48;
            l3 -= l4 + l7 + l11;
            lArray2[0] = l;
            lArray2[1] = l2 -= l6 + l10;
            lArray2[2] = l3;
            lArray2[3] = l4 -= l8;
        }
    }
}

