/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.prng;

import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.prng.RandomGenerator;

public class FortunaGenerator
implements RandomGenerator {
    private static final int SEED_FILE_SIZE = 64;
    private static final int NUM_POOLS = 32;
    private static final int MIN_POOL_SIZE = 64;
    private final Generator generator = new Generator(new AESFastEngine(), new SHA256Digest());
    private final Digest[] pools = new Digest[32];
    private long lastReseed = 0L;
    private int pool = 0;
    private int pool0Count = 0;
    private int reseedCount = 0;
    private boolean initialized = false;
    private byte[] buffer;
    protected int ndx = 0;

    public FortunaGenerator() {
        this(null);
    }

    public FortunaGenerator(byte[] byArray) {
        for (int i = 0; i < 32; ++i) {
            this.pools[i] = new SHA256Digest();
        }
        this.buffer = new byte[256];
        if (byArray != null) {
            this.generator.init(byArray);
            this.fillBlock();
            this.initialized = true;
        }
    }

    private void fillBlock() {
        if (this.pool0Count >= 64 && System.currentTimeMillis() - this.lastReseed > 100L) {
            long l = 1L;
            ++this.reseedCount;
            byte[] byArray = new byte[this.pools[0].getDigestSize()];
            for (int i = 0; i < 32 && (i == 0 || (long)this.reseedCount % l == 0L); ++i) {
                this.pools[i].doFinal(byArray, 0);
                this.generator.addRandomBytes(byArray, 0, byArray.length);
                l <<= 1;
            }
            this.lastReseed = System.currentTimeMillis();
            this.pool0Count = 0;
        }
        this.generator.nextBytes(this.buffer, 0, this.buffer.length);
    }

    public void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray, int n, int n2) {
        if (!this.initialized) {
            throw new IllegalStateException(" Fortuna generator not initialized/seeded");
        }
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("offset=" + n + " length=" + n2 + " limit=" + byArray.length);
        }
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Math.min(this.buffer.length - this.ndx, n2 - n3);
            System.arraycopy(this.buffer, this.ndx, byArray, n + n3, n4);
            n3 += n4;
            this.ndx += n4;
            if (this.ndx < this.buffer.length) continue;
            this.fillBlock();
            this.ndx = 0;
        }
    }

    public void addSeedMaterial(long l) {
        this.pools[this.pool].update((byte)(l & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 8 & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 16 & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 24 & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 32 & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 40 & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 48 & 0xFFL));
        this.pools[this.pool].update((byte)(l >> 56 & 0xFFL));
        if (this.pool == 0) {
            this.pool0Count += 8;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addSeedMaterial(byte[] byArray) {
        this.addSeedMaterial(byArray, 0, byArray.length);
    }

    public void addSeedMaterial(byte[] byArray, int n, int n2) {
        this.pools[this.pool].update(byArray, n, n2);
        if (this.pool == 0) {
            this.pool0Count += byArray.length;
        }
        this.pool = (this.pool + 1) % 32;
    }

    public void addSeedMaterial(int n, byte[] byArray, int n2, int n3) {
        if (n < 0 || n >= this.pools.length) {
            throw new IllegalArgumentException("pool number out of range: " + n);
        }
        this.pools[n].update((byte)n3);
        this.pools[n].update(byArray, n2, n3);
        if (n == 0) {
            this.pool0Count += n3;
        }
    }

    public byte[] getSeedStatus() {
        byte[] byArray = new byte[64];
        this.generator.nextBytes(byArray, 0, byArray.length);
        return byArray;
    }

    public void setSeedStatus(byte[] byArray) {
        this.generator.init(byArray);
        this.fillBlock();
        this.initialized = true;
    }

    private static class Generator {
        private static final int LIMIT = 0x100000;
        private final BlockCipher cipher;
        private final Digest hash;
        private final byte[] counter;
        private final byte[] key;
        private byte[] buffer;
        protected int ndx = 0;

        private Generator(BlockCipher blockCipher, Digest digest) {
            this.cipher = blockCipher;
            this.hash = digest;
            this.counter = new byte[blockCipher.getBlockSize()];
            this.buffer = new byte[blockCipher.getBlockSize()];
            this.key = new byte[32];
        }

        private void nextBytes(byte[] byArray, int n, int n2) {
            int n3 = 0;
            do {
                int n4 = Math.min(0x100000, n2 - n3);
                this.nextBytesInternal(byArray, n + n3, n4);
                n3 += n4;
                for (int i = 0; i < this.key.length; i += this.counter.length) {
                    this.fillBlock();
                    int n5 = Math.min(this.key.length - i, this.cipher.getBlockSize());
                    System.arraycopy(this.buffer, 0, this.key, i, n5);
                }
                this.resetKey();
            } while (n3 < n2);
            this.fillBlock();
            this.ndx = 0;
        }

        private void addRandomBytes(byte[] byArray, int n, int n2) {
            this.hash.update(this.key, 0, this.key.length);
            this.hash.update(byArray, n, n2);
            byte[] byArray2 = new byte[this.hash.getDigestSize()];
            this.hash.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, this.key, 0, Math.min(this.key.length, byArray2.length));
            this.resetKey();
            this.incrementCounter();
        }

        private void fillBlock() {
            this.cipher.processBlock(this.counter, 0, this.buffer, 0);
            this.incrementCounter();
        }

        private void init(byte[] byArray) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.counter, (byte)0);
            if (byArray != null) {
                this.addRandomBytes(byArray, 0, byArray.length);
            }
            this.fillBlock();
        }

        private void nextBytesInternal(byte[] byArray, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException("offset=" + n + " length=" + n2 + " limit=" + byArray.length);
            }
            if (this.ndx >= this.buffer.length) {
                this.fillBlock();
                this.ndx = 0;
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = Math.min(this.buffer.length - this.ndx, n2 - n3);
                System.arraycopy(this.buffer, this.ndx, byArray, n + n3, n4);
                n3 += n4;
                this.ndx += n4;
                if (this.ndx < this.buffer.length) continue;
                this.fillBlock();
                this.ndx = 0;
            }
        }

        private void resetKey() {
            this.cipher.reset();
            this.cipher.init(true, new KeyParameter(this.key));
        }

        private void incrementCounter() {
            for (int i = 0; i < this.counter.length; ++i) {
                int n = i;
                this.counter[n] = (byte)(this.counter[n] + 1);
                if (this.counter[i] != 0) break;
            }
        }
    }
}

