/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import net.sf.profiler4j.console.client.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassListTableModel
extends AbstractTableModel {
    private String pattern;
    private boolean onlyInstrumented;
    private List<Row> rows = new ArrayList<Row>();
    private List<Row> visibleRows = new ArrayList<Row>();

    public ClassListTableModel() {
        this.setFilters("**", false);
    }

    public void setFilters(String s, boolean onlyInstrumented) {
        this.pattern = s.trim();
        this.onlyInstrumented = onlyInstrumented;
    }

    public void setClasses(ClassInfo[] classes) {
        this.rows.clear();
        for (ClassInfo c : classes) {
            Row r = new Row();
            r.info = c;
            r.visible = true;
            this.rows.add(r);
        }
        this.refresh();
    }

    public List<Row> getRows(boolean onlyVisible) {
        if (onlyVisible) {
            return Collections.unmodifiableList(this.visibleRows);
        }
        return Collections.unmodifiableList(this.rows);
    }

    public Row getRow(int r) {
        return this.visibleRows.get(r);
    }

    @Override
    public Class<?> getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getRowCount() {
        return this.visibleRows == null ? 0 : this.visibleRows.size();
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return "Inst?";
            }
            case 1: {
                return "Class";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int r, int c) {
        Row row = this.visibleRows.get(r);
        switch (c) {
            case 0: {
                return row.info.isInstrumented();
            }
            case 1: {
                return row.info.getName();
            }
        }
        throw new IllegalArgumentException();
    }

    private void refresh() {
        this.visibleRows.clear();
        for (Row r : this.rows) {
            if (r.info.getName().startsWith(this.pattern)) {
                if (this.onlyInstrumented && !r.info.isInstrumented()) continue;
                r.visible = true;
                this.visibleRows.add(r);
                continue;
            }
            r.visible = false;
        }
        Collections.sort(this.visibleRows);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.rows.clear();
        this.visibleRows.clear();
        this.fireTableDataChanged();
    }

    public static class Row
    implements Comparable {
        ClassInfo info;
        boolean visible;

        public String getName() {
            return this.info.getName();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public int compareTo(Object o) {
            return this.info.getName().compareTo(((Row)o).info.getName());
        }
    }
}

