/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.sf.profiler4j.console.util.ValidationError;

public class Validator {
    private Component parent;
    private List<Rule> validations = new ArrayList<Rule>();
    private Map<JComponent, ValidationError> errors = new LinkedHashMap<JComponent, ValidationError>();
    private Map<JComponent, Color> restoreColors = new LinkedHashMap<JComponent, Color>();
    private Map<JComponent, String> restoreTooltips = new LinkedHashMap<JComponent, String>();
    private MouseListener ml = new MouseAdapter(){
        Color old = null;
        int initialDelay;

        public void mouseEntered(MouseEvent e) {
            JComponent c = (JComponent)e.getComponent();
            if (Validator.this.errors.containsKey(c)) {
                this.old = UIManager.getColor("ToolTip.background");
                this.initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
                UIManager.put("ToolTip.background", Color.YELLOW);
                ToolTipManager.sharedInstance().setInitialDelay(10);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.old != null) {
                UIManager.put("ToolTip.background", this.old);
                this.old = null;
                ToolTipManager.sharedInstance().setInitialDelay(this.initialDelay);
            }
        }
    };

    public Validator(Component parent) {
        this.parent = parent;
    }

    public boolean validate(boolean focusFirstError) {
        this.restore();
        this.errors.clear();
        for (Rule rule : this.validations) {
            rule.validate();
        }
        if (this.errors.isEmpty()) {
            return true;
        }
        for (ValidationError ve : this.errors.values()) {
            this.hightlight(ve.getComponent(), ve.getReason());
        }
        if (focusFirstError && !this.errors.isEmpty()) {
            this.errors.keySet().iterator().next().requestFocus();
        }
        return false;
    }

    private void hightlight(JComponent c, String s) {
        if (!this.restoreColors.containsKey(c)) {
            this.restoreColors.put(c, c.getBackground());
            c.setBackground(Color.decode("#ffaaaa"));
            this.restoreTooltips.put(c, c.getToolTipText());
            c.setToolTipText(s);
            c.addMouseListener(this.ml);
        }
    }

    private void restore() {
        for (JComponent c : this.restoreColors.keySet()) {
            c.setBackground(this.restoreColors.get(c));
            c.setToolTipText(this.restoreTooltips.get(c));
            c.removeMouseListener(this.ml);
        }
        this.restoreColors.clear();
        this.restoreTooltips.clear();
    }

    private void saveError(JComponent c, String message) {
        if (!this.errors.containsKey(c)) {
            this.errors.put(c, new ValidationError(c, message));
        }
    }

    private static String norm(String s) {
        return s == null ? "" : s;
    }

    public void newNonEmpty(final JTextComponent c) {
        this.validations.add(new Rule(){

            public void validate() {
                if (Validator.isEmpty(c.getText())) {
                    Validator.this.saveError(c, "Value cannot be empty");
                }
            }
        });
    }

    public void newNonEmpty(final JComboBox c) {
        this.validations.add(new Rule(){

            public void validate() {
                if (c.getSelectedIndex() == -1) {
                    Validator.this.saveError(c, "Value cannot be empty");
                }
            }
        });
    }

    public void newInteger(final JTextComponent c, final int min, final int max) {
        this.validations.add(new Rule(){

            public void validate() {
                String s = c.getText();
                if (Validator.isEmpty(s)) {
                    return;
                }
                try {
                    int v = Integer.parseInt(s);
                    if (v < min || v > max) {
                        Validator.this.saveError(c, "Value must in the range [" + min + ";" + max + "]");
                    }
                }
                catch (NumberFormatException nfe) {
                    Validator.this.saveError(c, "Value must be a valid integer");
                }
            }
        });
    }

    public void newEmail(final JTextComponent c) {
        this.validations.add(new Rule(){

            public void validate() {
                String s = c.getText();
                if (Validator.isEmpty(s)) {
                    return;
                }
                if (!Pattern.matches("^[a-zA-Z0-9\\+\\.\\_\\-]+@[a-zA-Z0-9\\.\\-\\_]+$", s)) {
                    Validator.this.saveError(c, "Value must be an e-mail");
                }
            }
        });
    }

    public void newSameText(final JTextComponent c1, final JTextComponent c2) {
        this.validations.add(new Rule(){

            public void validate() {
                String s2;
                String s1 = Validator.norm(c1.getText());
                if (!s1.equals(s2 = Validator.norm(c2.getText()))) {
                    Validator.this.saveError(c2, "Value must be the same as before");
                }
            }
        });
    }

    public void newId(final JTextComponent c) {
        this.validations.add(new Rule(){

            public void validate() {
                String s = c.getText();
                if (Validator.isEmpty(s)) {
                    return;
                }
                if (!Pattern.matches("^[a-zA-Z0-9\\_]+[a-zA-Z0-9\\_]*$", s)) {
                    Validator.this.saveError(c, "Value must be an identifier");
                }
            }
        });
    }

    public void newLengthRange(final JTextComponent c, final int minLengh, final int maxLengh) {
        this.validations.add(new Rule(){

            public void validate() {
                String s = c.getText();
                if (Validator.isEmpty(s)) {
                    return;
                }
                if (s.length() < minLengh || s.length() > maxLengh) {
                    Validator.this.saveError(c, "Text length is out of range (min=" + minLengh + "; max=" + maxLengh + ")");
                }
            }
        });
    }

    public void newRegex(final JTextComponent c, final String regex) {
        this.validations.add(new Rule(){

            public void validate() {
                String s = c.getText();
                if (Validator.isEmpty(s)) {
                    return;
                }
                if (!Pattern.matches(regex, s)) {
                    Validator.this.saveError(c, "Value is not valid: " + regex);
                }
            }
        });
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    static interface Rule {
        public void validate();
    }
}

