/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j;

import java.security.PublicKey;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.otr4j.OtrEngine;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrException;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;
import net.java.otr4j.session.SessionImpl;
import net.java.otr4j.session.SessionStatus;

public class OtrEngineImpl
implements OtrEngine {
    private OtrEngineHost host;
    private Map<SessionID, Session> sessions;
    private List<OtrEngineListener> listeners = new Vector<OtrEngineListener>();

    public OtrEngineImpl(OtrEngineHost host) {
        if (host == null) {
            throw new IllegalArgumentException("OtrEgineHost is required.");
        }
        this.setHost(host);
    }

    private Session getSession(SessionID sessionID) {
        if (sessionID == null || sessionID.equals(SessionID.Empty)) {
            throw new IllegalArgumentException();
        }
        if (this.sessions == null) {
            this.sessions = new Hashtable<SessionID, Session>();
        }
        if (!this.sessions.containsKey(sessionID)) {
            SessionImpl session = new SessionImpl(sessionID, this.getHost());
            this.sessions.put(sessionID, session);
            session.addOtrEngineListener(new OtrEngineListener(){

                public void sessionStatusChanged(SessionID sessionID) {
                    for (OtrEngineListener l : OtrEngineImpl.this.listeners) {
                        l.sessionStatusChanged(sessionID);
                    }
                }
            });
            return session;
        }
        return this.sessions.get(sessionID);
    }

    public SessionStatus getSessionStatus(SessionID sessionID) {
        return this.getSession(sessionID).getSessionStatus();
    }

    public String transformReceiving(SessionID sessionID, String msgText) throws OtrException {
        return this.getSession(sessionID).transformReceiving(msgText);
    }

    public String transformSending(SessionID sessionID, String msgText) throws OtrException {
        return this.getSession(sessionID).transformSending(msgText, null);
    }

    public void endSession(SessionID sessionID) throws OtrException {
        this.getSession(sessionID).endSession();
    }

    public void startSession(SessionID sessionID) throws OtrException {
        this.getSession(sessionID).startSession();
    }

    private void setHost(OtrEngineHost host) {
        this.host = host;
    }

    private OtrEngineHost getHost() {
        return this.host;
    }

    public void refreshSession(SessionID sessionID) throws OtrException {
        this.getSession(sessionID).refreshSession();
    }

    public PublicKey getRemotePublicKey(SessionID sessionID) {
        return this.getSession(sessionID).getRemotePublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

