/*
 * Decompiled with CFR 0.152.
 */
package net.java.dict4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.dict4j.Definition;
import net.java.dict4j.DictException;
import net.java.dict4j.DictReturnCode;
import net.java.dict4j.Dictionary;
import net.java.dict4j.MatchWord;
import net.java.dict4j.Strategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictConnection {
    private String host;
    private int port;
    private String clientName = "";
    private int timeout = 5000;
    private Socket socket;
    private PrintWriter out;
    private BufferedReader in;
    private boolean connected;
    private List<Dictionary> dictionariesList = null;
    private List<Strategy> strategiesList = null;
    private String authMsgId = "";
    private List<String> capacities = null;

    public DictConnection() {
        this("dict.org", 2628);
    }

    public DictConnection(String string) {
        this(string, 2628);
    }

    public DictConnection(String string, int n) {
        this.host = string;
        this.port = n;
        this.connected = false;
        this.socket = null;
        this.out = null;
        this.in = null;
    }

    public void connect() throws DictException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.socket = new Socket(this.host, this.port);
            this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"), true);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            String string = this.in.readLine();
            if (string.startsWith("220")) {
                String[] stringArray = string.split(" ");
                this.authMsgId = stringArray[stringArray.length - 1];
                this.capacities = Arrays.asList(stringArray[stringArray.length - 2].split("."));
                this.connected = true;
                this.sendClientCommand();
                return;
            }
            throw new DictException(string.substring(0, 3));
        }
        catch (UnknownHostException unknownHostException) {
            throw new DictException(unknownHostException);
        }
        catch (IOException iOException) {
            throw new DictException(iOException);
        }
    }

    public void close() throws DictException {
        boolean bl = false;
        if (!this.isConnected()) {
            return;
        }
        try {
            String string;
            this.out.println("QUIT");
            while (!bl && (string = this.in.readLine()) != null) {
                if (!string.startsWith("221")) continue;
                bl = true;
            }
            this.out.close();
            this.in.close();
            this.socket.close();
            this.connected = false;
        }
        catch (IOException iOException) {
            throw new DictException(iOException);
        }
    }

    public List<Dictionary> getDictionaries() throws DictException {
        block6: {
            if (this.dictionariesList == null) {
                boolean bl = false;
                this.dictionariesList = new ArrayList<Dictionary>();
                this.connect();
                try {
                    String string = this.query("SHOW DB");
                    if (string.startsWith("110")) {
                        while (!bl && (string = this.in.readLine()) != null) {
                            if (string.startsWith("250")) {
                                bl = true;
                                continue;
                            }
                            if (string.equals(".")) continue;
                            this.dictionariesList.add(new Dictionary(string));
                        }
                        break block6;
                    }
                    throw new DictException(string.substring(0, 3));
                }
                catch (IOException iOException) {
                    throw new DictException(iOException);
                }
            }
        }
        return this.dictionariesList;
    }

    public List<Strategy> getStrategies() throws DictException {
        block6: {
            if (this.strategiesList == null) {
                boolean bl = false;
                this.strategiesList = new ArrayList<Strategy>();
                this.connect();
                try {
                    String string = this.query("SHOW STRAT");
                    if (string.startsWith("111")) {
                        while (!bl && (string = this.in.readLine()) != null) {
                            if (string.startsWith("250")) {
                                bl = true;
                                continue;
                            }
                            if (string.equals(".")) continue;
                            this.strategiesList.add(new Strategy(string));
                        }
                        break block6;
                    }
                    throw new DictException(string.substring(0, 3));
                }
                catch (IOException iOException) {
                    throw new DictException(iOException);
                }
            }
        }
        return this.strategiesList;
    }

    public List<Definition> define(String string, String string2) throws DictException {
        ArrayList<Definition> arrayList;
        block6: {
            boolean bl = false;
            this.connect();
            arrayList = new ArrayList<Definition>();
            int n = -1;
            try {
                String string3 = this.query("DEFINE " + string + " " + string2);
                if (string3.startsWith("150")) {
                    while (!bl && (string3 = this.in.readLine()) != null) {
                        if (string3.startsWith("151")) {
                            ++n;
                            String[] stringArray = string3.split(" ", 4);
                            arrayList.add(new Definition(stringArray[3].substring(1, stringArray[3].length() - 1)));
                            continue;
                        }
                        if (string3.startsWith("250")) {
                            bl = true;
                            continue;
                        }
                        if (string3.equals(".")) continue;
                        ((Definition)arrayList.get(n)).append(string3);
                    }
                    break block6;
                }
                throw new DictException(string3.substring(0, 3));
            }
            catch (IOException iOException) {
                throw new DictException(iOException);
            }
        }
        return arrayList;
    }

    public List<MatchWord> match(String string, String string2, String string3) throws DictException {
        ArrayList<MatchWord> arrayList;
        block5: {
            arrayList = new ArrayList<MatchWord>();
            boolean bl = false;
            this.connect();
            try {
                String string4 = this.query("MATCH " + string + " " + string3 + " " + string2);
                if (string4.startsWith("152")) {
                    while (!bl && (string4 = this.in.readLine()) != null) {
                        if (string4.startsWith("250")) {
                            bl = true;
                            continue;
                        }
                        if (string4.equals(".")) continue;
                        arrayList.add(new MatchWord(string4));
                    }
                    break block5;
                }
                throw new DictException(string4.substring(0, 3));
            }
            catch (IOException iOException) {
                throw new DictException(iOException);
            }
        }
        return arrayList;
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    public String getClientName() {
        return this.clientName;
    }

    private void sendClientCommand() throws DictException {
        if (this.clientName.length() > 0 || !this.isConnected()) {
            return;
        }
        String string = this.query("CLIENT " + this.clientName);
        if (!string.startsWith("250")) {
            throw new DictException(string.substring(0, 3));
        }
    }

    public void setHost(String string) throws DictException {
        if (!DictConnection.isUrl(string)) {
            throw new DictException(900, "Host URL is incorrect");
        }
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDictionaryName(String string) throws DictException {
        if (string.equals("*")) {
            return "Any dictionary";
        }
        if (string.equals("!")) {
            return "First match";
        }
        if (this.dictionariesList == null) {
            this.getDictionaries();
        }
        for (int i = 0; i < this.dictionariesList.size(); ++i) {
            Dictionary dictionary = this.dictionariesList.get(i);
            if (!dictionary.getCode().equals(string)) continue;
            return dictionary.getName();
        }
        return null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static boolean isUrl(String string) {
        boolean bl;
        if (string == null) {
            return false;
        }
        try {
            InetAddress.getByName(string);
            bl = true;
        }
        catch (UnknownHostException unknownHostException) {
            bl = false;
        }
        return bl;
    }

    private String query(String string) throws DictException {
        String string2 = null;
        this.out.println(string);
        try {
            string2 = this.in.readLine();
            if (string2 == null) {
                this.connected = false;
                this.connect();
                this.out.println(string);
                string2 = this.in.readLine();
                if (string2 == null) {
                    throw new DictException(420);
                }
            }
        }
        catch (IOException iOException) {
            throw new DictException(iOException);
        }
        return string2;
    }

    public boolean isAvailable() throws DictException {
        boolean bl = false;
        try {
            bl = InetAddress.getByName(this.host).isReachable(this.timeout);
        }
        catch (Exception exception) {
            throw new DictException(exception);
        }
        return bl;
    }

    public void login(String string, String string2) throws DictException {
        this.connect();
        if (!this.capacities.contains("auth")) {
            throw new DictException(DictReturnCode.COMMAND_NOT_IMPLEMENTED);
        }
        String string3 = "AUTH " + string + " " + this.cryptMD5(this.authMsgId + string2);
        String string4 = this.query(string3);
        if (string4.startsWith("531")) {
            throw new DictException(531, string4.substring(4));
        }
    }

    private String cryptMD5(String string) throws DictException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new DictException(noSuchAlgorithmException);
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        String string2 = "";
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = (byArray[i] & 0xFF) / 16;
            n = (byArray[i] & 0xFF) % 16;
            string2 = string2 + (cArray[n2] + cArray[n]);
        }
        return string2;
    }
}

