/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.utility.LoggerSingleton;

public class PackageManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static Class implClass;
    private static Method getProtocolPrefixListMethod;
    private static Method setProtocolPrefixListMethod;
    private static Method commitProtocolPrefixListMethod;
    private static Method getContentPrefixListMethod;
    private static Method setContentPrefixListMethod;
    private static Method commitContentPrefixListMethod;

    private static Object callImpl(Method method, Object[] args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
    }

    public static void commitContentPrefixList() {
        if (!PackageManager.init()) {
            return;
        }
        PackageManager.callImpl(commitContentPrefixListMethod, new Object[0]);
    }

    public static void commitProtocolPrefixList() {
        if (!PackageManager.init()) {
            return;
        }
        PackageManager.callImpl(commitProtocolPrefixListMethod, new Object[0]);
    }

    public static Vector getContentPrefixList() {
        if (!PackageManager.init()) {
            return null;
        }
        return (Vector)PackageManager.callImpl(getContentPrefixListMethod, new Object[0]);
    }

    public static Vector getProtocolPrefixList() {
        if (!PackageManager.init()) {
            return null;
        }
        return (Vector)PackageManager.callImpl(getProtocolPrefixListMethod, new Object[0]);
    }

    private static Method getStaticMethodOnImplClass(String name, Class[] args, Class returnType) throws Exception {
        Method m = implClass.getMethod(name, args);
        if (m.getReturnType() != returnType) {
            throw new Exception("Expected return type of method " + name + " to be " + returnType + ", was " + m.getReturnType());
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new Exception("Expected method " + name + " to be static");
        }
        return m;
    }

    private static synchronized boolean init() {
        if (implClass != null) {
            return true;
        }
        try {
            implClass = Class.forName("javax.media.pm.PackageManager");
            if (!PackageManager.class.isAssignableFrom(implClass)) {
                throw new Exception("javax.media.pm.PackageManager not subclass of " + PackageManager.class.getName());
            }
            getProtocolPrefixListMethod = PackageManager.getStaticMethodOnImplClass("getProtocolPrefixList", new Class[0], Vector.class);
            setProtocolPrefixListMethod = PackageManager.getStaticMethodOnImplClass("setProtocolPrefixList", new Class[]{Vector.class}, Void.TYPE);
            commitProtocolPrefixListMethod = PackageManager.getStaticMethodOnImplClass("commitProtocolPrefixList", new Class[0], Void.TYPE);
            getContentPrefixListMethod = PackageManager.getStaticMethodOnImplClass("getContentPrefixList", new Class[0], Vector.class);
            setContentPrefixListMethod = PackageManager.getStaticMethodOnImplClass("setContentPrefixList", new Class[]{Vector.class}, Void.TYPE);
            commitContentPrefixListMethod = PackageManager.getStaticMethodOnImplClass("commitContentPrefixList", new Class[0], Void.TYPE);
        }
        catch (Exception e) {
            implClass = null;
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        return true;
    }

    public static void setContentPrefixList(Vector list) {
        if (!PackageManager.init()) {
            return;
        }
        PackageManager.callImpl(setContentPrefixListMethod, new Object[]{list});
    }

    public static void setProtocolPrefixList(Vector list) {
        if (!PackageManager.init()) {
            return;
        }
        PackageManager.callImpl(setProtocolPrefixListMethod, new Object[]{list});
    }
}

