/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.ZrtpConfigure;
import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.utils.ZrtpUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;

public class ZrtpPacketHello
extends ZrtpPacketBase {
    private int nHash;
    private int nCipher;
    private int nPubkey;
    private int nSas;
    private int nAuth;
    private int oHash;
    private int oCipher;
    private int oPubkey;
    private int oSas;
    private int oAuth;
    private int oHmac;
    private byte helloFlags = 0;
    private static final byte HELLO_MITM_FLAG = 32;
    private static final byte SAS_SIGN_FLAG = 64;
    private static final int ZRTP_HELLO_FIX_LENGTH = 17;
    private static final int VERSION_OFFSET = 12;
    private static final int CLIENT_ID_OFFSET = 16;
    private static final int HASH_H3_OFFSET = 32;
    private static final int ZID_OFFSET = 64;
    private static final int FLAG_LENGTH_OFFSET = 76;
    private static final int VARIABLE_OFFSET = 80;
    private int helloLength = 84;

    public ZrtpPacketHello() {
        super(null);
    }

    public void configureHello(ZrtpConfigure config) {
        this.nHash = config.getNumConfiguredHashes();
        this.nCipher = config.getNumConfiguredSymCiphers();
        this.nPubkey = config.getNumConfiguredPubKeys();
        this.nSas = config.getNumConfiguredSasTypes();
        this.nAuth = config.getNumConfiguredAuthLengths();
        this.helloLength += 8;
        this.helloLength += this.nHash * 4;
        this.helloLength += this.nCipher * 4;
        this.helloLength += this.nPubkey * 4;
        this.helloLength += this.nSas * 4;
        this.helloLength += this.nAuth * 4;
        this.packetBuffer = new byte[this.helloLength];
        Arrays.fill(this.packetBuffer, (byte)0);
        this.oHash = 80;
        this.oCipher = this.oHash + this.nHash * 4;
        this.oAuth = this.oCipher + this.nCipher * 4;
        this.oPubkey = this.oAuth + this.nAuth * 4;
        this.oSas = this.oPubkey + this.nPubkey * 4;
        this.oHmac = this.oSas + this.nSas * 4;
        this.setZrtpId();
        this.setLength(this.helloLength / 4 - 1);
        this.setMessageType(ZrtpConstants.HelloMsg);
        this.setVersion(ZrtpConstants.zrtpVersion);
        this.packetBuffer[76] = this.helloFlags;
        this.packetBuffer[77] = (byte)this.nHash;
        int index = 0;
        for (ZrtpConstants.SupportedHashes supportedHashes : config.hashes()) {
            this.setHashType(index++, supportedHashes.name);
        }
        this.packetBuffer[78] = (byte)(this.nCipher << 4);
        index = 0;
        for (ZrtpConstants.SupportedSymCiphers supportedSymCiphers : config.symCiphers()) {
            this.setCipherType(index++, supportedSymCiphers.name);
        }
        this.packetBuffer[78] = (byte)(this.packetBuffer[78] | (byte)this.nAuth);
        index = 0;
        for (ZrtpConstants.SupportedAuthLengths supportedAuthLengths : config.authLengths()) {
            this.setAuthLen(index++, supportedAuthLengths.name);
        }
        this.packetBuffer[79] = (byte)(this.nPubkey << 4);
        index = 0;
        for (ZrtpConstants.SupportedPubKeys supportedPubKeys : config.publicKeyAlgos()) {
            this.setPubKeyType(index++, supportedPubKeys.name);
        }
        this.packetBuffer[79] = (byte)(this.packetBuffer[79] | (byte)this.nSas);
        index = 0;
        for (ZrtpConstants.SupportedSASTypes supportedSASTypes : config.sasTypes()) {
            this.setSasType(index++, supportedSASTypes.name);
        }
    }

    public ZrtpPacketHello(byte[] data) {
        super(data);
        this.helloFlags = this.packetBuffer[76];
        byte temp = this.packetBuffer[77];
        this.nHash = temp & 0xF;
        temp = this.packetBuffer[78];
        this.nCipher = (temp & 0xF0) >> 4;
        this.nAuth = temp & 0xF;
        temp = this.packetBuffer[79];
        this.nPubkey = (temp & 0xF0) >> 4;
        this.nSas = temp & 0xF;
        this.oHash = 80;
        this.oCipher = this.oHash + this.nHash * 4;
        this.oAuth = this.oCipher + this.nCipher * 4;
        this.oPubkey = this.oAuth + this.nAuth * 4;
        this.oSas = this.oPubkey + this.nPubkey * 4;
        this.oHmac = this.oSas + this.nSas * 4;
    }

    public final void setClientId(String text) {
        byte[] data = null;
        try {
            data = text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            data = "GNU ZRTP4J 2.1.0".getBytes();
        }
        int length = data.length > 16 ? 16 : data.length;
        System.arraycopy(data, 0, this.packetBuffer, 16, length);
    }

    public final void setH3(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 32, 32);
    }

    public final byte[] getH3() {
        return ZrtpUtils.readRegion(this.packetBuffer, 32, 32);
    }

    public final void setZid(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 64, 12);
    }

    public final byte[] getZid() {
        return ZrtpUtils.readRegion(this.packetBuffer, 64, 12);
    }

    public final void setVersion(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 12, 4);
    }

    public final byte[] getVersion() {
        return ZrtpUtils.readRegion(this.packetBuffer, 12, 4);
    }

    public final void setHashType(int n, byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, this.oHash + n * 4, 4);
    }

    public final void setCipherType(int n, byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, this.oCipher + n * 4, 4);
    }

    public final void setAuthLen(int n, byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, this.oAuth + n * 4, 4);
    }

    public final void setPubKeyType(int n, byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, this.oPubkey + n * 4, 4);
    }

    public final void setSasType(int n, byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, this.oSas + n * 4, 4);
    }

    public final void setHMAC(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, this.oHmac, 8);
    }

    public final void setMitmMode() {
        this.packetBuffer[76] = (byte)(this.packetBuffer[76] | 0x20);
    }

    public final boolean isMitmMode() {
        return (this.helloFlags & 0x20) == 32;
    }

    public final void setSasSign() {
        this.packetBuffer[76] = (byte)(this.packetBuffer[76] | 0x40);
    }

    public final boolean isSasSign() {
        return (this.helloFlags & 0x40) == 64;
    }

    public final boolean isSameVersion(byte[] data) {
        int i = 0;
        while (i < 4) {
            if (this.packetBuffer[12 + i] != data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final ZrtpConstants.SupportedHashes findBestHash(ZrtpConfigure config) {
        if (this.nHash == 0) {
            return ZrtpConstants.SupportedHashes.S256;
        }
        boolean mandatoryFound = false;
        int numAlgosOffered = this.nHash;
        ArrayList<ZrtpConstants.SupportedHashes> algosOffered = new ArrayList<ZrtpConstants.SupportedHashes>(numAlgosOffered + 1);
        int numAlgosConf = config.getNumConfiguredHashes();
        ArrayList<ZrtpConstants.SupportedHashes> algosConf = new ArrayList<ZrtpConstants.SupportedHashes>(numAlgosConf + 1);
        for (ZrtpConstants.SupportedHashes sh : config.hashes()) {
            if (sh == ZrtpConstants.SupportedHashes.S256) {
                mandatoryFound = true;
            }
            algosConf.add(sh);
        }
        if (!mandatoryFound) {
            algosConf.add(ZrtpConstants.SupportedHashes.S256);
        }
        mandatoryFound = false;
        int ii = 0;
        while (ii < this.nHash) {
            int o = this.oHash + ii * 4;
            ZrtpConstants.SupportedHashes[] supportedHashesArray = ZrtpConstants.SupportedHashes.values();
            int n = supportedHashesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZrtpConstants.SupportedHashes sh = supportedHashesArray[n2];
                byte[] s = sh.name;
                if (s[0] == this.packetBuffer[o] && s[1] == this.packetBuffer[o + 1] && s[2] == this.packetBuffer[o + 2] && s[3] == this.packetBuffer[o + 3]) {
                    algosOffered.add(sh);
                    if (sh == ZrtpConstants.SupportedHashes.S256) {
                        mandatoryFound = true;
                    }
                }
                ++n2;
            }
            ++ii;
        }
        if (!mandatoryFound) {
            algosOffered.add(ZrtpConstants.SupportedHashes.S256);
        }
        for (ZrtpConstants.SupportedHashes sho : algosOffered) {
            for (ZrtpConstants.SupportedHashes shc : algosConf) {
                if (sho != shc) continue;
                return shc;
            }
        }
        return ZrtpConstants.SupportedHashes.S256;
    }

    public final ZrtpConstants.SupportedSymCiphers findBestCipher(ZrtpConfigure config, ZrtpConstants.SupportedPubKeys pk) {
        if (this.nCipher == 0 || pk == ZrtpConstants.SupportedPubKeys.DH2K) {
            return ZrtpConstants.SupportedSymCiphers.AES1;
        }
        boolean mandatoryFound = false;
        int numAlgosOffered = this.nCipher;
        ArrayList<ZrtpConstants.SupportedSymCiphers> algosOffered = new ArrayList<ZrtpConstants.SupportedSymCiphers>(numAlgosOffered + 1);
        int numAlgosConf = config.getNumConfiguredSymCiphers();
        ArrayList<ZrtpConstants.SupportedSymCiphers> algosConf = new ArrayList<ZrtpConstants.SupportedSymCiphers>(numAlgosConf + 1);
        for (ZrtpConstants.SupportedSymCiphers sh : config.symCiphers()) {
            if (sh == ZrtpConstants.SupportedSymCiphers.AES1) {
                mandatoryFound = true;
            }
            algosConf.add(sh);
        }
        if (!mandatoryFound) {
            algosConf.add(ZrtpConstants.SupportedSymCiphers.AES1);
        }
        mandatoryFound = false;
        int ii = 0;
        while (ii < this.nCipher) {
            int o = this.oCipher + ii * 4;
            ZrtpConstants.SupportedSymCiphers[] supportedSymCiphersArray = ZrtpConstants.SupportedSymCiphers.values();
            int n = supportedSymCiphersArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZrtpConstants.SupportedSymCiphers sh = supportedSymCiphersArray[n2];
                byte[] s = sh.name;
                if (s[0] == this.packetBuffer[o] && s[1] == this.packetBuffer[o + 1] && s[2] == this.packetBuffer[o + 2] && s[3] == this.packetBuffer[o + 3]) {
                    algosOffered.add(sh);
                    if (sh == ZrtpConstants.SupportedSymCiphers.AES1) {
                        mandatoryFound = true;
                    }
                }
                ++n2;
            }
            ++ii;
        }
        if (!mandatoryFound) {
            algosOffered.add(ZrtpConstants.SupportedSymCiphers.AES1);
        }
        for (ZrtpConstants.SupportedSymCiphers sho : algosOffered) {
            for (ZrtpConstants.SupportedSymCiphers shc : algosConf) {
                if (sho != shc) continue;
                return shc;
            }
        }
        return ZrtpConstants.SupportedSymCiphers.AES1;
    }

    public final ZrtpConstants.SupportedPubKeys findBestPubkey(ZrtpConfigure config) {
        if (this.nPubkey == 0) {
            return ZrtpConstants.SupportedPubKeys.DH3K;
        }
        boolean mandatoryFound = false;
        int numAlgosOffered = this.nPubkey;
        ArrayList<ZrtpConstants.SupportedPubKeys> algosOffered = new ArrayList<ZrtpConstants.SupportedPubKeys>(numAlgosOffered + 1);
        int numAlgosConf = config.getNumConfiguredPubKeys();
        ArrayList<ZrtpConstants.SupportedPubKeys> algosConf = new ArrayList<ZrtpConstants.SupportedPubKeys>(numAlgosConf + 1);
        for (ZrtpConstants.SupportedPubKeys sh : config.publicKeyAlgos()) {
            if (sh == ZrtpConstants.SupportedPubKeys.MULT) continue;
            if (sh == ZrtpConstants.SupportedPubKeys.DH3K) {
                mandatoryFound = true;
            }
            algosConf.add(sh);
        }
        if (!mandatoryFound) {
            algosConf.add(ZrtpConstants.SupportedPubKeys.DH3K);
        }
        mandatoryFound = false;
        int ii = 0;
        while (ii < this.nPubkey) {
            int o = this.oPubkey + ii * 4;
            ZrtpConstants.SupportedPubKeys[] supportedPubKeysArray = ZrtpConstants.SupportedPubKeys.values();
            int n = supportedPubKeysArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZrtpConstants.SupportedPubKeys sh = supportedPubKeysArray[n2];
                byte[] s = sh.name;
                if (s[0] == this.packetBuffer[o] && s[1] == this.packetBuffer[o + 1] && s[2] == this.packetBuffer[o + 2] && s[3] == this.packetBuffer[o + 3]) {
                    algosOffered.add(sh);
                    if (sh == ZrtpConstants.SupportedPubKeys.DH3K) {
                        mandatoryFound = true;
                    }
                }
                ++n2;
            }
            ++ii;
        }
        if (!mandatoryFound) {
            algosOffered.add(ZrtpConstants.SupportedPubKeys.DH3K);
        }
        for (ZrtpConstants.SupportedPubKeys sho : algosOffered) {
            for (ZrtpConstants.SupportedPubKeys shc : algosConf) {
                if (sho != shc) continue;
                return shc;
            }
        }
        return ZrtpConstants.SupportedPubKeys.DH3K;
    }

    public final ZrtpConstants.SupportedSASTypes findBestSASType(ZrtpConfigure config) {
        if (this.nSas == 0) {
            return ZrtpConstants.SupportedSASTypes.B32;
        }
        boolean mandatoryFound = false;
        int numAlgosOffered = this.nSas;
        ArrayList<ZrtpConstants.SupportedSASTypes> algosOffered = new ArrayList<ZrtpConstants.SupportedSASTypes>(numAlgosOffered + 1);
        int numAlgosConf = config.getNumConfiguredSasTypes();
        ArrayList<ZrtpConstants.SupportedSASTypes> algosConf = new ArrayList<ZrtpConstants.SupportedSASTypes>(numAlgosConf + 1);
        for (ZrtpConstants.SupportedSASTypes sh : config.sasTypes()) {
            if (sh == ZrtpConstants.SupportedSASTypes.B32) {
                mandatoryFound = true;
            }
            algosConf.add(sh);
        }
        if (!mandatoryFound) {
            algosConf.add(ZrtpConstants.SupportedSASTypes.B32);
        }
        mandatoryFound = false;
        int ii = 0;
        while (ii < this.nSas) {
            int o = this.oSas + ii * 4;
            ZrtpConstants.SupportedSASTypes[] supportedSASTypesArray = ZrtpConstants.SupportedSASTypes.values();
            int n = supportedSASTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZrtpConstants.SupportedSASTypes sh = supportedSASTypesArray[n2];
                byte[] s = sh.name;
                if (s[0] == this.packetBuffer[o] && s[1] == this.packetBuffer[o + 1] && s[2] == this.packetBuffer[o + 2] && s[3] == this.packetBuffer[o + 3]) {
                    algosOffered.add(sh);
                    if (sh == ZrtpConstants.SupportedSASTypes.B32) {
                        mandatoryFound = true;
                    }
                }
                ++n2;
            }
            ++ii;
        }
        if (!mandatoryFound) {
            algosOffered.add(ZrtpConstants.SupportedSASTypes.B32);
        }
        for (ZrtpConstants.SupportedSASTypes sho : algosOffered) {
            for (ZrtpConstants.SupportedSASTypes shc : algosConf) {
                if (sho != shc) continue;
                return shc;
            }
        }
        return ZrtpConstants.SupportedSASTypes.B32;
    }

    public final ZrtpConstants.SupportedAuthLengths findBestAuthLen(ZrtpConfigure config) {
        if (this.nAuth == 0) {
            return ZrtpConstants.SupportedAuthLengths.HS32;
        }
        boolean mandatoryFound_1 = false;
        boolean mandatoryFound_2 = false;
        int numAlgosOffered = this.nAuth;
        ArrayList<ZrtpConstants.SupportedAuthLengths> algosOffered = new ArrayList<ZrtpConstants.SupportedAuthLengths>(numAlgosOffered + 1);
        int numAlgosConf = config.getNumConfiguredAuthLengths();
        ArrayList<ZrtpConstants.SupportedAuthLengths> algosConf = new ArrayList<ZrtpConstants.SupportedAuthLengths>(numAlgosConf + 1);
        for (ZrtpConstants.SupportedAuthLengths sh : config.authLengths()) {
            if (sh == ZrtpConstants.SupportedAuthLengths.HS32) {
                mandatoryFound_1 = true;
            }
            if (sh == ZrtpConstants.SupportedAuthLengths.HS80) {
                mandatoryFound_2 = true;
            }
            algosConf.add(sh);
        }
        if (!mandatoryFound_1) {
            algosConf.add(ZrtpConstants.SupportedAuthLengths.HS32);
        }
        if (!mandatoryFound_2) {
            algosConf.add(ZrtpConstants.SupportedAuthLengths.HS80);
        }
        mandatoryFound_2 = false;
        mandatoryFound_1 = false;
        int ii = 0;
        while (ii < this.nAuth) {
            int o = this.oAuth + ii * 4;
            ZrtpConstants.SupportedAuthLengths[] supportedAuthLengthsArray = ZrtpConstants.SupportedAuthLengths.values();
            int n = supportedAuthLengthsArray.length;
            int n2 = 0;
            while (n2 < n) {
                ZrtpConstants.SupportedAuthLengths sh = supportedAuthLengthsArray[n2];
                byte[] s = sh.name;
                if (s[0] == this.packetBuffer[o] && s[1] == this.packetBuffer[o + 1] && s[2] == this.packetBuffer[o + 2] && s[3] == this.packetBuffer[o + 3]) {
                    algosOffered.add(sh);
                    if (sh == ZrtpConstants.SupportedAuthLengths.HS32) {
                        mandatoryFound_1 = true;
                    }
                    if (sh == ZrtpConstants.SupportedAuthLengths.HS80) {
                        mandatoryFound_2 = true;
                    }
                }
                ++n2;
            }
            ++ii;
        }
        if (!mandatoryFound_1) {
            algosOffered.add(ZrtpConstants.SupportedAuthLengths.HS32);
        }
        if (!mandatoryFound_2) {
            algosOffered.add(ZrtpConstants.SupportedAuthLengths.HS80);
        }
        for (ZrtpConstants.SupportedAuthLengths sho : algosOffered) {
            for (ZrtpConstants.SupportedAuthLengths shc : algosConf) {
                if (sho != shc) continue;
                return shc;
            }
        }
        return ZrtpConstants.SupportedAuthLengths.HS32;
    }

    public final boolean checkMultiStream() {
        if (this.nPubkey == 0) {
            return true;
        }
        byte[] s = ZrtpConstants.SupportedPubKeys.MULT.name;
        int ii = 0;
        while (ii < this.nPubkey) {
            int o = this.oPubkey + ii * 4;
            if (s[0] == this.packetBuffer[o] && s[1] == this.packetBuffer[o + 1] && s[2] == this.packetBuffer[o + 2] && s[3] == this.packetBuffer[o + 3]) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    public final int getNAuth() {
        return this.nAuth;
    }

    public final int getNCipher() {
        return this.nCipher;
    }

    public final int getNHash() {
        return this.nHash;
    }

    public final int getNPubkey() {
        return this.nPubkey;
    }

    public final int getNSas() {
        return this.nSas;
    }
}

