/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mathzrtp.ec;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.mathzrtp.ec.ECCurve;
import org.bouncycastle.mathzrtp.ec.ECPoint;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint P, BigIntegerCrypto a, ECPoint Q, BigIntegerCrypto b) {
        ECCurve c = P.getCurve();
        if (!c.equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, a, Q, b);
    }

    public static ECPoint shamirsTrick(ECPoint P, BigIntegerCrypto k, ECPoint Q, BigIntegerCrypto l) {
        if (!P.getCurve().equals(Q.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P, k, Q, l);
    }

    private static ECPoint implShamirsTrick(ECPoint P, BigIntegerCrypto k, ECPoint Q, BigIntegerCrypto l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        ECPoint Z = P.add(Q);
        ECPoint R = P.getCurve().getInfinity();
        int i = m - 1;
        while (i >= 0) {
            R = R.twice();
            if (k.testBit(i)) {
                R = l.testBit(i) ? R.add(Z) : R.add(P);
            } else if (l.testBit(i)) {
                R = R.add(Q);
            }
            --i;
        }
        return R;
    }
}

