/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mathzrtp.ec;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.mathzrtp.ec.ECConstants;
import org.bouncycastle.mathzrtp.ec.ECCurve;
import org.bouncycastle.mathzrtp.ec.ECFieldElement;
import org.bouncycastle.mathzrtp.ec.ECPoint;
import org.bouncycastle.mathzrtp.ec.SimpleBigDecimal;
import org.bouncycastle.mathzrtp.ec.ZTauElement;

class Tnaf {
    private static final BigIntegerCrypto MINUS_ONE = ECConstants.ONE.negate();
    private static final BigIntegerCrypto MINUS_TWO = ECConstants.TWO.negate();
    private static final BigIntegerCrypto MINUS_THREE = ECConstants.THREE.negate();
    public static final byte WIDTH = 4;
    public static final byte POW_2_WIDTH = 16;
    public static final ZTauElement[] alpha0;
    public static final byte[][] alpha0Tnaf;
    public static final ZTauElement[] alpha1;
    public static final byte[][] alpha1Tnaf;

    static {
        ZTauElement[] zTauElementArray = new ZTauElement[9];
        zTauElementArray[1] = new ZTauElement(ECConstants.ONE, ECConstants.ZERO);
        zTauElementArray[3] = new ZTauElement(MINUS_THREE, MINUS_ONE);
        zTauElementArray[5] = new ZTauElement(MINUS_ONE, MINUS_ONE);
        zTauElementArray[7] = new ZTauElement(ECConstants.ONE, MINUS_ONE);
        alpha0 = zTauElementArray;
        byte[][] byArrayArray = new byte[8][];
        byArrayArray[1] = new byte[]{1};
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        byArray[2] = 1;
        byArrayArray[3] = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = 1;
        byArray2[2] = 1;
        byArrayArray[5] = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[0] = -1;
        byArray3[3] = 1;
        byArrayArray[7] = byArray3;
        alpha0Tnaf = byArrayArray;
        ZTauElement[] zTauElementArray2 = new ZTauElement[9];
        zTauElementArray2[1] = new ZTauElement(ECConstants.ONE, ECConstants.ZERO);
        zTauElementArray2[3] = new ZTauElement(MINUS_THREE, ECConstants.ONE);
        zTauElementArray2[5] = new ZTauElement(MINUS_ONE, ECConstants.ONE);
        zTauElementArray2[7] = new ZTauElement(ECConstants.ONE, ECConstants.ONE);
        alpha1 = zTauElementArray2;
        byte[][] byArrayArray2 = new byte[8][];
        byArrayArray2[1] = new byte[]{1};
        byte[] byArray4 = new byte[3];
        byArray4[0] = -1;
        byArray4[2] = 1;
        byArrayArray2[3] = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = 1;
        byArray5[2] = 1;
        byArrayArray2[5] = byArray5;
        byte[] byArray6 = new byte[4];
        byArray6[0] = -1;
        byArray6[3] = -1;
        byArrayArray2[7] = byArray6;
        alpha1Tnaf = byArrayArray2;
    }

    Tnaf() {
    }

    public static BigIntegerCrypto norm(byte mu, ZTauElement lambda) {
        BigIntegerCrypto norm;
        BigIntegerCrypto s1 = lambda.u.multiply(lambda.u);
        BigIntegerCrypto s2 = lambda.u.multiply(lambda.v);
        BigIntegerCrypto s3 = lambda.v.multiply(lambda.v).shiftLeft(1);
        if (mu == 1) {
            norm = s1.add(s2).add(s3);
        } else if (mu == -1) {
            norm = s1.subtract(s2).add(s3);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return norm;
    }

    public static SimpleBigDecimal norm(byte mu, SimpleBigDecimal u, SimpleBigDecimal v) {
        SimpleBigDecimal norm;
        SimpleBigDecimal s1 = u.multiply(u);
        SimpleBigDecimal s2 = u.multiply(v);
        SimpleBigDecimal s3 = v.multiply(v).shiftLeft(1);
        if (mu == 1) {
            norm = s1.add(s2).add(s3);
        } else if (mu == -1) {
            norm = s1.subtract(s2).add(s3);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return norm;
    }

    public static ZTauElement round(SimpleBigDecimal lambda0, SimpleBigDecimal lambda1, byte mu) {
        SimpleBigDecimal check2;
        SimpleBigDecimal check1;
        int scale = lambda0.getScale();
        if (lambda1.getScale() != scale) {
            throw new IllegalArgumentException("lambda0 and lambda1 do not have same scale");
        }
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigIntegerCrypto f0 = lambda0.round();
        BigIntegerCrypto f1 = lambda1.round();
        SimpleBigDecimal eta0 = lambda0.subtract(f0);
        SimpleBigDecimal eta1 = lambda1.subtract(f1);
        SimpleBigDecimal eta = eta0.add(eta0);
        eta = mu == 1 ? eta.add(eta1) : eta.subtract(eta1);
        SimpleBigDecimal threeEta1 = eta1.add(eta1).add(eta1);
        SimpleBigDecimal fourEta1 = threeEta1.add(eta1);
        if (mu == 1) {
            check1 = eta0.subtract(threeEta1);
            check2 = eta0.add(fourEta1);
        } else {
            check1 = eta0.add(threeEta1);
            check2 = eta0.subtract(fourEta1);
        }
        int h0 = 0;
        byte h1 = 0;
        if (eta.compareTo(ECConstants.ONE) >= 0) {
            if (check1.compareTo(MINUS_ONE) < 0) {
                h1 = mu;
            } else {
                h0 = 1;
            }
        } else if (check2.compareTo(ECConstants.TWO) >= 0) {
            h1 = mu;
        }
        if (eta.compareTo(MINUS_ONE) < 0) {
            if (check1.compareTo(ECConstants.ONE) >= 0) {
                h1 = -mu;
            } else {
                h0 = -1;
            }
        } else if (check2.compareTo(MINUS_TWO) < 0) {
            h1 = -mu;
        }
        BigIntegerCrypto q0 = f0.add(BigIntegerCrypto.valueOf(h0));
        BigIntegerCrypto q1 = f1.add(BigIntegerCrypto.valueOf(h1));
        return new ZTauElement(q0, q1);
    }

    public static SimpleBigDecimal approximateDivisionByN(BigIntegerCrypto k, BigIntegerCrypto s, BigIntegerCrypto vm, byte a, int m, int c) {
        int _k = (m + 5) / 2 + c;
        BigIntegerCrypto ns = k.shiftRight(m - _k - 2 + a);
        BigIntegerCrypto gs = s.multiply(ns);
        BigIntegerCrypto hs = gs.shiftRight(m);
        BigIntegerCrypto js = vm.multiply(hs);
        BigIntegerCrypto gsPlusJs = gs.add(js);
        BigIntegerCrypto ls = gsPlusJs.shiftRight(_k - c);
        if (gsPlusJs.testBit(_k - c - 1)) {
            ls = ls.add(ECConstants.ONE);
        }
        return new SimpleBigDecimal(ls, c);
    }

    public static byte[] tauAdicNaf(byte mu, ZTauElement lambda) {
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigIntegerCrypto norm = Tnaf.norm(mu, lambda);
        int log2Norm = norm.bitLength();
        int maxLength = log2Norm > 30 ? log2Norm + 4 : 34;
        byte[] u = new byte[maxLength];
        int i = 0;
        int length = 0;
        BigIntegerCrypto r0 = lambda.u;
        BigIntegerCrypto r1 = lambda.v;
        while (!r0.equals(ECConstants.ZERO) || !r1.equals(ECConstants.ZERO)) {
            if (r0.testBit(0)) {
                u[i] = (byte)ECConstants.TWO.subtract(r0.subtract(r1.shiftLeft(1)).mod(ECConstants.FOUR)).intValue();
                r0 = u[i] == 1 ? r0.clearBit(0) : r0.add(ECConstants.ONE);
                length = i;
            } else {
                u[i] = 0;
            }
            BigIntegerCrypto t = r0;
            BigIntegerCrypto s = r0.shiftRight(1);
            r0 = mu == 1 ? r1.add(s) : r1.subtract(s);
            r1 = t.shiftRight(1).negate();
            ++i;
        }
        byte[] tnaf = new byte[++length];
        System.arraycopy(u, 0, tnaf, 0, length);
        return tnaf;
    }

    public static ECPoint.F2m tau(ECPoint.F2m p) {
        if (p.isInfinity()) {
            return p;
        }
        ECFieldElement x = p.getX();
        ECFieldElement y = p.getY();
        return new ECPoint.F2m(p.getCurve(), x.square(), y.square(), p.isCompressed());
    }

    public static byte getMu(ECCurve.F2m curve) {
        byte mu;
        BigIntegerCrypto a = curve.getA().toBigInteger();
        if (a.equals(ECConstants.ZERO)) {
            mu = -1;
        } else if (a.equals(ECConstants.ONE)) {
            mu = 1;
        } else {
            throw new IllegalArgumentException("No Koblitz curve (ABC), TNAF multiplication not possible");
        }
        return mu;
    }

    public static BigIntegerCrypto[] getLucas(byte mu, int k, boolean doV) {
        BigIntegerCrypto u1;
        BigIntegerCrypto u0;
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        if (doV) {
            u0 = ECConstants.TWO;
            u1 = BigIntegerCrypto.valueOf(mu);
        } else {
            u0 = ECConstants.ZERO;
            u1 = ECConstants.ONE;
        }
        int i = 1;
        while (i < k) {
            BigIntegerCrypto s = null;
            s = mu == 1 ? u1 : u1.negate();
            BigIntegerCrypto u2 = s.subtract(u0.shiftLeft(1));
            u0 = u1;
            u1 = u2;
            ++i;
        }
        BigIntegerCrypto[] retVal = new BigIntegerCrypto[]{u0, u1};
        return retVal;
    }

    public static BigIntegerCrypto getTw(byte mu, int w) {
        if (w == 4) {
            if (mu == 1) {
                return BigIntegerCrypto.valueOf(6L);
            }
            return BigIntegerCrypto.valueOf(10L);
        }
        BigIntegerCrypto[] us = Tnaf.getLucas(mu, w, false);
        BigIntegerCrypto twoToW = ECConstants.ZERO.setBit(w);
        BigIntegerCrypto u1invert = us[1].modInverse(twoToW);
        BigIntegerCrypto tw = ECConstants.TWO.multiply(us[0]).multiply(u1invert).mod(twoToW);
        return tw;
    }

    public static BigIntegerCrypto[] getSi(ECCurve.F2m curve) {
        BigIntegerCrypto dividend1;
        BigIntegerCrypto dividend0;
        if (!curve.isKoblitz()) {
            throw new IllegalArgumentException("si is defined for Koblitz curves only");
        }
        int m = curve.getM();
        int a = curve.getA().toBigInteger().intValue();
        byte mu = curve.getMu();
        int h = curve.getH().intValue();
        int index = m + 3 - a;
        BigIntegerCrypto[] ui = Tnaf.getLucas(mu, index, false);
        if (mu == 1) {
            dividend0 = ECConstants.ONE.subtract(ui[1]);
            dividend1 = ECConstants.ONE.subtract(ui[0]);
        } else if (mu == -1) {
            dividend0 = ECConstants.ONE.add(ui[1]);
            dividend1 = ECConstants.ONE.add(ui[0]);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigIntegerCrypto[] si = new BigIntegerCrypto[2];
        if (h == 2) {
            si[0] = dividend0.shiftRight(1);
            si[1] = dividend1.shiftRight(1).negate();
        } else if (h == 4) {
            si[0] = dividend0.shiftRight(2);
            si[1] = dividend1.shiftRight(2).negate();
        } else {
            throw new IllegalArgumentException("h (Cofactor) must be 2 or 4");
        }
        return si;
    }

    public static ZTauElement partModReduction(BigIntegerCrypto k, int m, byte a, BigIntegerCrypto[] s, byte mu, byte c) {
        BigIntegerCrypto d0 = mu == 1 ? s[0].add(s[1]) : s[0].subtract(s[1]);
        BigIntegerCrypto[] v = Tnaf.getLucas(mu, m, true);
        BigIntegerCrypto vm = v[1];
        SimpleBigDecimal lambda0 = Tnaf.approximateDivisionByN(k, s[0], vm, a, m, c);
        SimpleBigDecimal lambda1 = Tnaf.approximateDivisionByN(k, s[1], vm, a, m, c);
        ZTauElement q = Tnaf.round(lambda0, lambda1, mu);
        BigIntegerCrypto r0 = k.subtract(d0.multiply(q.u)).subtract(BigIntegerCrypto.valueOf(2L).multiply(s[1]).multiply(q.v));
        BigIntegerCrypto r1 = s[1].multiply(q.u).subtract(s[0].multiply(q.v));
        return new ZTauElement(r0, r1);
    }

    public static ECPoint.F2m multiplyRTnaf(ECPoint.F2m p, BigIntegerCrypto k) {
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        int m = curve.getM();
        byte a = (byte)curve.getA().toBigInteger().intValue();
        byte mu = curve.getMu();
        BigIntegerCrypto[] s = curve.getSi();
        ZTauElement rho = Tnaf.partModReduction(k, m, a, s, mu, (byte)10);
        return Tnaf.multiplyTnaf(p, rho);
    }

    public static ECPoint.F2m multiplyTnaf(ECPoint.F2m p, ZTauElement lambda) {
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        byte mu = curve.getMu();
        byte[] u = Tnaf.tauAdicNaf(mu, lambda);
        ECPoint.F2m q = Tnaf.multiplyFromTnaf(p, u);
        return q;
    }

    public static ECPoint.F2m multiplyFromTnaf(ECPoint.F2m p, byte[] u) {
        ECCurve.F2m curve = (ECCurve.F2m)p.getCurve();
        ECPoint.F2m q = (ECPoint.F2m)curve.getInfinity();
        int i = u.length - 1;
        while (i >= 0) {
            q = Tnaf.tau(q);
            if (u[i] == 1) {
                q = q.addSimple(p);
            } else if (u[i] == -1) {
                q = q.subtractSimple(p);
            }
            --i;
        }
        return q;
    }

    public static byte[] tauAdicWNaf(byte mu, ZTauElement lambda, byte width, BigIntegerCrypto pow2w, BigIntegerCrypto tw, ZTauElement[] alpha) {
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigIntegerCrypto norm = Tnaf.norm(mu, lambda);
        int log2Norm = norm.bitLength();
        int maxLength = log2Norm > 30 ? log2Norm + 4 + width : 34 + width;
        byte[] u = new byte[maxLength];
        BigIntegerCrypto pow2wMin1 = pow2w.shiftRight(1);
        BigIntegerCrypto r0 = lambda.u;
        BigIntegerCrypto r1 = lambda.v;
        int i = 0;
        while (!r0.equals(ECConstants.ZERO) || !r1.equals(ECConstants.ZERO)) {
            if (r0.testBit(0)) {
                BigIntegerCrypto uUnMod = r0.add(r1.multiply(tw)).mod(pow2w);
                byte uLocal = uUnMod.compareTo(pow2wMin1) >= 0 ? (byte)uUnMod.subtract(pow2w).intValue() : (byte)uUnMod.intValue();
                u[i] = uLocal;
                boolean s = true;
                if (uLocal < 0) {
                    s = false;
                    uLocal = -uLocal;
                }
                if (s) {
                    r0 = r0.subtract(alpha[uLocal].u);
                    r1 = r1.subtract(alpha[uLocal].v);
                } else {
                    r0 = r0.add(alpha[uLocal].u);
                    r1 = r1.add(alpha[uLocal].v);
                }
            } else {
                u[i] = 0;
            }
            BigIntegerCrypto t = r0;
            r0 = mu == 1 ? r1.add(r0.shiftRight(1)) : r1.subtract(r0.shiftRight(1));
            r1 = t.shiftRight(1).negate();
            ++i;
        }
        return u;
    }

    public static ECPoint.F2m[] getPreComp(ECPoint.F2m p, byte a) {
        ECPoint.F2m[] pu = new ECPoint.F2m[16];
        pu[1] = p;
        byte[][] alphaTnaf = a == 0 ? alpha0Tnaf : alpha1Tnaf;
        int precompLen = alphaTnaf.length;
        int i = 3;
        while (i < precompLen) {
            pu[i] = Tnaf.multiplyFromTnaf(p, alphaTnaf[i]);
            i += 2;
        }
        return pu;
    }
}

