/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mathzrtp.ec;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.mathzrtp.ec.ECMultiplier;
import org.bouncycastle.mathzrtp.ec.ECPoint;
import org.bouncycastle.mathzrtp.ec.PreCompInfo;
import org.bouncycastle.mathzrtp.ec.WNafPreCompInfo;

class WNafMultiplier
implements ECMultiplier {
    WNafMultiplier() {
    }

    public byte[] windowNaf(byte width, BigIntegerCrypto k) {
        byte[] wnaf = new byte[k.bitLength() + 1];
        short pow2wB = (short)(1 << width);
        BigIntegerCrypto pow2wBI = BigIntegerCrypto.valueOf(pow2wB);
        int i = 0;
        int length = 0;
        while (k.signum() > 0) {
            if (k.testBit(0)) {
                BigIntegerCrypto remainder = k.mod(pow2wBI);
                wnaf[i] = remainder.testBit(width - 1) ? (byte)(remainder.intValue() - pow2wB) : (byte)remainder.intValue();
                k = k.subtract(BigIntegerCrypto.valueOf(wnaf[i]));
                length = i;
            } else {
                wnaf[i] = 0;
            }
            k = k.shiftRight(1);
            ++i;
        }
        byte[] wnafShort = new byte[++length];
        System.arraycopy(wnaf, 0, wnafShort, 0, length);
        return wnafShort;
    }

    public ECPoint multiply(ECPoint p, BigIntegerCrypto k, PreCompInfo preCompInfo) {
        int reqPreCompLen;
        byte width;
        WNafPreCompInfo wnafPreCompInfo = preCompInfo != null && preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : new WNafPreCompInfo();
        int m = k.bitLength();
        if (m < 13) {
            width = 2;
            reqPreCompLen = 1;
        } else if (m < 41) {
            width = 3;
            reqPreCompLen = 2;
        } else if (m < 121) {
            width = 4;
            reqPreCompLen = 4;
        } else if (m < 337) {
            width = 5;
            reqPreCompLen = 8;
        } else if (m < 897) {
            width = 6;
            reqPreCompLen = 16;
        } else if (m < 2305) {
            width = 7;
            reqPreCompLen = 32;
        } else {
            width = 8;
            reqPreCompLen = 127;
        }
        int preCompLen = 1;
        ECPoint[] preComp = wnafPreCompInfo.getPreComp();
        ECPoint twiceP = wnafPreCompInfo.getTwiceP();
        if (preComp == null) {
            preComp = new ECPoint[]{p};
        } else {
            preCompLen = preComp.length;
        }
        if (twiceP == null) {
            twiceP = p.twice();
        }
        if (preCompLen < reqPreCompLen) {
            ECPoint[] oldPreComp = preComp;
            preComp = new ECPoint[reqPreCompLen];
            System.arraycopy(oldPreComp, 0, preComp, 0, preCompLen);
            int i = preCompLen;
            while (i < reqPreCompLen) {
                preComp[i] = twiceP.add(preComp[i - 1]);
                ++i;
            }
        }
        byte[] wnaf = this.windowNaf(width, k);
        int l = wnaf.length;
        ECPoint q = p.getCurve().getInfinity();
        int i = l - 1;
        while (i >= 0) {
            q = q.twice();
            if (wnaf[i] != 0) {
                q = wnaf[i] > 0 ? q.add(preComp[(wnaf[i] - 1) / 2]) : q.subtract(preComp[(-wnaf[i] - 1) / 2]);
            }
            --i;
        }
        wnafPreCompInfo.setPreComp(preComp);
        wnafPreCompInfo.setTwiceP(twiceP);
        p.setPreCompInfo(wnafPreCompInfo);
        return q;
    }
}

