/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.ice4j.Transport;
import org.ice4j.ice.NetworkUtils;

public class TransportAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    private final Transport transport;

    public TransportAddress(String hostname, int port, Transport transport) {
        super(hostname, port);
        this.transport = transport;
    }

    public TransportAddress(byte[] ipAddress, int port, Transport transport) throws UnknownHostException {
        this(InetAddress.getByAddress(ipAddress), port, transport);
    }

    public TransportAddress(InetSocketAddress address, Transport transport) {
        this(address.getAddress(), address.getPort(), transport);
    }

    public TransportAddress(InetAddress address, int port, Transport transport) {
        super(address, port);
        this.transport = transport;
    }

    public byte[] getAddressBytes() {
        return this.getAddress().getAddress();
    }

    public String toString() {
        return super.toString() + "/" + (Object)((Object)this.getTransport());
    }

    public String getHostAddress() {
        InetAddress addr = this.getAddress();
        String addressStr = addr.getHostAddress();
        if (addr instanceof Inet6Address) {
            addressStr = NetworkUtils.stripScopeID(addressStr);
        }
        return addressStr;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public boolean equals(TransportAddress transportAddress) {
        return this.equalsTransportAddress(transportAddress);
    }

    public boolean equalsTransportAddress(Object obj) {
        return super.equals(obj) && ((TransportAddress)obj).getTransport() == this.getTransport();
    }

    public boolean isIPv6() {
        return this.getAddress() instanceof Inet6Address;
    }

    public boolean canReach(TransportAddress dst) {
        if (this.getTransport() != dst.getTransport()) {
            return false;
        }
        if (this.isIPv6() != dst.isIPv6()) {
            return false;
        }
        if (this.isIPv6()) {
            Inet6Address srcAddr = (Inet6Address)this.getAddress();
            Inet6Address dstAddr = (Inet6Address)dst.getAddress();
            if (srcAddr.isLinkLocalAddress() != dstAddr.isLinkLocalAddress()) {
                return Boolean.getBoolean("org.ice4j.ALLOW_LINK_TO_GLOBAL_REACHABILITY");
            }
        }
        return true;
    }
}

