/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.AttributeDecoder;
import org.ice4j.attribute.ChangeRequestAttribute;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.OptionalAttribute;
import org.ice4j.attribute.UnknownAttributesAttribute;

public class AttributeDecoderTest
extends TestCase {
    private MsgFixture msgFixture;
    private byte[] expectedAttributeValue = null;

    public AttributeDecoderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        int offset = 4;
        this.expectedAttributeValue = new byte[this.msgFixture.unknownOptionalAttribute.length - offset];
        System.arraycopy(this.msgFixture.unknownOptionalAttribute, offset, this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeMappedAddress() throws Exception {
        byte[] bytes = this.msgFixture.mappedAddress;
        char offset = '\u0000';
        char length = (char)bytes.length;
        MappedAddressAttribute expectedReturn = new MappedAddressAttribute();
        expectedReturn.setAddress(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904, Transport.UDP));
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a MAPPED-ADDRESS attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeMappedAddress_v6() throws Exception {
        byte[] bytes = this.msgFixture.mappedAddressv6;
        char offset = '\u0000';
        char length = (char)bytes.length;
        MappedAddressAttribute expectedReturn = new MappedAddressAttribute();
        expectedReturn.setAddress(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_V6, 1904, Transport.UDP));
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a MAPPED-ADDRESS attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeChangeRequest() throws Exception {
        byte[] bytes = this.msgFixture.chngReqTestValue1;
        char offset = '\u0000';
        char length = (char)bytes.length;
        ChangeRequestAttribute expectedReturn = new ChangeRequestAttribute();
        expectedReturn.setChangeIpFlag(false);
        expectedReturn.setChangePortFlag(false);
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a CHANGE-REQUEST attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeErrorCode() throws Exception {
        byte[] bytes = this.msgFixture.errCodeTestValue;
        char offset = '\u0000';
        char length = (char)bytes.length;
        ErrorCodeAttribute expectedReturn = new ErrorCodeAttribute();
        expectedReturn.setErrorClass((byte)4);
        expectedReturn.setErrorNumber((byte)20);
        expectedReturn.setReasonPhrase("Test error reason phrase.");
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a ERROR-CODE attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeUnknownAttributes() throws Exception {
        byte[] bytes = this.msgFixture.unknownAttsDecodeTestValue;
        char offset = '\u0000';
        char length = (char)this.msgFixture.mappedAddress.length;
        UnknownAttributesAttribute expectedReturn = new UnknownAttributesAttribute();
        expectedReturn.addAttributeID(' ');
        expectedReturn.addAttributeID('!');
        expectedReturn.addAttributeID('\"');
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a ERROR-CODE attribute", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testDecodeUnknownOptionalAttribute() throws Exception {
        byte[] bytes = this.msgFixture.unknownOptionalAttribute;
        char offset = '\u0000';
        char length = (char)this.msgFixture.mappedAddress.length;
        OptionalAttribute expectedReturn = new OptionalAttribute('\u8000');
        expectedReturn.setBody(this.expectedAttributeValue, 0, this.expectedAttributeValue.length);
        Attribute actualReturn = AttributeDecoder.decode(bytes, offset, length);
        AttributeDecoderTest.assertEquals((String)"AttributeDecoder.decode() failed for a UNKNOWN_OPTIONAL attribute", (Object)expectedReturn, (Object)actualReturn);
    }
}

