/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.util.Comparator;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.stack.TransactionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidatePair
implements Comparable<CandidatePair> {
    private LocalCandidate localCandidate;
    private RemoteCandidate remoteCandidate;
    private long priority;
    private boolean useCandidate = false;
    private boolean useCandidateSent = false;
    private boolean isValid = false;
    private boolean isNominated = false;
    public static final PairComparator comparator = new PairComparator();
    private CandidatePairState state = CandidatePairState.FROZEN;
    private TransactionID connCheckTranID = null;

    public CandidatePair(LocalCandidate localCandidate, RemoteCandidate remoteCandidate) {
        this.localCandidate = localCandidate;
        this.remoteCandidate = remoteCandidate;
        this.computePriority();
    }

    public String getFoundation() {
        return this.localCandidate.getFoundation() + this.remoteCandidate.getFoundation();
    }

    public LocalCandidate getLocalCandidate() {
        return this.localCandidate;
    }

    protected void setLocalCandidate(LocalCandidate localCnd) {
        this.localCandidate = localCnd;
    }

    public RemoteCandidate getRemoteCandidate() {
        return this.remoteCandidate;
    }

    protected void setRemoteCandidate(RemoteCandidate remoteCnd) {
        this.remoteCandidate = remoteCnd;
    }

    public CandidatePairState getState() {
        return this.state;
    }

    public void setStateFailed() {
        this.setState(CandidatePairState.FAILED, null);
    }

    public void setStateFrozen() {
        this.setState(CandidatePairState.FROZEN, null);
    }

    public void setStateInProgress(TransactionID tranID) {
        this.setState(CandidatePairState.IN_PROGRESS, tranID);
    }

    public void setStateSucceeded() {
        this.setState(CandidatePairState.SUCCEEDED, null);
    }

    public void setStateWaiting() {
        this.setState(CandidatePairState.WAITING, null);
    }

    private synchronized void setState(CandidatePairState newState, TransactionID tranID) throws IllegalArgumentException {
        CandidatePairState oldState = this.state;
        this.state = newState;
        if (newState != CandidatePairState.IN_PROGRESS) {
            if (tranID != null) {
                throw new IllegalArgumentException("How could you have a transaction for a pair that's not in the In-Progress state?");
            }
        } else if (tranID == null) {
            throw new IllegalArgumentException("Putting a pair into the In-Progress state MUST be accomapnied with the TransactionID of the conn check.");
        }
        this.connCheckTranID = tranID;
        this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairStateChanged", (Object)oldState, (Object)newState);
    }

    public boolean isFrozen() {
        return this.getState().equals((Object)CandidatePairState.FROZEN);
    }

    public Candidate getControllingAgentCandidate() {
        return this.getLocalCandidate().getParentComponent().getParentStream().getParentAgent().isControlling() ? this.getLocalCandidate() : this.getRemoteCandidate();
    }

    public Candidate getControlledAgentCandidate() {
        return this.getLocalCandidate().getParentComponent().getParentStream().getParentAgent().isControlling() ? this.getRemoteCandidate() : this.getLocalCandidate();
    }

    protected void computePriority() {
        long G = this.getControllingAgentCandidate().getPriority();
        long D = this.getControlledAgentCandidate().getPriority();
        this.priority = (long)Math.pow(2.0, 32.0) * Math.min(G, D) + 2L * Math.max(G, D) + (G > D ? 1L : 0L);
    }

    public long getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(CandidatePair candidatePair) {
        long otherPri;
        long thisPri = this.getPriority();
        return thisPri < (otherPri = candidatePair.getPriority()) ? 1 : (thisPri == otherPri ? 0 : -1);
    }

    public boolean equals(Object targetPair) {
        return targetPair instanceof CandidatePair && targetPair != null && this.localCandidate.equals(((CandidatePair)targetPair).localCandidate) && this.remoteCandidate.equals(((CandidatePair)targetPair).remoteCandidate);
    }

    public String toString() {
        return "CandidatePair (State=" + (Object)((Object)this.getState()) + " Priority=" + this.getPriority() + "):\n\tLocalCandidate=" + this.getLocalCandidate() + "\n\tRemoteCandidate=" + this.getRemoteCandidate();
    }

    public String toShortString() {
        return this.getLocalCandidate().getTransportAddress() + " -> " + this.getRemoteCandidate().getTransportAddress() + " (" + this.getParentComponent().toShortString() + ")";
    }

    public Component getParentComponent() {
        return this.getLocalCandidate().getParentComponent();
    }

    public TransactionID getConnectivityCheckTransaction() {
        return this.connCheckTranID;
    }

    public void setUseCandidateSent() {
        this.useCandidateSent = true;
    }

    public boolean useCandidateSent() {
        return this.useCandidateSent;
    }

    public void setUseCandidateReceived() {
        this.useCandidate = true;
    }

    public boolean useCandidateReceived() {
        return this.useCandidate;
    }

    public void nominate() {
        this.isNominated = true;
        this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairNominated", false, true);
    }

    public boolean isNominated() {
        return this.isNominated;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void validate() {
        this.isValid = true;
        this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairValidated", false, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PairComparator
    implements Comparator<CandidatePair> {
        @Override
        public int compare(CandidatePair pair1, CandidatePair pair2) {
            return pair1.compareTo(pair2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PairComparator;
        }
    }
}

