/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateHarvesterSet
extends AbstractSet<CandidateHarvester> {
    private static final Logger logger = Logger.getLogger(CandidateHarvesterSet.class.getName());
    private final Collection<CandidateHarvesterSetElement> elements = new LinkedList<CandidateHarvesterSetElement>();
    private static ExecutorService threadPool = Executors.newCachedThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(CandidateHarvester harvester) {
        Collection<CandidateHarvesterSetElement> collection = this.elements;
        synchronized (collection) {
            for (CandidateHarvesterSetElement element : this.elements) {
                if (!element.harvesterEquals(harvester)) continue;
                return false;
            }
            this.elements.add(new CandidateHarvesterSetElement(harvester));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void harvest(Component component) {
        Collection<CandidateHarvesterSetElement> collection = this.elements;
        synchronized (collection) {
            this.harvest(this.elements.iterator(), component, threadPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void harvest(final Iterator<CandidateHarvesterSetElement> harvesters, final Component component, ExecutorService executorService) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class CandidateHarvesterSetTask
        implements Runnable {
            private CandidateHarvesterSetElement harvester;

            public CandidateHarvesterSetTask(CandidateHarvesterSetElement harvester) {
                this.harvester = harvester;
            }

            public CandidateHarvesterSetElement getHarvester() {
                return this.harvester;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    block8: {
                        if (this.harvester.isEnabled()) {
                            try {
                                this.harvester.harvest(component);
                            }
                            catch (Throwable t) {
                                logger.info("disabling harvester due to exception: " + t.getLocalizedMessage());
                                this.harvester.setEnabled(false);
                                if (!(t instanceof ThreadDeath)) break block8;
                                throw (ThreadDeath)t;
                            }
                        }
                    }
                    this.harvester = null;
                    Iterator iterator = harvesters;
                    synchronized (iterator) {
                        if (!harvesters.hasNext()) {
                            break;
                        }
                        this.harvester = (CandidateHarvesterSetElement)harvesters.next();
                    }
                }
            }
        }
        Object task;
        HashMap tasks = new HashMap();
        while (true) {
            CandidateHarvesterSetElement harvester;
            Iterator<CandidateHarvesterSetElement> iterator = harvesters;
            synchronized (iterator) {
                if (!harvesters.hasNext()) {
                    break;
                }
                harvester = harvesters.next();
            }
            if (!harvester.isEnabled()) continue;
            task = new CandidateHarvesterSetTask(harvester);
            tasks.put(task, executorService.submit((Runnable)task));
        }
        Iterator taskIter = tasks.entrySet().iterator();
        while (taskIter.hasNext()) {
            task = taskIter.next();
            Future future = (Future)task.getValue();
            while (true) {
                try {
                    future.get();
                }
                catch (CancellationException ce) {
                    logger.info("harvester cancelled");
                }
                catch (ExecutionException ee) {
                    logger.info("disabling harvester due to ExecutionException: " + ee.getLocalizedMessage());
                    CandidateHarvesterSetElement harvester = ((CandidateHarvesterSetTask)task.getKey()).getHarvester();
                    if (harvester == null) break;
                    harvester.setEnabled(false);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                break;
            }
            taskIter.remove();
        }
    }

    @Override
    public Iterator<CandidateHarvester> iterator() {
        final Iterator<CandidateHarvesterSetElement> elementIter = this.elements.iterator();
        return new Iterator<CandidateHarvester>(){

            @Override
            public boolean hasNext() {
                return elementIter.hasNext();
            }

            @Override
            public CandidateHarvester next() throws NoSuchElementException {
                return ((CandidateHarvesterSetElement)elementIter.next()).harvester;
            }

            @Override
            public void remove() throws IllegalStateException, UnsupportedOperationException {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Collection<CandidateHarvesterSetElement> collection = this.elements;
        synchronized (collection) {
            return this.elements.size();
        }
    }

    private static class CandidateHarvesterSetElement {
        private boolean enabled = true;
        private final CandidateHarvester harvester;

        public CandidateHarvesterSetElement(CandidateHarvester harvester) {
            this.harvester = harvester;
        }

        public void harvest(Component component) {
            if (this.isEnabled()) {
                this.harvester.startHarvesting();
                Collection<LocalCandidate> candidates = this.harvester.harvest(component);
                this.harvester.stopHarvesting();
                logger.info("End candidate harvest within " + this.harvester.getHarvestingTime() + " ms, for " + this.harvester.getClass().getName() + ", component: " + component.getComponentID());
                if (candidates == null || candidates.isEmpty()) {
                    this.setEnabled(false);
                }
            }
        }

        public boolean harvesterEquals(CandidateHarvester harvester) {
            return this.harvester.equals(harvester);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            logger.info("disabling harvester: " + this.harvester);
            this.enabled = enabled;
        }
    }
}

