/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.ResponseCollector;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.StunResponseEvent;
import org.ice4j.StunTimeoutEvent;
import org.ice4j.TransportAddress;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

class StunClientTransaction
implements Runnable {
    private static final Logger logger = Logger.getLogger(StunClientTransaction.class.getName());
    public static final int DEFAULT_MAX_RETRANSMISSIONS = 6;
    public int maxRetransmissions = 6;
    public static final int DEFAULT_ORIGINAL_WAIT_INTERVAL = 100;
    public int originalWaitInterval = 100;
    public static final int DEFAULT_MAX_WAIT_INTERVAL = 1600;
    public int maxWaitInterval = 1600;
    private int retransmissionCounter = 0;
    private int nextWaitInterval = this.originalWaitInterval;
    private final StunStack stackCallback;
    private final Request request;
    private final TransportAddress requestDestination;
    private final TransactionID transactionID;
    private final TransportAddress localAddress;
    private final ResponseCollector responseCollector;
    private boolean cancelled = false;
    private Thread retransmissionsThread = null;

    public StunClientTransaction(StunStack stackCallback, Request request, TransportAddress requestDestination, TransportAddress localAddress, ResponseCollector responseCollector) {
        this(stackCallback, request, requestDestination, localAddress, responseCollector, TransactionID.createNewTransactionID());
    }

    public StunClientTransaction(StunStack stackCallback, Request request, TransportAddress requestDestination, TransportAddress localAddress, ResponseCollector responseCollector, TransactionID transactionID) {
        this.stackCallback = stackCallback;
        this.request = request;
        this.localAddress = localAddress;
        this.responseCollector = responseCollector;
        this.requestDestination = requestDestination;
        this.initTransactionConfiguration();
        this.transactionID = transactionID;
        try {
            request.setTransactionID(transactionID.getBytes());
        }
        catch (StunException ex) {
            throw new IllegalArgumentException("The TransactionID class generated an invalid transaction ID");
        }
        this.retransmissionsThread = new Thread((Runnable)this, "StunClientTransaction@" + this.hashCode());
        this.retransmissionsThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.retransmissionsThread.setName("ice4j.ClientTransaction");
        this.nextWaitInterval = this.originalWaitInterval;
        StunClientTransaction stunClientTransaction = this;
        synchronized (stunClientTransaction) {
            this.retransmissionCounter = 0;
            while (this.retransmissionCounter < this.maxRetransmissions) {
                this.waitFor(this.nextWaitInterval);
                if (this.cancelled) {
                    return;
                }
                if (this.nextWaitInterval < this.maxWaitInterval) {
                    this.nextWaitInterval *= 2;
                }
                try {
                    logger.fine("retrying transmission of STUN test to " + this.requestDestination.getHostAddress());
                    this.sendRequest0();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "A client tran retransmission failed", ex);
                }
                ++this.retransmissionCounter;
            }
            if (this.nextWaitInterval < this.maxWaitInterval) {
                this.nextWaitInterval *= 2;
            }
            this.waitFor(this.nextWaitInterval);
            if (this.cancelled) {
                return;
            }
            this.stackCallback.removeClientTransaction(this);
            this.responseCollector.processTimeout(new StunTimeoutEvent(this.stackCallback, this.request, this.getLocalAddress(), this.transactionID));
        }
    }

    void sendRequest() throws IllegalArgumentException, IOException {
        this.sendRequest0();
        this.retransmissionsThread.start();
    }

    private void sendRequest0() throws IllegalArgumentException, IOException {
        if (this.cancelled) {
            logger.finer("Trying to resend a cancelled transaction.");
            return;
        }
        this.stackCallback.getNetAccessManager().sendMessage(this.request, this.localAddress, this.requestDestination);
    }

    Request getRequest() {
        return this.request;
    }

    void waitFor(long millis) {
        try {
            this.wait(millis);
        }
        catch (InterruptedException ex) {
            logger.log(Level.FINE, "Interrupted", ex);
        }
    }

    synchronized void cancel(boolean waitForResponse) {
        this.cancelled = true;
        if (!waitForResponse) {
            this.notifyAll();
        }
    }

    synchronized void cancel() {
        this.cancel(false);
    }

    synchronized void handleResponse(StunMessageEvent evt) {
        if (!Boolean.getBoolean("org.ice4j.KEEP_CRANS_AFTER_A_RESPONSE")) {
            this.cancel();
        }
        this.responseCollector.processResponse(new StunResponseEvent(this.stackCallback, evt.getRawMessage(), (Response)evt.getMessage(), this.request, this.getTransactionID()));
    }

    TransactionID getTransactionID() {
        return this.transactionID;
    }

    private void initTransactionConfiguration() {
        String maxWaitIntervalStr;
        String originalWaitIntervalStr;
        String maxRetransmissionsStr = System.getProperty("org.ice4j.MAX_RETRANSMISSIONS");
        if (maxRetransmissionsStr != null && maxRetransmissionsStr.trim().length() > 0) {
            try {
                this.maxRetransmissions = Integer.parseInt(maxRetransmissionsStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_RETRANSMISSIONS", e);
                this.maxRetransmissions = 6;
            }
        }
        if ((originalWaitIntervalStr = System.getProperty("org.ice4j.FIRST_CTRAN_RETRANS_AFTER")) != null && originalWaitIntervalStr.trim().length() > 0) {
            try {
                this.originalWaitInterval = Integer.parseInt(originalWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse ORIGINAL_WAIT_INTERVAL", e);
                this.originalWaitInterval = 100;
            }
        }
        if ((maxWaitIntervalStr = System.getProperty("org.ice4j.MAX_CTRAN_RETRANS_TIMER")) != null && maxWaitIntervalStr.trim().length() > 0) {
            try {
                this.maxWaitInterval = Integer.parseInt(maxWaitIntervalStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.FINE, "Failed to parse MAX_WAIT_INTERVAL", e);
                this.maxWaitInterval = 1600;
            }
        }
    }

    public TransportAddress getLocalAddress() {
        return this.localAddress;
    }

    public TransportAddress getRemoteAddress() {
        return this.requestDestination;
    }
}

