/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.StringBlock;
import org.jetbrains.annotations.Nullable;

public final class BinaryTools {
    public static final long UINT_MAX = 0xFFFFFFFFL;
    public static final int USHORT_MAX = 65535;
    public static final short UBYTE_MAX = 255;

    private BinaryTools() {
    }

    public static long getLong(ByteBlock byteBlock, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        long l = 0L;
        int n3 = n2 + 8;
        for (n2 = n; n2 < n3; ++n2) {
            int n4 = (n3 - n2 - 1) * 8;
            l |= ((long)byteBlock.get(n2) & 0xFFL) << n4;
        }
        return l;
    }

    public static long getUInt(ByteBlock byteBlock, int n) {
        if (byteBlock.getLength() - n < 4) {
            return -1L;
        }
        return ((long)byteBlock.get(n) & 0xFFL) << 24 | ((long)byteBlock.get(n + 1) & 0xFFL) << 16 | ((long)byteBlock.get(n + 2) & 0xFFL) << 8 | (long)byteBlock.get(n + 3) & 0xFFL;
    }

    public static int getUShort(ByteBlock byteBlock, int n) {
        if (byteBlock.getLength() - n < 2) {
            return -1;
        }
        return (byteBlock.get(n) & 0xFF) << 8 | byteBlock.get(n + 1) & 0xFF;
    }

    public static short getUByte(ByteBlock byteBlock, int n) {
        if (byteBlock.getLength() - n < 1) {
            return -1;
        }
        return (short)(byteBlock.get(n) & 0xFF);
    }

    @Nullable
    public static Inet4Address getIPFromBytes(ByteBlock byteBlock, int n) {
        if (byteBlock.getLength() - n < 4) {
            return null;
        }
        byte[] byArray = byteBlock.subBlock(n, 4).toByteArray();
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)Inet4Address.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inet4Address;
    }

    public static String describeData(ByteBlock byteBlock) {
        if (byteBlock == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byteBlock.getLength(); ++i) {
            String string;
            byte by = byteBlock.get(i);
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if ((string = Integer.toHexString(by & 0xFF)).length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void writeLong(OutputStream outputStream, long l) throws IOException {
        outputStream.write(BinaryTools.getLong(l));
    }

    public static void writeUInt(OutputStream outputStream, long l) throws IOException {
        outputStream.write(BinaryTools.getUInt(l));
    }

    public static void writeUShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(BinaryTools.getUShort(n));
    }

    public static void writeUByte(OutputStream outputStream, int n) throws IOException {
        outputStream.write(BinaryTools.getUByte(n));
    }

    public static byte[] getLong(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int n = (7 - i) * 8;
            byArray[i] = (byte)(l >> n & 0xFFL);
        }
        return byArray;
    }

    public static byte[] getUInt(long l) {
        return new byte[]{(byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
    }

    public static byte[] getUShort(int n) {
        return new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
    }

    public static byte[] getUByte(int n) {
        return new byte[]{BinaryTools.getSingleUByte(n)};
    }

    public static byte getSingleUByte(int n) {
        return (byte)(n & 0xFF);
    }

    public static byte[] getLatinBytes(String string) {
        try {
            return string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] getAsciiBytes(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String getAsciiString(ByteBlock byteBlock) {
        try {
            return ByteBlock.createString(byteBlock, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static byte[] getUtf8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static String getUtf8String(ByteBlock byteBlock) {
        try {
            return ByteBlock.createString(byteBlock, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static StringBlock getNullPadded(ByteBlock byteBlock) {
        int n;
        for (n = 0; n < byteBlock.getLength() && byteBlock.get(n) != 0; ++n) {
        }
        ByteBlock byteBlock2 = byteBlock.subBlock(0, n);
        return new StringBlock(BinaryTools.getAsciiString(byteBlock2), byteBlock2.getLength());
    }

    public static void writeNullPadded(OutputStream outputStream, ByteBlock byteBlock, int n) throws IOException {
        if (byteBlock.getLength() <= n) {
            byteBlock.write(outputStream);
            outputStream.write(new byte[n - byteBlock.getLength()]);
        } else {
            byteBlock.subBlock(0, n).write(outputStream);
        }
    }

    public static ByteBlock getMD5(ByteBlock byteBlock) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnknownError("no such algorithm: MD5");
        }
        return ByteBlock.wrap(messageDigest.digest(byteBlock.toByteArray()));
    }
}

