/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.tls.SecurityParameters;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsStreamCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected StreamCipher encryptCipher;
    protected StreamCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsStreamCipher(TlsClientContext tlsClientContext, StreamCipher streamCipher, StreamCipher streamCipher2, Digest digest, Digest digest2, int n) throws IOException {
        this.context = tlsClientContext;
        this.encryptCipher = streamCipher;
        this.decryptCipher = streamCipher2;
        int n2 = 2 * n + digest.getDigestSize() + digest2.getDigestSize();
        SecurityParameters securityParameters = tlsClientContext.getSecurityParameters();
        byte[] byArray = TlsUtils.PRF(securityParameters.masterSecret, "key expansion", TlsUtils.concat(securityParameters.serverRandom, securityParameters.clientRandom), n2);
        int n3 = 0;
        this.writeMac = new TlsMac(tlsClientContext, digest, byArray, n3, digest.getDigestSize());
        this.readMac = new TlsMac(tlsClientContext, digest2, byArray, n3 += digest.getDigestSize(), digest2.getDigestSize());
        KeyParameter keyParameter = new KeyParameter(byArray, n3 += digest2.getDigestSize(), n);
        KeyParameter keyParameter2 = new KeyParameter(byArray, n3 += n, n);
        if ((n3 += n) != n2) {
            throw new TlsFatalAlert(80);
        }
        streamCipher.init(true, keyParameter);
        streamCipher2.init(true, keyParameter2);
    }

    public byte[] encodePlaintext(short s, byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.writeMac.calculateMac(s, byArray, n, n2);
        byte[] byArray3 = new byte[n2 + byArray2.length];
        this.encryptCipher.processBytes(byArray, n, n2, byArray3, 0);
        this.encryptCipher.processBytes(byArray2, 0, byArray2.length, byArray3, n2);
        return byArray3;
    }

    public byte[] decodeCiphertext(short s, byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        this.decryptCipher.processBytes(byArray, n, n2, byArray2, 0);
        int n3 = byArray2.length - this.readMac.getSize();
        byte[] byArray3 = this.copyData(byArray2, 0, n3);
        byte[] byArray4 = this.copyData(byArray2, n3, this.readMac.getSize());
        byte[] byArray5 = this.readMac.calculateMac(s, byArray3, 0, byArray3.length);
        if (!Arrays.constantTimeAreEqual(byArray4, byArray5)) {
            throw new TlsFatalAlert(20);
        }
        return byArray3;
    }

    protected byte[] copyData(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }
}

