/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.crypto;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.crypto.OtrCryptoException;

public interface OtrCryptoEngine {
    public static final String MODULUS_TEXT = "00FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF";
    public static final BigInteger MODULUS = new BigInteger("00FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger BIGINTEGER_TWO = BigInteger.valueOf(2L);
    public static final BigInteger MODULUS_MINUS_TWO = MODULUS.subtract(BIGINTEGER_TWO);
    public static final String GENERATOR_TEXT = "2";
    public static final BigInteger GENERATOR = new BigInteger("2", 10);
    public static final int AES_KEY_BYTE_LENGTH = 16;
    public static final int SHA256_HMAC_KEY_BYTE_LENGTH = 32;
    public static final int DH_PRIVATE_KEY_MINIMUM_BIT_LENGTH = 320;
    public static final byte[] ZERO_CTR = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int DSA_PUB_TYPE = 0;

    public KeyPair generateDHKeyPair() throws OtrCryptoException;

    public DHPublicKey getDHPublicKey(byte[] var1) throws OtrCryptoException;

    public DHPublicKey getDHPublicKey(BigInteger var1) throws OtrCryptoException;

    public byte[] sha256Hmac(byte[] var1, byte[] var2) throws OtrCryptoException;

    public byte[] sha256Hmac(byte[] var1, byte[] var2, int var3) throws OtrCryptoException;

    public byte[] sha1Hmac(byte[] var1, byte[] var2, int var3) throws OtrCryptoException;

    public byte[] sha256Hmac160(byte[] var1, byte[] var2) throws OtrCryptoException;

    public byte[] sha256Hash(byte[] var1) throws OtrCryptoException;

    public byte[] sha1Hash(byte[] var1) throws OtrCryptoException;

    public byte[] aesDecrypt(byte[] var1, byte[] var2, byte[] var3) throws OtrCryptoException;

    public byte[] aesEncrypt(byte[] var1, byte[] var2, byte[] var3) throws OtrCryptoException;

    public BigInteger generateSecret(PrivateKey var1, PublicKey var2) throws OtrCryptoException;

    public byte[] sign(byte[] var1, PrivateKey var2) throws OtrCryptoException;

    public boolean verify(byte[] var1, PublicKey var2, byte[] var3) throws OtrCryptoException;

    public String getFingerprint(PublicKey var1) throws OtrCryptoException;
}

