/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.io.SerializationConstants;
import net.java.otr4j.io.messages.MysteriousT;
import net.java.otr4j.io.messages.SignatureM;
import net.java.otr4j.io.messages.SignatureX;
import org.bouncycastle.util.BigIntegers;

public class OtrOutputStream
extends FilterOutputStream
implements SerializationConstants {
    public OtrOutputStream(OutputStream out) {
        super(out);
    }

    private void writeNumber(int value, int length) throws IOException {
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        this.write(b);
    }

    public void writeBigInt(BigInteger bi) throws IOException {
        byte[] b = BigIntegers.asUnsignedByteArray((BigInteger)bi);
        this.writeData(b);
    }

    public void writeByte(int b) throws IOException {
        this.writeNumber(b, 1);
    }

    public void writeData(byte[] b) throws IOException {
        int len = b == null || b.length < 0 ? 0 : b.length;
        this.writeNumber(len, 4);
        if (len > 0) {
            this.write(b);
        }
    }

    public void writeInt(int i) throws IOException {
        this.writeNumber(i, 4);
    }

    public void writeShort(int s) throws IOException {
        this.writeNumber(s, 2);
    }

    public void writeMac(byte[] mac) throws IOException {
        if (mac == null || mac.length != 20) {
            throw new IllegalArgumentException();
        }
        this.write(mac);
    }

    public void writeCtr(byte[] ctr) throws IOException {
        if (ctr == null || ctr.length < 1) {
            return;
        }
        for (int i = 0; i < 8 && i < ctr.length; ++i) {
            this.write(ctr[i]);
        }
    }

    public void writeDHPublicKey(DHPublicKey dhPublicKey) throws IOException {
        byte[] b = BigIntegers.asUnsignedByteArray((BigInteger)dhPublicKey.getY());
        this.writeData(b);
    }

    public void writePublicKey(PublicKey pubKey) throws IOException {
        if (!(pubKey instanceof DSAPublicKey)) {
            throw new UnsupportedOperationException("Key types other than DSA are not supported at the moment.");
        }
        DSAPublicKey dsaKey = (DSAPublicKey)pubKey;
        this.writeShort(0);
        DSAParams dsaParams = dsaKey.getParams();
        this.writeBigInt(dsaParams.getP());
        this.writeBigInt(dsaParams.getQ());
        this.writeBigInt(dsaParams.getG());
        this.writeBigInt(dsaKey.getY());
    }

    public void writeTlvData(byte[] b) throws IOException {
        int len = b == null || b.length < 0 ? 0 : b.length;
        this.writeNumber(len, 2);
        if (len > 0) {
            this.write(b);
        }
    }

    public void writeSignature(byte[] signature, PublicKey pubKey) throws IOException {
        if (!pubKey.getAlgorithm().equals("DSA")) {
            throw new UnsupportedOperationException();
        }
        this.out.write(signature);
    }

    public void writeMysteriousX(SignatureX x) throws IOException {
        this.writePublicKey(x.longTermPublicKey);
        this.writeInt(x.dhKeyID);
        this.writeSignature(x.signature, x.longTermPublicKey);
    }

    public void writeMysteriousX(SignatureM m) throws IOException {
        this.writeBigInt(m.localPubKey.getY());
        this.writeBigInt(m.remotePubKey.getY());
        this.writePublicKey(m.localLongTermPubKey);
        this.writeInt(m.keyPairID);
    }

    public void writeMysteriousT(MysteriousT t) throws IOException {
        this.writeShort(t.protocolVersion);
        this.writeByte(t.messageType);
        this.writeByte(t.flags);
        this.writeInt(t.senderKeyID);
        this.writeInt(t.recipientKeyID);
        this.writeDHPublicKey(t.nextDH);
        this.writeCtr(t.ctr);
        this.writeData(t.encryptedMessage);
    }
}

