/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.profiler4j.agent.Agent;
import net.sf.profiler4j.agent.CFlow;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.Profiler4JError;
import net.sf.profiler4j.agent.Transformer;

public class ThreadProfiler {
    private static volatile boolean enabled = true;
    public static final int SNAPSHOT_MAGIC = -1162163712;
    public static final int SNAPSHOT_PROTOCOL_VERSION = 1;
    public static final int SNAPSHOT_TYPE_CALLTRACE = 1;
    private static final int MAX_METHODS = 65535;
    private static final int MAX_CALL_DEPTH = 1024;
    private static final int INITIAL_CHILDREN_PER_METHOD = 8;
    static final Object globalLock = new GlobalLock();
    public static volatile int sessionId = 0;
    private static int methodCount = 0;
    private static final MethodGroup[] globalMethods = new MethodGroup[65535];
    private static final Map<Thread, ThreadProfiler> globalThreadInfos = new HashMap<Thread, ThreadProfiler>();
    private static final Object rl = new Object();
    private static ThreadGroup systemThreadGroup;
    private int depth = 0;
    private long[] startTimes = new long[1024];
    private MethodGroup[] stack = new MethodGroup[1024];
    private Thread thread = Thread.currentThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int newMethod(String methodName) {
        Object object = globalLock;
        synchronized (object) {
            int globalMethodId = sessionId << 16 | methodCount;
            ThreadProfiler.globalMethods[ThreadProfiler.methodCount++] = new MethodGroup(globalMethodId, methodName);
            if (methodCount >= globalMethods.length) {
                throw new Profiler4JError("[CRITICAL] Reached limit of traced methods");
            }
            return globalMethodId;
        }
    }

    public static int getSessionId() {
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enterMethod(int globalMethodId) {
        Thread ct = Thread.currentThread();
        if (ct == Agent.server || Thread.holdsLock(rl) || Thread.holdsLock(globalLock) || ct.getThreadGroup() == systemThreadGroup || ct == Transformer.transformerThread) {
            return;
        }
        if (!enabled) {
            return;
        }
        Object object = globalLock;
        synchronized (object) {
            int sessionIdOfMethod = globalMethodId >> 16;
            if (sessionIdOfMethod != sessionId) {
                return;
            }
            int mid = globalMethodId & 0xFFFF;
            ThreadProfiler ti = null;
            Object object2 = rl;
            synchronized (object2) {
                ti = globalThreadInfos.get(ct);
                if (ti == null) {
                    ti = new ThreadProfiler();
                    globalThreadInfos.put(ct, ti);
                }
            }
            ti.enter0(globalMethods[mid]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exitMethod(int globalMethodId) {
        Thread ct = Thread.currentThread();
        if (ct == Agent.server || Thread.holdsLock(rl) || Thread.holdsLock(globalLock) || ct.getThreadGroup() == systemThreadGroup || ct == Transformer.transformerThread) {
            return;
        }
        if (!enabled) {
            return;
        }
        Object object = globalLock;
        synchronized (object) {
            int sessionIdOfMethod = globalMethodId >> 16;
            if (sessionIdOfMethod != sessionId) {
                return;
            }
            ThreadProfiler ti = null;
            Object object2 = rl;
            synchronized (object2) {
                ti = globalThreadInfos.get(ct);
            }
            if (ti != null) {
                ti.exit0();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSessionConfig() {
        Object object = globalLock;
        synchronized (object) {
            enabled = false;
            for (int i = 0; i < methodCount; ++i) {
                ThreadProfiler.globalMethods[i] = null;
            }
            methodCount = 0;
            sessionId = sessionId + 1 & 0xFF;
            Log.print(0, "Starting new session: sessionId=" + sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endSessionConfig() {
        Object object = globalLock;
        synchronized (object) {
            Iterator<ThreadProfiler> i$ = globalThreadInfos.values().iterator();
            while (i$.hasNext()) {
                ThreadProfiler ti;
                ThreadProfiler threadProfiler = ti = i$.next();
                synchronized (threadProfiler) {
                    ti.depth = 0;
                }
            }
            globalThreadInfos.clear();
            enabled = true;
            Log.print(0, "Completed session configuration");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStats() {
        Object object = globalLock;
        synchronized (object) {
            for (MethodGroup m : globalMethods) {
                if (m == null) break;
                m.selfTime = 0L;
                m.netTime = 0L;
                m.childRecursiveTime = 0L;
                m.hits = 0;
                for (int i = 0; i < m.childCount; ++i) {
                    m.children[i] = null;
                    m.childrenTimes[i] = 0L;
                }
                m.childCount = 0;
            }
            for (ThreadProfiler ti : globalThreadInfos.values()) {
                for (int i = 0; i < ti.depth; ++i) {
                    ti.startTimes[i] = System.nanoTime();
                }
            }
        }
    }

    private ThreadProfiler() {
    }

    private void enter0(MethodGroup m) {
        try {
            CFlow.ThreadLocalMethod tlm = (CFlow.ThreadLocalMethod)m.cflow.get();
            if (tlm.enter() == 1) {
                this.startTimes[this.depth] = System.nanoTime();
            }
            this.stack[this.depth++] = m;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            enabled = false;
            for (int i = 0; i < this.depth; ++i) {
                System.err.format("[%4d] %s\n", i, this.stack[i].name);
            }
            throw e;
        }
    }

    public final void exit0() {
        if (this.depth == 0) {
            return;
        }
        --this.depth;
        MethodGroup m = this.stack[this.depth];
        CFlow.ThreadLocalMethod tlm = (CFlow.ThreadLocalMethod)m.cflow.get();
        if (tlm.leave() > 0) {
            return;
        }
        long t = System.nanoTime();
        long netTime = t - this.startTimes[this.depth];
        ++m.hits;
        m.netTime += netTime;
        if (this.depth > 0) {
            MethodGroup pm = this.stack[this.depth - 1];
            pm.addChildTime(m, netTime);
        }
    }

    private static void exitWholeStack(ThreadProfiler ti, MethodGroup[] globalMethods_) {
        int depth_ = ti.depth;
        long t = System.nanoTime();
        while (depth_ > 0) {
            long netTime = t - ti.startTimes[--depth_];
            MethodGroup m = ti.stack[depth_];
            ++m.hits;
            m.netTime += netTime;
            if (depth_ <= 0) continue;
            MethodGroup pm = ti.stack[depth_ - 1];
            pm.addChildTime(m, netTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSnapshot(OutputStream os) throws IOException {
        MethodGroup[] methods_ = null;
        Object object = globalLock;
        synchronized (object) {
            methods_ = new MethodGroup[methodCount];
            for (int i = 0; i < methodCount; ++i) {
                methods_[i] = new MethodGroup(globalMethods[i]);
            }
            for (ThreadProfiler ti : globalThreadInfos.values()) {
                if (!ti.thread.isAlive()) continue;
                ThreadProfiler.exitWholeStack(ti, methods_);
            }
            BufferedOutputStream bos = new BufferedOutputStream(os);
            DataOutputStream dos = new DataOutputStream(bos);
            ThreadProfiler.serialize(dos, methods_);
            dos.flush();
        }
    }

    private static void serialize(DataOutputStream out, MethodGroup[] methods) throws IOException {
        out.writeInt(-1162163712);
        out.writeInt(1);
        out.writeInt(1);
        out.writeInt(sessionId);
        out.writeLong(System.currentTimeMillis());
        int n = 0;
        for (MethodGroup m : methods) {
            if (m.hits <= 0) continue;
            ++n;
        }
        Log.print(0, "Retrieving " + n + " methods");
        out.writeInt(n);
        for (MethodGroup m : methods) {
            if (m.hits == 0) continue;
            out.writeInt(m.globalId & 0xFFFF);
            out.writeUTF(m.name);
            out.writeInt(m.hits);
            out.writeLong(m.netTime);
            out.writeLong(m.selfTime);
            out.writeInt(m.childCount);
            for (int i = 0; i < m.childCount; ++i) {
                out.writeInt(m.children[i].globalId & 0xFFFF);
                out.writeLong(m.childrenTimes[i]);
            }
        }
    }

    static {
        for (Thread t : Thread.getAllStackTraces().keySet()) {
            if (!t.getThreadGroup().getName().equals("system")) continue;
            systemThreadGroup = t.getThreadGroup();
            break;
        }
        if (systemThreadGroup == null) {
            throw new Profiler4JError("[CRITICAL] Could not determine system thread group");
        }
    }

    private static class MethodGroup {
        public int globalId;
        public String name;
        public long netTime;
        public long childRecursiveTime;
        public long selfTime;
        public int hits;
        public int childCount;
        public MethodGroup[] children = new MethodGroup[8];
        public long[] childrenTimes = new long[8];
        public CFlow cflow = new CFlow();

        public MethodGroup(int composedId, String name) {
            this.globalId = composedId;
            this.name = name;
        }

        public MethodGroup(MethodGroup m) {
            this.globalId = m.globalId;
            this.name = m.name;
            this.netTime = m.netTime;
            this.selfTime = m.selfTime;
            this.hits = m.hits;
            this.childCount = m.childCount;
            this.children = new MethodGroup[m.children.length];
            System.arraycopy(m.children, 0, this.children, 0, m.childCount);
            this.childrenTimes = new long[m.childrenTimes.length];
            System.arraycopy(m.childrenTimes, 0, this.childrenTimes, 0, m.childCount);
        }

        public void addChildTime(MethodGroup child, long time) {
            int index = -1;
            for (int i = 0; i < this.childCount; ++i) {
                if (this.children[i] != child) continue;
                index = i;
                break;
            }
            if (index == -1) {
                if (this.childCount == this.children.length) {
                    int newChildCount = this.childCount + (this.childCount >> 1);
                    MethodGroup[] oldChildren = this.children;
                    this.children = new MethodGroup[newChildCount];
                    System.arraycopy(oldChildren, 0, this.children, 0, this.childCount);
                    long[] oldChildrenTimes = this.childrenTimes;
                    this.childrenTimes = new long[newChildCount];
                    System.arraycopy(oldChildrenTimes, 0, this.childrenTimes, 0, this.childCount);
                }
                this.children[this.childCount] = child;
                index = this.childCount++;
            }
            int n = index;
            this.childrenTimes[n] = this.childrenTimes[n] + time;
        }

        public void reset() {
            this.hits = 0;
            this.netTime = 0L;
            this.selfTime = 0L;
        }

        public boolean equals(Object obj) {
            return this.globalId == ((MethodGroup)obj).globalId;
        }

        public int hashCode() {
            return this.globalId;
        }
    }

    private static class GlobalLock {
        private GlobalLock() {
        }
    }
}

