/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.profiler4j.console.MethodView;
import net.sf.profiler4j.console.util.hover.HoverWindow;

public class MethodBoxHoverWindow
extends HoverWindow {
    private JLabel[] labels;
    private Font boldFont = new Font("Monospaced", 1, 12);
    private Font plainFont = new Font("Monospaced", 0, 12);
    private Color bgColor = Color.decode("#ffffaa");
    private JPanel panel;

    public MethodBoxHoverWindow() {
        this.setLayout(new BorderLayout());
        this.setAlwaysOnTop(true);
        this.panel = new JPanel(new GridLayout(7, 1));
        this.add((Component)this.panel, "Center");
        this.panel.setBackground(this.bgColor);
        this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.labels = new JLabel[7];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel();
            this.labels[i].setFont(this.plainFont);
            this.panel.add(this.labels[i]);
        }
        this.labels[0].setFont(this.boldFont);
        this.labels[4].setFont(this.boldFont);
        this.labels[6].setFont(this.boldFont);
    }

    public boolean supportsElement(Object e) {
        return e instanceof MethodView;
    }

    public void prepareForElement(Object e) {
        MethodView n = (MethodView)e;
        this.labels[0].setText("method  : " + n.method.getMethodName());
        this.labels[1].setText("class   : " + n.method.getClassName());
        this.labels[2].setText(String.format("hits    : %d", n.method.getHits()));
        this.labels[3].setText(String.format("net     : %.3f ms", n.method.getNetTime()));
        this.labels[4].setText(String.format("avg net : %.3f ms", n.method.getNetTime() / (double)n.method.getHits()));
        this.labels[5].setText(String.format("self    : %.3f ms", n.method.getSelfTime()));
        this.labels[6].setText(String.format("avg self: %.3f ms", n.method.getSelfTime() / (double)n.method.getHits()));
        this.pack();
    }
}

