/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.sf.profiler4j.console.Console;
import org.jdom.Element;

public class TipDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTextPane messageTextPane = null;
    private JButton closeButton = null;
    private JButton nextButton = null;
    private JButton previousButton = null;
    private JCheckBox showNextTimeCheckBox = null;
    private List tips;
    private int index;
    private Console app;

    public TipDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(453, 348);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setTitle("Tip of the Day");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(4, 8, 4, 8);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridwidth = 4;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(4, 8, 8, 8);
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(4, 4, 8, 8);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(4, 8, 8, 8);
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridx = 2;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = 393;
            gridBagConstraints.ipady = 177;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(8, 8, 8, 8);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.jContentPane.add((Component)this.getCloseButton(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getNextButton(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getPreviousButton(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getShowNextTimeCheckBox(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getMessageTextPane());
        }
        return this.jScrollPane;
    }

    private JTextPane getMessageTextPane() {
        if (this.messageTextPane == null) {
            this.messageTextPane = new JTextPane();
            this.messageTextPane.setBackground(SystemColor.info);
            this.messageTextPane.setEditable(false);
            this.messageTextPane.setMargin(new Insets(8, 8, 8, 8));
            this.messageTextPane.setContentType("text/html");
        }
        return this.messageTextPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TipDialog.this.setVisible(false);
                }
            });
        }
        return this.closeButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setToolTipText("Show next tip");
            this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/next.gif")));
            this.nextButton.setText("Next");
            this.nextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TipDialog.this.index++;
                    TipDialog.this.updateNav();
                }
            });
        }
        return this.nextButton;
    }

    private JButton getPreviousButton() {
        if (this.previousButton == null) {
            this.previousButton = new JButton();
            this.previousButton.setToolTipText("Show previous tip");
            this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/profiler4j/console/images/previous.gif")));
            this.previousButton.setText("Previous");
            this.previousButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TipDialog.this.index--;
                    TipDialog.this.updateNav();
                }
            });
        }
        return this.previousButton;
    }

    private JCheckBox getShowNextTimeCheckBox() {
        if (this.showNextTimeCheckBox == null) {
            this.showNextTimeCheckBox = new JCheckBox();
            this.showNextTimeCheckBox.setSelected(true);
            this.showNextTimeCheckBox.setText("Show random tips when the application starts");
            this.showNextTimeCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    System.out.println(TipDialog.this.app);
                    System.out.println(TipDialog.this.app.getPrefs());
                    TipDialog.this.app.getPrefs().setShowTip(TipDialog.this.showNextTimeCheckBox.isSelected());
                }
            });
        }
        return this.showNextTimeCheckBox;
    }

    public void showTip(Console app) {
        this.app = app;
        this.setLocationRelativeTo(this.getOwner());
        if (app.getTipDoc() != null) {
            this.showNextTimeCheckBox.setSelected(app.getPrefs().isShowTip());
            Element rootElement = app.getTipDoc().getRootElement();
            this.tips = new ArrayList(rootElement.getChildren());
            Collections.shuffle(this.tips);
            this.index = 0;
            this.updateNav();
            this.setVisible(true);
        }
        this.dispose();
    }

    private void updateNav() {
        Element el = (Element)this.tips.get(this.index);
        this.messageTextPane.setText("<html>" + el.getText());
        this.messageTextPane.setCaretPosition(0);
        this.previousButton.setEnabled(this.index > 0);
        this.nextButton.setEnabled(this.index < this.tips.size() - 1);
    }
}

