/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.profiler4j.console.client.Snapshot;

public class TreeBuilder {
    private static final boolean DEBUG = false;
    private static DecimalFormat millisecFormat = new DecimalFormat("0.000", new DecimalFormatSymbols(Locale.US));
    private int maxRootCount = 50;
    private double minChildPercent = 0.01;
    private double minimumTotalTime = 1.0;
    private DefaultMutableTreeNode root;
    private Snapshot snapshot;
    private Map<Integer, Type> methodTypes;
    private List<Snapshot.Method> rootMethods;
    private Stack<Snapshot.Method> stack = new Stack();

    public TreeBuilder(Snapshot snapshot) {
        Locale.setDefault(Locale.US);
        this.snapshot = snapshot;
    }

    public void setMaxRootCount(int maxRootMethodCount) {
        this.maxRootCount = maxRootMethodCount;
    }

    public void setMinChildPercent(double minChildPercent) {
        this.minChildPercent = minChildPercent;
    }

    public DefaultMutableTreeNode buildTree() {
        this.findRootMethods();
        this.root = new DefaultMutableTreeNode();
        int ncut = this.maxRootCount;
        Collections.sort(this.rootMethods, new Comparator<Snapshot.Method>(){

            @Override
            public int compare(Snapshot.Method o1, Snapshot.Method o2) {
                return Double.compare(o1.getNetTime(), o2.getNetTime());
            }
        });
        for (Snapshot.Method g : this.rootMethods) {
            this.createNodes(this.root, g.getNetTime(), 1.0, null, g);
            if (--ncut != 0) continue;
            break;
        }
        return this.root;
    }

    private void findRootMethods() {
        this.methodTypes = new HashMap<Integer, Type>(this.snapshot.getMethods().size());
        this.rootMethods = new ArrayList<Snapshot.Method>();
        for (Snapshot.Method method : this.snapshot.getMethods().values()) {
            for (Snapshot.Method childMethod : method.getChildrenTimes().keySet()) {
                this.methodTypes.put(childMethod.getId(), Type.CHILD);
            }
        }
        for (Snapshot.Method method : this.snapshot.getMethods().values()) {
            if (this.methodTypes.containsKey(method.getId())) continue;
            this.rootMethods.add(method);
            this.methodTypes.put(method.getId(), Type.ROOT);
        }
    }

    private void createNodes(DefaultMutableTreeNode parentNode, double rootTotalTime, double contribFactor, Snapshot.Method parentMethod, Snapshot.Method method) {
        String text;
        if (parentMethod == null) {
            System.out.println();
        }
        Object preffix = null;
        if (this.stack.contains(method)) {
            return;
        }
        this.stack.push(method);
        if (method.getNetTime() < this.minimumTotalTime) {
            return;
        }
        double minPercent = this.minChildPercent;
        Type type = this.methodTypes.get(method.getId());
        if (parentMethod != null) {
            double childTime = parentMethod.getChildTime(method);
            double percent = childTime / parentMethod.getNetTime();
            double k = contribFactor;
            if ((contribFactor *= percent) < minPercent) {
                return;
            }
            text = String.format("[%2.0f%%; %6.0fms] %s", contribFactor * 100.0, k * childTime, this.formatMethod(method));
        } else {
            text = String.format("[%6.0fms] %s", method.getNetTime(), method.getName());
        }
        NodeInfo nodeInfo = new NodeInfo(text, method, contribFactor, type);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeInfo);
        parentNode.add(node);
        ArrayList<Snapshot.Method> children = new ArrayList<Snapshot.Method>(method.getChildrenTimes().keySet());
        Collections.sort(children, new ChildTimeComparator(method));
        for (Snapshot.Method child : children) {
            this.createNodes(node, rootTotalTime, contribFactor, method, child);
        }
        this.stack.pop();
    }

    private String formatMethod(Snapshot.Method method) {
        int p0 = method.getName().indexOf("#") + 1;
        int p1 = method.getName().indexOf("(");
        return method.getName().substring(p0, p1) + "()";
    }

    public static class NodeInfo {
        private String text;
        private Snapshot.Method methodInfo;
        private double percentFromRoot;
        private Type type;

        public NodeInfo(String text, Snapshot.Method methodInfo, double percentFromRoot, Type type) {
            this.text = text;
            this.methodInfo = methodInfo;
            this.percentFromRoot = percentFromRoot;
            this.type = type;
        }

        public Snapshot.Method getMethodInfo() {
            return this.methodInfo;
        }

        public String getText() {
            return this.text;
        }

        public double getPercentFromRoot() {
            return this.percentFromRoot;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ROOT,
        CHILD,
        SELF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildTimeComparator
    implements Comparator<Snapshot.Method> {
        private Snapshot.Method parent;

        ChildTimeComparator(Snapshot.Method parent) {
            this.parent = parent;
        }

        @Override
        public int compare(Snapshot.Method m1, Snapshot.Method m2) {
            return (int)Math.signum(this.parent.getChildTime(m1) - this.parent.getChildTime(m2));
        }
    }
}

