/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.message;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ChangeRequestAttribute;
import org.ice4j.attribute.ChangedAddressAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.SourceAddressAttribute;
import org.ice4j.message.Message;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.stack.StunStack;

public class MessageTest
extends TestCase {
    private Message bindingRequest = null;
    private Message bindingResponse = null;
    private MappedAddressAttribute mappedAddress = null;
    private SourceAddressAttribute sourceAddress = null;
    private ChangedAddressAttribute changedAddress = null;
    private ChangeRequestAttribute changeRequest = null;
    private MsgFixture msgFixture;
    private StunStack stunStack;

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.msgFixture.setUp();
        this.stunStack = new StunStack();
        this.bindingRequest = new Request();
        this.bindingRequest.setMessageType('\u0001');
        this.changeRequest = AttributeFactory.createChangeRequestAttribute(false, false);
        this.bindingRequest.addAttribute(this.changeRequest);
        this.bindingRequest.setTransactionID(MsgFixture.TRANSACTION_ID);
        this.bindingResponse = new Response();
        this.bindingResponse.setMessageType('\u0101');
        this.mappedAddress = AttributeFactory.createMappedAddressAttribute(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS, 1904, Transport.UDP));
        this.bindingResponse.addAttribute(this.mappedAddress);
        this.sourceAddress = AttributeFactory.createSourceAddressAttribute(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_2, 3478, Transport.UDP));
        this.bindingResponse.addAttribute(this.sourceAddress);
        this.changedAddress = AttributeFactory.createChangedAddressAttribute(new TransportAddress(MsgFixture.ADDRESS_ATTRIBUTE_ADDRESS_3, 3479, Transport.UDP));
        this.bindingResponse.addAttribute(this.changedAddress);
        this.bindingResponse.setTransactionID(MsgFixture.TRANSACTION_ID);
    }

    protected void tearDown() throws Exception {
        this.bindingRequest = null;
        this.bindingResponse = null;
        this.mappedAddress = null;
        this.sourceAddress = null;
        this.changedAddress = null;
        this.changeRequest = null;
        this.changeRequest = null;
        this.stunStack = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testAddAndGetAttribute() throws StunException {
        Response message = new Response();
        message.setMessageType('\u0101');
        message.addAttribute(this.mappedAddress);
        Attribute getResult = null;
        getResult = message.getAttribute(this.mappedAddress.getAttributeType());
        MessageTest.assertEquals((String)"Originally added attribute did not match the one retrned by getAttribute()", (Object)this.mappedAddress, (Object)getResult);
        message.addAttribute(this.sourceAddress);
        getResult = message.getAttribute(this.sourceAddress.getAttributeType());
        MessageTest.assertEquals((String)"The second attribute could not be extracted.", (Object)this.sourceAddress, (Object)getResult);
    }

    public void testEncode() throws StunException {
        byte[] expectedReturn = this.msgFixture.bindingRequest;
        byte[] actualReturn = this.bindingRequest.encode(this.stunStack);
        MessageTest.assertTrue((String)"A binding request was not properly encoded", (boolean)Arrays.equals(expectedReturn, actualReturn));
        expectedReturn = this.msgFixture.bindingResponse;
        actualReturn = this.bindingResponse.encode(this.stunStack);
        MessageTest.assertTrue((String)"A binding response was not properly encoded", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }

    public void testDecode() throws Exception {
        Message expectedReturn = this.bindingRequest;
        Message actualReturn = Message.decode(this.msgFixture.bindingRequest, '\u0000', (char)this.msgFixture.bindingRequest.length);
        MessageTest.assertEquals((String)"A binding request was not properly decoded", (Object)expectedReturn, (Object)actualReturn);
        expectedReturn = this.bindingResponse;
        actualReturn = Message.decode(this.msgFixture.bindingResponse, '\u0000', (char)this.msgFixture.bindingResponse.length);
        MessageTest.assertEquals((String)"A binding response was not properly decoded", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testEquals() throws StunException {
        Object target = null;
        boolean expectedReturn = false;
        boolean actualReturn = this.bindingRequest.equals(target);
        MessageTest.assertEquals((String)"Equals failed against a null target", (boolean)expectedReturn, (boolean)actualReturn);
        actualReturn = this.bindingResponse.equals(target);
        MessageTest.assertEquals((String)"Equals failed against a null target", (boolean)expectedReturn, (boolean)actualReturn);
        actualReturn = this.bindingRequest.equals(this.bindingResponse);
        MessageTest.assertEquals((String)"Equals failed against a different target", (boolean)expectedReturn, (boolean)actualReturn);
        actualReturn = this.bindingResponse.equals(this.bindingRequest);
        MessageTest.assertEquals((String)"Equals failed against a different target", (boolean)expectedReturn, (boolean)actualReturn);
        expectedReturn = true;
        Request binReqTarget = new Request();
        binReqTarget.setMessageType('\u0001');
        binReqTarget.addAttribute(this.changeRequest);
        actualReturn = this.bindingRequest.equals(binReqTarget);
        MessageTest.assertEquals((String)"Equals failed against an equal target", (boolean)expectedReturn, (boolean)actualReturn);
        Response binResTarget = new Response();
        binResTarget.setMessageType('\u0101');
        binResTarget.addAttribute(this.mappedAddress);
        binResTarget.addAttribute(this.sourceAddress);
        binResTarget.addAttribute(this.changedAddress);
        actualReturn = this.bindingResponse.equals(binResTarget);
        MessageTest.assertEquals((String)"Equals failed against a different target", (boolean)expectedReturn, (boolean)actualReturn);
    }

    public void testGetAttributeCount() {
        int expectedReturn = 1;
        int actualReturn = this.bindingRequest.getAttributeCount();
        MessageTest.assertEquals((String)"getAttributeCount failed for a bindingRequest", (int)expectedReturn, (int)actualReturn);
        expectedReturn = 3;
        actualReturn = this.bindingResponse.getAttributeCount();
        MessageTest.assertEquals((String)"getAttributeCount failed for a bindingRequest", (int)expectedReturn, (int)actualReturn);
    }

    public void testRemoveAttribute() {
        this.bindingRequest.removeAttribute(this.changeRequest.getAttributeType());
        MessageTest.assertNull((String)"An attribute was still in the request after being removed", (Object)this.bindingRequest.getAttribute(this.changeRequest.getAttributeType()));
        int expectedReturn = 0;
        int actualReturn = this.bindingRequest.getAttributeCount();
        MessageTest.assertEquals((String)"Attribute count did not change after removing an attribute", (int)expectedReturn, (int)actualReturn);
    }
}

