/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.pseudotcp;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.pseudotcp.MultiThreadSupportTest;
import org.ice4j.pseudotcp.Option;
import org.ice4j.pseudotcp.PseudoTcpSocket;
import org.ice4j.pseudotcp.PseudoTcpSocketFactory;
import org.ice4j.pseudotcp.PseudoTcpSocketImpl;
import org.ice4j.pseudotcp.PseudoTcpState;
import org.ice4j.pseudotcp.PseudoTcpTestBase;
import org.junit.Assert;

public class PseudoTcpStreamTest
extends MultiThreadSupportTest {
    private static final Logger logger = Logger.getLogger(PseudoTcpStreamTest.class.getName());

    public void testConnectTransferClose() throws IOException {
        Thread.setDefaultUncaughtExceptionHandler(this);
        int server_port = 49999;
        int transferTimeout = 5000;
        int singleStepCount = 34;
        final byte[] bufferSingle = PseudoTcpTestBase.createDummyData(34);
        int sizeA = 138746;
        final byte[] bufferA = PseudoTcpTestBase.createDummyData(138746);
        int sizeB = 983746;
        final byte[] bufferB = PseudoTcpTestBase.createDummyData(983746);
        final InetSocketAddress serverAddress = new InetSocketAddress(InetAddress.getLocalHost(), 49999);
        final PseudoTcpSocket server = new PseudoTcpSocketFactory().createSocket();
        Thread serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    server.setDebugName("L");
                    server.bind(serverAddress);
                    server.accept(5000);
                    byte[] rcvdSingle = new byte[34];
                    for (int i = 0; i < 34; ++i) {
                        rcvdSingle[i] = (byte)server.getInputStream().read();
                    }
                    Assert.assertArrayEquals((byte[])bufferSingle, (byte[])rcvdSingle);
                    byte[] recvdBufferA = PseudoTcpStreamTest.receiveBuffer(server.getInputStream(), 138746);
                    Assert.assertArrayEquals((byte[])bufferA, (byte[])recvdBufferA);
                    byte[] recvdBufferB = PseudoTcpStreamTest.receiveBuffer(server.getInputStream(), 983746);
                    Assert.assertArrayEquals((byte[])bufferB, (byte[])recvdBufferB);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        final PseudoTcpSocket client = new PseudoTcpSocketFactory().createSocket();
        Thread clientThread = new Thread(new Runnable(){

            public void run() {
                try {
                    client.setDebugName("R");
                    client.connect(serverAddress, 5000);
                    for (int i = 0; i < 34; ++i) {
                        client.getOutputStream().write(bufferSingle[i]);
                    }
                    client.getOutputStream().write(bufferA);
                    int partCount = 7;
                    boolean notExact = 983746 % partCount != 0;
                    int[] partsSize = notExact ? new int[partCount + 1] : new int[partCount];
                    for (int i = 0; i < partsSize.length; ++i) {
                        partsSize[i] = notExact && i == partCount ? 983746 % partCount : 983746 / partCount;
                    }
                    int written = 0;
                    for (int i = 0; i < partsSize.length; ++i) {
                        client.getOutputStream().write(bufferB, written, partsSize[i]);
                        written += partsSize[i];
                    }
                    junit.framework.Assert.assertEquals((int)983746, (int)written);
                    client.getOutputStream().flush();
                    client.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        serverThread.start();
        clientThread.start();
        try {
            boolean success = this.assert_wait_until(new MultiThreadSupportTest.WaitUntilDone(){

                public boolean isDone() {
                    return client.getState() == PseudoTcpState.TCP_CLOSED;
                }
            }, transferTimeout);
            if (success) {
                clientThread.join();
                serverThread.join();
                server.close();
            } else {
                PseudoTcpStreamTest.fail((String)"Transfer timeout");
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static byte[] receiveBuffer(InputStream input, int size) throws IOException {
        int rcvd = 0;
        byte[] buffer = new byte[size];
        rcvd += input.read(buffer);
        while (rcvd != size) {
            rcvd += input.read(buffer, rcvd, size - rcvd);
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.log(Level.FINER, "Received: " + rcvd);
        }
        return buffer;
    }

    public void testAccept() {
        try {
            PseudoTcpSocketImpl server = new PseudoTcpSocketImpl(0L);
            server.accept(10);
            PseudoTcpStreamTest.fail((String)"Should throw timeout exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doTestTimeout(final TimeoutOperationTest testOperation) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(this);
        int server_port = 49998;
        final InetSocketAddress serverAddress = new InetSocketAddress(InetAddress.getLocalHost(), 49998);
        final PseudoTcpSocketImpl server = new PseudoTcpSocketImpl(0L, new DatagramSocket(serverAddress));
        final PseudoTcpSocketImpl client = new PseudoTcpSocketImpl(0L);
        new Thread(new Runnable(){

            public void run() {
                try {
                    server.accept(2000);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    testOperation.testTimeout(server);
                    junit.framework.Assert.fail((String)"No expected timeout occured on operation");
                }
                catch (IOException e) {
                    try {
                        server.close();
                    }
                    catch (IOException exc) {
                        throw new RuntimeException(exc);
                    }
                }
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                try {
                    client.connect(serverAddress, 2000);
                    Thread.sleep(500L);
                    client.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }).start();
        boolean done = this.assert_wait_until(new MultiThreadSupportTest.WaitUntilDone(){

            public boolean isDone() {
                return server.getState() == PseudoTcpState.TCP_CLOSED;
            }
        }, 3000L);
        if (!done) {
            PseudoTcpStreamTest.fail((String)"Test timed out");
        }
    }

    public void testReadTimeout() throws Exception {
        this.doTestTimeout(new TimeoutOperationTest(){

            public void testTimeout(PseudoTcpSocketImpl socket) throws IOException {
                socket.setPTCPOption(Option.OPT_READ_TIMEOUT, 300L);
                socket.getInputStream().read(new byte[500]);
            }
        });
    }

    public void testWriteTimeout() throws Exception {
        this.doTestTimeout(new TimeoutOperationTest(){

            public void testTimeout(PseudoTcpSocketImpl socket) throws IOException {
                byte[] bigBuffer = new byte[184320];
                socket.setPTCPOption(Option.OPT_WRITE_TIMEOUT, 300L);
                socket.getOutputStream().write(bigBuffer);
            }
        });
    }

    public void testFlushTimeout() throws Exception {
        this.doTestTimeout(new TimeoutOperationTest(){

            public void testTimeout(PseudoTcpSocketImpl socket) throws IOException {
                byte[] buffer = new byte[92160];
                socket.setPTCPOption(Option.OPT_WRITE_TIMEOUT, 300L);
                try {
                    socket.getOutputStream().write(buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected exception: " + e);
                }
                socket.getOutputStream().flush();
            }
        });
    }

    private static interface TimeoutOperationTest {
        public void testTimeout(PseudoTcpSocketImpl var1) throws IOException;
    }
}

