/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.io.IOException;
import java.net.DatagramSocket;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import org.ice4j.ResponseCollector;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.Attribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.OptionalAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.ice.CompatibilityMode;
import org.ice4j.message.Indication;
import org.ice4j.message.Message;
import org.ice4j.message.MessageFactory;
import org.ice4j.message.Request;
import org.ice4j.message.Response;
import org.ice4j.security.CredentialsManager;
import org.ice4j.security.LongTermCredential;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.EventDispatcher;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.NetAccessManager;
import org.ice4j.stack.PacketLogger;
import org.ice4j.stack.RawMessage;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunClientTransaction;
import org.ice4j.stack.StunServerTransaction;
import org.ice4j.stack.TransactionID;

public class StunStack
implements MessageEventHandler {
    public static final int DEFAULT_THREAD_POOL_SIZE = 3;
    private static final Logger logger = Logger.getLogger(StunStack.class.getName());
    private static Mac mac;
    private NetAccessManager netAccessManager = null;
    private final CredentialsManager credentialsManager = new CredentialsManager();
    private final Hashtable<TransactionID, StunClientTransaction> clientTransactions = new Hashtable();
    private final Hashtable<TransactionID, StunServerTransaction> serverTransactions = new Hashtable();
    private final EventDispatcher eventDispatcher = new EventDispatcher();
    private static PacketLogger packetLogger;
    private final CompatibilityMode mode;

    public void setThreadPoolSize(int threadPoolSize) throws IllegalArgumentException {
        this.netAccessManager.setThreadPoolSize(threadPoolSize);
    }

    public void addSocket(IceSocketWrapper sock) {
        this.netAccessManager.addSocket(sock);
    }

    public void removeSocket(TransportAddress localAddr) {
        this.cancelTransactionsForAddress(localAddr);
        this.netAccessManager.removeSocket(localAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StunClientTransaction getClientTransaction(byte[] transactionID) {
        Hashtable<TransactionID, StunClientTransaction> hashtable = this.clientTransactions;
        synchronized (hashtable) {
            Collection<StunClientTransaction> cTrans = this.clientTransactions.values();
            for (StunClientTransaction tran : cTrans) {
                if (!tran.getTransactionID().equals(transactionID)) continue;
                return tran;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StunServerTransaction getServerTransaction(byte[] transactionID) {
        Hashtable<TransactionID, StunServerTransaction> hashtable = this.serverTransactions;
        synchronized (hashtable) {
            Collection<StunServerTransaction> sTrans = this.serverTransactions.values();
            for (StunServerTransaction tran : sTrans) {
                if (!tran.getTransactionID().equals(transactionID)) continue;
                return tran;
            }
        }
        return null;
    }

    public void cancelTransaction(TransactionID transactionID) {
        StunClientTransaction clientTransaction = this.clientTransactions.get(transactionID);
        if (clientTransaction != null) {
            clientTransaction.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTransactionsForAddress(TransportAddress localAddr) {
        Runnable tran;
        Map.Entry<TransactionID, Runnable> entry;
        Hashtable<TransactionID, Runnable> hashtable = this.clientTransactions;
        synchronized (hashtable) {
            Iterator<Map.Entry<TransactionID, StunClientTransaction>> clientTransactionsIter = this.clientTransactions.entrySet().iterator();
            while (clientTransactionsIter.hasNext()) {
                entry = clientTransactionsIter.next();
                tran = entry.getValue();
                if (((StunClientTransaction)tran).getLocalAddress().equals(localAddr)) {
                    clientTransactionsIter.remove();
                }
                ((StunClientTransaction)tran).cancel();
            }
        }
        hashtable = this.serverTransactions;
        synchronized (hashtable) {
            Iterator<Map.Entry<TransactionID, StunServerTransaction>> serverTransactionsIter = this.serverTransactions.entrySet().iterator();
            while (serverTransactionsIter.hasNext()) {
                entry = serverTransactionsIter.next();
                tran = (StunServerTransaction)entry.getValue();
                TransportAddress listenAddr = ((StunServerTransaction)tran).getLocalListeningAddress();
                TransportAddress sendingAddr = ((StunServerTransaction)tran).getSendingAddress();
                if (listenAddr.equals(localAddr) || sendingAddr != null && sendingAddr.equals(localAddr)) {
                    serverTransactionsIter.remove();
                }
                ((StunServerTransaction)tran).expire();
            }
        }
    }

    public StunStack() {
        this(CompatibilityMode.RFC5245);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StunStack(CompatibilityMode mode) {
        Class<StunStack> clazz = StunStack.class;
        synchronized (StunStack.class) {
            if (mac == null) {
                try {
                    mac = Mac.getInstance("HmacSHA1");
                }
                catch (NoSuchAlgorithmException nsaex) {
                    nsaex.printStackTrace();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mode = mode;
            this.netAccessManager = new NetAccessManager(this);
            if (mode == CompatibilityMode.GTALK) {
                this.netAccessManager.setThreadPoolSize(1);
            }
            return;
        }
    }

    NetAccessManager getNetAccessManager() {
        return this.netAccessManager;
    }

    public void sendIndication(Indication indication, TransportAddress sendTo, TransportAddress sendThrough) throws StunException {
        if (indication.getTransactionID() == null) {
            indication.setTransactionID(TransactionID.createNewTransactionID().getBytes());
        }
        try {
            this.getNetAccessManager().sendMessage(indication, sendThrough, sendTo);
        }
        catch (IllegalArgumentException iaex) {
            throw new StunException(2, "Failed to send STUN indication: " + indication, iaex);
        }
        catch (IOException ioex) {
            throw new StunException(4, "Failed to send STUN indication: " + indication, ioex);
        }
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, TransportAddress sendThrough, ResponseCollector collector) throws IOException, IllegalArgumentException {
        return this.sendRequest(request, sendTo, sendThrough, collector, TransactionID.createNewTransactionID());
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, TransportAddress sendThrough, ResponseCollector collector, TransactionID transactionID) throws IOException, IllegalArgumentException {
        StunClientTransaction clientTransaction = new StunClientTransaction(this, request, sendTo, sendThrough, collector, transactionID);
        this.clientTransactions.put(clientTransaction.getTransactionID(), clientTransaction);
        clientTransaction.sendRequest();
        return clientTransaction.getTransactionID();
    }

    public TransactionID sendRequest(Request request, TransportAddress sendTo, DatagramSocket sendThrough, ResponseCollector collector) throws IOException, IllegalArgumentException {
        TransportAddress sendThroughAddr = new TransportAddress(sendThrough.getLocalAddress(), sendThrough.getLocalPort(), Transport.UDP);
        return this.sendRequest(request, sendTo, sendThroughAddr, collector);
    }

    public void sendResponse(byte[] transactionID, Response response, TransportAddress sendThrough, TransportAddress sendTo) throws StunException, IOException, IllegalArgumentException {
        TransactionID tid = TransactionID.createTransactionID(this, transactionID);
        StunServerTransaction sTran = this.serverTransactions.get(tid);
        if (sTran == null) {
            throw new StunException(3, "The transaction specified in the response (tid=" + tid.toString() + ") " + "object does not exist.");
        }
        if (sTran.isRetransmitting()) {
            throw new StunException(5, "The transaction specified in the response (tid=" + tid.toString() + ") " + "has already seen a previous response. " + "Response was:\n" + sTran.getResponse());
        }
        sTran.sendResponse(response, sendThrough, sendTo);
    }

    public void addIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
        this.eventDispatcher.addIndicationListener(localAddr, indicationListener);
    }

    public void addOldIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
        this.eventDispatcher.addOldIndicationListener(localAddr, indicationListener);
    }

    public void addRequestListener(RequestListener requestListener) {
        this.eventDispatcher.addRequestListener(requestListener);
    }

    public void removeIndicationListener(TransportAddress localAddr, MessageEventHandler indicationListener) {
    }

    public void removeRequestListener(RequestListener listener) {
        this.eventDispatcher.removeRequestListener(listener);
    }

    public void addRequestListener(TransportAddress localAddress, RequestListener listener) {
        this.eventDispatcher.addRequestListener(localAddress, listener);
    }

    synchronized void removeClientTransaction(StunClientTransaction tran) {
        this.clientTransactions.remove(tran.getTransactionID());
    }

    synchronized void removeServerTransaction(StunServerTransaction tran) {
        this.serverTransactions.remove(tran.getTransactionID());
    }

    public void handleMessageEvent(StunMessageEvent event) {
        Message msg = event.getMessage();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Received a message on " + event.getLocalAddress() + " of type:" + msg.getMessageType());
        }
        if (msg instanceof Request) {
            logger.finest("parsing request");
            TransactionID serverTid = event.getTransactionID();
            StunServerTransaction sTran = this.serverTransactions.get(serverTid);
            if (sTran != null) {
                logger.finest("found an existing transaction");
                try {
                    sTran.retransmitResponse();
                    logger.finest("Response retransmitted");
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Failed to retransmit a stun response", ex);
                }
                if (!Boolean.getBoolean("org.ice4j.PROPAGATE_RECEIVED_RETRANSMISSIONS")) {
                    return;
                }
            } else {
                logger.finest("existing transaction not found");
                sTran = new StunServerTransaction(this, serverTid, event.getLocalAddress(), event.getRemoteAddress());
                try {
                    sTran.start();
                }
                catch (OutOfMemoryError t) {
                    logger.info("STUN transaction thread start failed:" + t);
                    return;
                }
                this.serverTransactions.put(serverTid, sTran);
            }
            try {
                this.validateRequestAttributes(event);
            }
            catch (Exception exc) {
                logger.log(Level.FINE, "Failed to validate msg: " + event, exc);
                return;
            }
            try {
                this.eventDispatcher.fireMessageEvent(event);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Received an invalid request.", t);
                Throwable cause = t.getCause();
                if (t instanceof StunException && ((StunException)t).getID() == 5 || cause != null && cause instanceof StunException && ((StunException)cause).getID() == 5) {
                    return;
                }
                Response error = t instanceof IllegalArgumentException ? MessageFactory.createBindingErrorResponse('\u0190', t.getMessage()) : MessageFactory.createBindingErrorResponse('\u01f4', "Oops! Something went wrong on our side :(");
                try {
                    this.sendResponse(event.getTransactionID().getBytes(), error, event.getLocalAddress(), event.getRemoteAddress());
                }
                catch (Exception exc) {
                    logger.log(Level.FINE, "Couldn't send a server error response", exc);
                }
            }
        } else if (msg instanceof Response) {
            TransactionID tid = event.getTransactionID();
            StunClientTransaction tran = this.clientTransactions.remove(tid);
            if (tran != null) {
                tran.handleResponse(event);
            } else {
                logger.fine("Dropped response - no matching client tran found.");
                logger.fine("response tid was - " + tid);
                logger.fine("all tids in stock were" + this.clientTransactions);
            }
        } else if (msg instanceof Indication) {
            this.eventDispatcher.fireMessageEvent(event);
        }
    }

    public CredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    public void shutDown() {
        Runnable tran;
        TransactionID item;
        this.eventDispatcher.removeAllListeners();
        Enumeration<TransactionID> tids = this.clientTransactions.keys();
        while (tids.hasMoreElements()) {
            item = tids.nextElement();
            tran = this.clientTransactions.remove(item);
            if (tran == null) continue;
            ((StunClientTransaction)tran).cancel();
        }
        tids = this.serverTransactions.keys();
        while (tids.hasMoreElements()) {
            item = tids.nextElement();
            tran = this.serverTransactions.remove(item);
            if (tran == null) continue;
            ((StunServerTransaction)tran).expire();
        }
        this.netAccessManager.stop();
    }

    private void validateRequestAttributes(StunMessageEvent evt) throws IllegalArgumentException, StunException, IOException {
        if (this.mode != CompatibilityMode.RFC5245) {
            return;
        }
        Message request = evt.getMessage();
        UsernameAttribute unameAttr = (UsernameAttribute)request.getAttribute('\u0006');
        String username = null;
        if (unameAttr != null && !this.validateUsername(username = LongTermCredential.toString(unameAttr.getUsername()))) {
            Response error = MessageFactory.createBindingErrorResponse('\u0191', "unknown user " + username);
            this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
            throw new IllegalArgumentException("Non-recognized username: " + username);
        }
        MessageIntegrityAttribute msgIntAttr = (MessageIntegrityAttribute)request.getAttribute('\b');
        if (msgIntAttr != null) {
            if (unameAttr == null) {
                Response error = MessageFactory.createBindingErrorResponse('\u0190', "missing username");
                this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
                throw new IllegalArgumentException("Missing USERNAME in the presence of MESSAGE-INTEGRITY: ");
            }
            if (!this.validateMessageIntegrity(msgIntAttr, username, true, evt.getRawMessage())) {
                Response error = MessageFactory.createBindingErrorResponse('\u0191', "Wrong MESSAGE-INTEGRITY value");
                this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
                throw new IllegalArgumentException("Wrong MESSAGE-INTEGRITY value.");
            }
        } else if (Boolean.getBoolean("org.ice4j.REQUIRE_MESSAGE_INTEGRITY")) {
            Response error = MessageFactory.createBindingErrorResponse('\u0191', "Missing MESSAGE-INTEGRITY.");
            this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
            throw new IllegalArgumentException("Missing MESSAGE-INTEGRITY.");
        }
        List<Attribute> allAttributes = request.getAttributes();
        StringBuffer sBuff = new StringBuffer();
        for (Attribute attr : allAttributes) {
            if (!(attr instanceof OptionalAttribute) || attr.getAttributeType() >= '\u8000') continue;
            sBuff.append(attr.getAttributeType());
        }
        if (sBuff.length() > 0) {
            Response error = MessageFactory.createBindingErrorResponse('\u01a4', "unknown attribute ", sBuff.toString().toCharArray());
            this.sendResponse(request.getTransactionID(), error, evt.getLocalAddress(), evt.getRemoteAddress());
            throw new IllegalArgumentException("Unknown attribute(s).");
        }
    }

    public boolean validateMessageIntegrity(MessageIntegrityAttribute msgInt, String username, boolean shortTermCredentialMechanism, RawMessage message) {
        byte[] expectedMsgIntHmacSha1Content;
        byte[] key;
        int colon = -1;
        if (username == null || username.length() < 1 || shortTermCredentialMechanism && (colon = username.indexOf(":")) < 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a message with an improperly formatted username");
            }
            return false;
        }
        if (shortTermCredentialMechanism) {
            username = username.substring(0, colon);
        }
        if ((key = this.getCredentialsManager().getLocalKey(username)) == null) {
            return false;
        }
        byte[] binMsg = new byte[msgInt.getLocationInMessage()];
        System.arraycopy(message.getBytes(), 0, binMsg, 0, binMsg.length);
        char messageLength = (char)(binMsg.length + 4 + msgInt.getDataLength() - 20);
        binMsg[2] = (byte)(messageLength >> 8);
        binMsg[3] = (byte)(messageLength & 0xFF);
        try {
            expectedMsgIntHmacSha1Content = MessageIntegrityAttribute.calculateHmacSha1(binMsg, 0, binMsg.length, key);
        }
        catch (IllegalArgumentException iaex) {
            expectedMsgIntHmacSha1Content = null;
        }
        byte[] msgIntHmacSha1Content = msgInt.getHmacSha1Content();
        if (!Arrays.equals(expectedMsgIntHmacSha1Content, msgIntHmacSha1Content)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a message with a wrong MESSAGE-INTEGRITY HMAC-SHA1 signature: expected: " + StunStack.toHexString(expectedMsgIntHmacSha1Content) + ", received: " + StunStack.toHexString(msgIntHmacSha1Content));
            }
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Successfully verified msg integrity");
        }
        return true;
    }

    private static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hexStringBuilder = new StringBuilder(2 * bytes.length);
        char[] hexes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            hexStringBuilder.append(hexes[(b & 0xF0) >> 4]);
            hexStringBuilder.append(hexes[b & 0xF]);
        }
        return hexStringBuilder.toString();
    }

    private boolean validateUsername(String username) {
        int colon = username.indexOf(":");
        if (username.length() < 1 || colon < 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Received a message with an improperly formatted username");
            }
            return false;
        }
        String lfrag = username.substring(0, colon);
        return this.getCredentialsManager().checkLocalUserName(lfrag);
    }

    public static PacketLogger getPacketLogger() {
        return packetLogger;
    }

    public static void setPacketLogger(PacketLogger packetLogger) {
        StunStack.packetLogger = packetLogger;
    }

    public static boolean isPacketLoggerEnabled() {
        return packetLogger != null && packetLogger.isEnabled();
    }

    public CompatibilityMode getCompatibilityMode() {
        return this.mode;
    }
}

